/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Choice
extends Component
implements ItemSelectable,
Accessible {
    Vector pItems = new Vector();
    int selectedIndex = -1;
    transient ItemListener itemListener;
    private static final String base = "choice";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -4075310674757313071L;
    private int choiceSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createChoice(this);
            }
            super.addNotify();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int n) {
        return this.getItemImpl(n);
    }

    final String getItemImpl(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        Choice choice = this;
        synchronized (choice) {
            this.addItemNoInvalidate(string);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    private void addItemNoInvalidate(String string) {
        if (string == null) {
            throw new NullPointerException("cannot add null item to Choice");
        }
        this.pItems.addElement(string);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.addItem(string, this.pItems.size() - 1);
        }
        if (this.selectedIndex < 0) {
            this.select(0);
        }
    }

    public void insert(String string, int n) {
        Choice choice = this;
        synchronized (choice) {
            if (n < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n2 = this.getItemCount();
            Vector vector = new Vector();
            int n3 = n;
            while (n3 < n2) {
                vector.addElement(this.getItem(n));
                this.removeNoInvalidate(n);
                ++n3;
            }
            this.addItemNoInvalidate(string);
            int n4 = 0;
            while (n4 < vector.size()) {
                this.addItemNoInvalidate((String)vector.elementAt(n4));
                ++n4;
            }
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public void remove(String string) {
        Choice choice = this;
        synchronized (choice) {
            int n = this.pItems.indexOf(string);
            if (n < 0) {
                throw new IllegalArgumentException("item " + string + " not found in choice");
            }
            this.removeNoInvalidate(n);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public void remove(int n) {
        Choice choice = this;
        synchronized (choice) {
            this.removeNoInvalidate(n);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    private void removeNoInvalidate(int n) {
        this.pItems.removeElementAt(n);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.remove(n);
        }
        if (this.pItems.size() == 0) {
            this.selectedIndex = -1;
        } else if (this.selectedIndex == n) {
            this.select(0);
        } else if (this.selectedIndex > n) {
            this.select(this.selectedIndex - 1);
        }
    }

    public void removeAll() {
        Choice choice = this;
        synchronized (choice) {
            if (this.peer != null) {
                ((ChoicePeer)this.peer).removeAll();
            }
            this.pItems.removeAllElements();
            this.selectedIndex = -1;
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex >= 0 ? this.getItem(this.selectedIndex) : null;
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex >= 0) {
            Object[] objectArray = new Object[]{this.getItem(this.selectedIndex)};
            return objectArray;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int n) {
        if (n >= this.pItems.size() || n < 0) {
            throw new IllegalArgumentException("illegal Choice item position: " + n);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = n;
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            if (choicePeer != null) {
                choicePeer.select(n);
            }
        }
    }

    public synchronized void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public EventListener[] getListeners(Class clazz) {
        ItemListener itemListener = null;
        if (clazz != (class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = Choice.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener)) {
            return super.getListeners(clazz);
        }
        itemListener = this.itemListener;
        return AWTEventMulticaster.getListeners(itemListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    protected String paramString() {
        return super.paramString() + ",current=" + this.getSelectedItem();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int n) {
            return null;
        }

        public boolean doAccessibleAction(int n) {
            return false;
        }
    }
}

