/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.engine;

import java.util.EventObject;
import sun.plugin.converter.ResourceHandler;

public class ConverterProgressEvent
extends EventObject {
    public static final int PREPARING = -10;
    public static final int CONVERTING = -11;
    public static final int COPYING = -12;
    public static final int DONE = -13;
    public static final int ALL_DONE = -14;
    public static final int DEST_DIR_NOT_CREATED = -15;
    public static final int ERROR = -16;
    private String sourcePath = "";
    private String destinationPath = "";
    private String backupPath = "";
    private String currentFile = "";
    private int status;
    private int filesProcessed = 0;
    private int appletsFound = 0;
    private int errorsFound = 0;

    public ConverterProgressEvent(Object object) {
        super(object);
        this.setStatus(-10);
    }

    public ConverterProgressEvent(Object object, String string, String string2, String string3, int n, int n2, int n3, int n4) {
        super(object);
        this.currentFile = string3;
        this.status = n;
        this.filesProcessed = n2;
        this.appletsFound = n3;
        this.errorsFound = n4;
        this.sourcePath = string;
        this.destinationPath = string2;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String string) {
        this.currentFile = string;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        switch (this.status) {
            case -10: {
                return ResourceHandler.getMessage("progress_event.preparing");
            }
            case -11: {
                return ResourceHandler.getMessage("progress_event.converting");
            }
            case -12: {
                return ResourceHandler.getMessage("progress_event.copying");
            }
            case -14: 
            case -13: {
                return ResourceHandler.getMessage("progress_event.done");
            }
            case -15: {
                return ResourceHandler.getMessage("progress_event.destdirnotcreated");
            }
            case -16: {
                return ResourceHandler.getMessage("progress_event.error");
            }
        }
        return "";
    }

    public void setStatus(int n) {
        this.status = n == -11 || n == -13 || n == -12 || n == -14 || n == -15 || n == -16 ? n : -10;
    }

    public int getFilesProcessed() {
        return this.filesProcessed;
    }

    public void setFilesProcessed(int n) {
        if (n >= 0) {
            this.filesProcessed = n;
        }
    }

    public int getAppletsFound() {
        return this.appletsFound;
    }

    public void setAppletsFound(int n) {
        if (n >= 0) {
            this.appletsFound = n;
        }
    }

    public int getErrorsFound() {
        return this.errorsFound;
    }

    public void setErrorsFound(int n) {
        if (n >= 0) {
            this.errorsFound = n;
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String string) {
        this.sourcePath = string;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String string) {
        this.destinationPath = string;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(String string) {
        this.backupPath = string;
    }

    public String toString() {
        String string = "[ConverterProgressEvent";
        string = string + this.sourcePath;
        string = string + this.destinationPath;
        string = string + this.backupPath;
        string = string + this.currentFile;
        string = string + this.status;
        string = string + this.filesProcessed;
        string = string + this.appletsFound;
        string = string + this.errorsFound + "]";
        return string;
    }
}

