/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.filechooser.GenericFileSystemView;
import javax.swing.filechooser.UnixFileSystemView;
import javax.swing.filechooser.WindowsFileSystemView;

public abstract class FileSystemView {
    static FileSystemView windowsFileSystemView = null;
    static FileSystemView unixFileSystemView = null;
    static FileSystemView genericFileSystemView = null;

    public static FileSystemView getFileSystemView() {
        if (File.separatorChar == '\\') {
            if (windowsFileSystemView == null) {
                windowsFileSystemView = new WindowsFileSystemView();
            }
            return windowsFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystemView == null) {
                unixFileSystemView = new UnixFileSystemView();
            }
            return unixFileSystemView;
        }
        if (genericFileSystemView == null) {
            genericFileSystemView = new GenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public abstract boolean isRoot(File var1);

    public abstract File createNewFolder(File var1) throws IOException;

    public abstract boolean isHiddenFile(File var1);

    public abstract File[] getRoots();

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File createFileObject(File file, String string) {
        if (file == null) {
            return new File(string);
        }
        return new File(file, string);
    }

    public File createFileObject(String string) {
        return new File(string);
    }

    public File[] getFiles(File file, boolean bl) {
        Vector vector = new Vector();
        File[] fileArray = file.listFiles();
        int n = fileArray == null ? 0 : fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (!(!file2.isFile() && !file2.isDirectory() || bl && this.isHiddenFile(file2))) {
                vector.addElement(file2);
            }
            ++n2;
        }
        return (File[])vector.toArray(new File[vector.size()]);
    }

    public File getParentDirectory(File file) {
        File file2;
        String string;
        if (file != null && (string = (file2 = this.createFileObject(file.getAbsolutePath())).getParent()) != null) {
            return new File(string);
        }
        return null;
    }
}

