/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Hashtable;

public abstract class InputStreamHook
extends ObjectInputStream {
    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        this.defaultReadObjectDelegate();
    }

    public abstract void defaultReadObjectDelegate();

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        Hashtable hashtable = (Hashtable)this.readObject();
        return new HookGetFields(hashtable);
    }

    private class HookGetFields
    extends ObjectInputStream.GetField {
        private Hashtable fields = null;

        HookGetFields(Hashtable hashtable) {
            this.fields = hashtable;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }

        public boolean defaulted(String string) throws IOException, IllegalArgumentException {
            return !this.fields.containsKey(string);
        }

        public boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return bl;
            }
            return (Boolean)this.fields.get(string);
        }

        public char get(String string, char c) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return c;
            }
            return ((Character)this.fields.get(string)).charValue();
        }

        public byte get(String string, byte by) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return by;
            }
            return (Byte)this.fields.get(string);
        }

        public short get(String string, short s) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return s;
            }
            return (Short)this.fields.get(string);
        }

        public int get(String string, int n) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return n;
            }
            return (Integer)this.fields.get(string);
        }

        public long get(String string, long l) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return l;
            }
            return (Long)this.fields.get(string);
        }

        public float get(String string, float f) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return f;
            }
            return ((Float)this.fields.get(string)).floatValue();
        }

        public double get(String string, double d) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return d;
            }
            return (Double)this.fields.get(string);
        }

        public Object get(String string, Object object) throws IOException, IllegalArgumentException {
            if (this.defaulted(string)) {
                return object;
            }
            return this.fields.get(string);
        }

        public String toString() {
            return this.fields.toString();
        }
    }
}

