/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mpeg3protos.h"

#include <stdlib.h>
#include <string.h>

mpeg3_t* mpeg3_new(xmps_media_plugin_t *media)
{
  mpeg3_t *file = calloc(1, sizeof(mpeg3_t));

  if(media == NULL) {
    return NULL;
  }

  file->cpus = 1;
  file->fs = mpeg3_new_fs(media);
  file->have_mmx = 1;
  file->demuxer = mpeg3_new_demuxer(file, 0, 0, 0, -1);
  
  return file;
}

int mpeg3_delete(mpeg3_t *file)
{
  int i;
	
  for(i = 0; i < file->total_vstreams; i++)
    mpeg3_delete_vtrack(file, file->vtrack[i]);
  
  for(i = 0; i < file->total_astreams; i++)
    mpeg3_delete_atrack(file, file->atrack[i]);

  mpeg3_delete_fs(file->fs);
  mpeg3_delete_demuxer(file->demuxer);
  free(file);

  return 0;
}

