/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * xmps_playlist.c :  playlist functions.
 *
 */
/* includes */

#include <stdlib.h>
#include <xmps_playlist.h>

/* functions */

xmps_playlist_t* xmps_playlist_new()
{
  xmps_playlist_t *playlist;

  playlist              = (xmps_playlist_t *) malloc(sizeof(xmps_playlist_t));
  playlist->nbr_items   = 0;
  playlist->current_pos = 0;
  playlist->list        = NULL;

  return playlist;
}

unsigned int xmps_playlist_get_nbr_items(xmps_playlist_t *playlist)
{
  if(playlist != NULL)
    return playlist->nbr_items;
  else
    return -1;
}

unsigned int xmps_playlist_get_current_pos(xmps_playlist_t *playlist)
{
  if(playlist != NULL) {
    return playlist->current_pos;
  }
  else {
    return -1;
  }
}

int xmps_playlist_add(xmps_playlist_t *playlist, xmps_item_t *item)
{
  if(playlist != NULL && item != NULL) {
    
    XMPS_DEBUG("adding %s", 
	       item->full_path);
    
    playlist->list = g_list_append(playlist->list, item);
    playlist->nbr_items++;
    
    return 1;
  }
  else {
    return -1;
  }
}

xmps_item_t *xmps_playlist_get_item(xmps_playlist_t *playlist)
{
  if(playlist != NULL && playlist->nbr_items > 0)
    return (xmps_item_t *) g_list_nth_data(playlist->list, playlist->current_pos);
  else
    return NULL;
}


xmps_item_t *xmps_playlist_get_item_at(xmps_playlist_t *playlist, unsigned int i)
{
  if(playlist != NULL && i < playlist->nbr_items)
    return (xmps_item_t *) g_list_nth_data(playlist->list, i);
  else
    return NULL;
}

int xmps_playlist_remove_item_at(xmps_playlist_t *playlist, unsigned int i)
{
  if(playlist != NULL && ( playlist->nbr_items > 0 ) && ( i < playlist->nbr_items )) {

    if(i == 0) {

      if(playlist->nbr_items == 1) {

	xmps_playlist_clear(playlist);
      }
      else if(playlist->list != NULL) {

	playlist->nbr_items--;
	playlist->list = playlist->list->next;
      }

      return 1;
    }
    else {

      if(i == playlist->nbr_items - 1) {

	playlist->nbr_items--;
	g_list_nth(playlist->list, i - 1)->next = NULL;
      }
      else {

	playlist->nbr_items--;
	g_list_nth(playlist->list, i - 1)->next = g_list_nth(playlist->list, i + 1);
      }

      return 1;
    }

  }
  
  return 0;
}

int xmps_playlist_toggle_selection_at(xmps_playlist_t *playlist, unsigned int i)
{
  if(playlist != NULL && i < playlist->nbr_items) {

    if(((xmps_item_t *) g_list_nth_data(playlist->list, i))->selected == 1) {

      ((xmps_item_t *) g_list_nth_data(playlist->list, i))->selected = 0;
    }
    else {
      ((xmps_item_t *) g_list_nth_data(playlist->list, i))->selected = 1;
    }
  
    return 1;
  }

  return 0;
}

int xmps_playlist_select_at(xmps_playlist_t *playlist, unsigned int i)
{
  if(playlist != NULL && i < playlist->nbr_items) {

    ((xmps_item_t *) g_list_nth_data(playlist->list, i))->selected = 1;
    return 1;
  }

  return 0;
}

int xmps_playlist_unselect_at(xmps_playlist_t *playlist, unsigned int i)
{
  if(playlist != NULL && i < playlist->nbr_items) {

    ((xmps_item_t *) g_list_nth_data(playlist->list, i))->selected = 0;
    return 1;
  }

  return 0;
}

int xmps_playlist_next(xmps_playlist_t *playlist)
{
  if(playlist != NULL)
    {
      if( playlist->current_pos < playlist->nbr_items - 1)
	{
	  playlist->current_pos++;
	  return 1;
	}
      else
	return 0;
    }
  else
    return 0;
}

int xmps_playlist_prev(xmps_playlist_t *playlist)
{
  if(playlist != NULL)
    {
      if( playlist->current_pos > 0)
	{
	  playlist->current_pos--;
	  return 1;
	}
      else
	return 0;
    }
  else
    return 0;
}

int xmps_playlist_set_pos(xmps_playlist_t *playlist, unsigned int pos)
{
  if(playlist != NULL && pos >= 0 && pos < playlist->nbr_items)
    {
      playlist->current_pos = pos;
      return 1;
    }
  else
    return 0;
}

void xmps_playlist_reset(xmps_playlist_t *playlist)
{
  if(playlist != NULL)
    playlist->current_pos = 0;
}


void xmps_playlist_destroy(xmps_playlist_t *playlist)
{
  if(playlist != NULL)
    free(playlist);
}


void xmps_playlist_clear(xmps_playlist_t *playlist)
{
  if(playlist != NULL)
    {
      playlist->nbr_items   = 0;
      playlist->current_pos = 0;
      playlist->list        = NULL;      
    }
}
