/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * xmps_file_info.h
 *
 * XMPS Video Adapter
 * @Author Chavarria Damien.
 * 	   Copyright 1999-2000
 */

#include "xmps_file_info.h"

GtkWidget *playback_file_info = NULL;

/* 
 * functions 
 *
 */

void
on_button2_clicked(GtkButton       *button,
		   gpointer         user_data)
{
  gtk_widget_hide(playback_file_info);
}


void xmps_file_info_create(xmps_session_t *xmps_session)
{
  GtkWidget *frame1;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *table1;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *media_name;
  GtkWidget *media_size;
  GtkWidget *media_type;
  GtkWidget *label2;
  GtkWidget *table2;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *label10;
  GtkWidget *video_resolution;
  GtkWidget *system_layer;
  GtkWidget *frame_rate;
  GtkWidget *video_compression;
  GtkWidget *label3;
  GtkWidget *table3;
  GtkWidget *label11;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkWidget *audio_channels;
  GtkWidget *audio_frequency;
  GtkWidget *audio_bits;
  GtkWidget *audio_compression;
  GtkWidget *button2;
  GList     *system_output;
  
  xmps_video_info_t *video_info;
  xmps_audio_info_t *audio_info;
  double            *frame_rate_p;
  char              *temp;

  if(xmps_session == NULL || ( ((xmps_playback_t *) xmps_session->user_data)->video_setup_ok == 0 && ((xmps_playback_t *) xmps_session->user_data)->audio_setup_ok == 0) ) {
    return;
  }

  playback_file_info = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (playback_file_info), "playback_file_info", playback_file_info);
  gtk_container_set_border_width (GTK_CONTAINER (playback_file_info), 3);
  gtk_window_set_title (GTK_WINDOW (playback_file_info), "Playback info");
  gtk_window_set_position (GTK_WINDOW (playback_file_info), GTK_WIN_POS_CENTER);

  frame1 = gtk_frame_new (" Playback Infos : ");
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_container_add (GTK_CONTAINER (playback_file_info), frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (frame1), vbox1);

  label1 = gtk_label_new ("File Infos:");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (label1), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (label1), 5, 0);

  table1 = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 10);

  label4 = gtk_label_new ("Media Name:");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label4), 5, 0);

  label5 = gtk_label_new ("Media Size:");
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label5), 5, 0);

  label6 = gtk_label_new ("Media Type:");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label6), 5, 0);

  media_name = gtk_label_new (((xmps_playback_t *) xmps_session->user_data)->media_name);
  gtk_widget_ref (media_name);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "media_name", media_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (media_name);
  gtk_table_attach (GTK_TABLE (table1), media_name, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (media_name), 0, 0.5);

  media_size = gtk_label_new ("");
  gtk_widget_ref (media_size);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "media_size", media_size,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (media_size);
  gtk_table_attach (GTK_TABLE (table1), media_size, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (media_size), 0, 0.5);

  media_type = gtk_label_new ("File");
  gtk_widget_ref (media_type);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "media_type", media_type,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (media_type);
  gtk_table_attach (GTK_TABLE (table1), media_type, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (media_type), 0, 0.5);

  video_info = xmps_playback_get_video_info(xmps_session);
  audio_info = xmps_playback_get_audio_info(xmps_session);

  label2 = gtk_label_new ("Video Infos:");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (label2), 5, 0);

  table2 = gtk_table_new (4, 2, FALSE);
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (vbox1), table2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 10);

  label7 = gtk_label_new ("System Layer:");
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (table2), label7, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

  label8 = gtk_label_new ("Frame Rate:");
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

  label9 = gtk_label_new ("Video Resolution:");
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table2), label9, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

  label10 = gtk_label_new ("Video Compression:");
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10);
  gtk_table_attach (GTK_TABLE (table2), label10, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label10), 0, 0.5);

  if(video_info != NULL) {
    temp = (char *) malloc(20);
    sprintf(temp, "%.3dx%.3d", video_info->width, video_info->height);
    video_resolution = gtk_label_new (temp);
  }
  else {
    video_resolution = gtk_label_new ("");
  }

  gtk_widget_ref (video_resolution);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "video_resolution", video_resolution,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (video_resolution);
  gtk_table_attach (GTK_TABLE (table2), video_resolution, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (video_resolution), 0, 0.5);

  system_layer = gtk_label_new (((xmps_playback_t *) xmps_session->user_data)->system->name);
  gtk_widget_ref (system_layer);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "system_layer", system_layer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (system_layer);
  gtk_table_attach (GTK_TABLE (table2), system_layer, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (system_layer), 0, 0.5);

  if(((xmps_playback_t *) xmps_session->user_data)->video_setup_ok) {
    
    frame_rate_p = (double *) ((xmps_playback_t *) xmps_session->user_data)->system->get(((xmps_playback_t *) xmps_session->user_data)->system,
											       XMPS_FLAG_FRAMERATE,
											       NULL);
    if(frame_rate_p != NULL) {
      temp = (char *) malloc(20);
      sprintf(temp, "%f", *frame_rate_p);
      frame_rate = gtk_label_new (temp);
    }
    else {
      frame_rate = gtk_label_new ("Not available");
    }
  }
  else {
    frame_rate = gtk_label_new ("Not available");
  }

  gtk_widget_ref (frame_rate);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "frame_rate", frame_rate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_rate);
  gtk_table_attach (GTK_TABLE (table2), frame_rate, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (frame_rate), 0, 0.5);


  video_compression = gtk_label_new ("");

  for(system_output = (GList *) ((xmps_playback_t *) xmps_session->user_data)->system->get(((xmps_playback_t *) xmps_session->user_data)->system, 
											   XMPS_FLAG_OUTPUT_LIST, 
											   NULL); 
      system_output != NULL; 
      system_output = g_list_next(system_output)) {
		      
    if(system_output->data != NULL) {
      
      xmps_data_t *data_stream;
      
      data_stream = (xmps_data_t *) system_output->data; 
      
      switch(data_stream->type) {
      
      case XMPS_DATA_VIDEO_COMP:
	{
	  video_compression = gtk_label_new (data_stream->video_compression);
	}
	break;
      default:
	break;
	
      }
    }
  }
  
  gtk_widget_ref (video_compression);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "video_compression", video_compression,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (video_compression);
  gtk_table_attach (GTK_TABLE (table2), video_compression, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (video_compression), 0, 0.5);

  label3 = gtk_label_new ("Audio Infos:");
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox1), label3, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label3), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (label3), 5, 0);

  table3 = gtk_table_new (4, 2, FALSE);
  gtk_widget_ref (table3);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "table3", table3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (vbox1), table3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table3), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 10);

  label11 = gtk_label_new ("Audio Channels:");
  gtk_widget_ref (label11);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label11", label11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table3), label11, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label11), 0, 0.5);

  label12 = gtk_label_new ("Audio Frequency:");
  gtk_widget_ref (label12);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label12", label12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label12);
  gtk_table_attach (GTK_TABLE (table3), label12, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label12), 0, 0.5);

  label13 = gtk_label_new ("Audio Bits:");
  gtk_widget_ref (label13);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label13", label13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table3), label13, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label13), 0, 0.5);

  label14 = gtk_label_new ("Audio Compression:");
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table3), label14, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label14), 0, 0.5);


  if(audio_info != NULL) {
    temp = (char *) malloc(20);
    sprintf(temp, "%.1d", audio_info->channels);
    audio_channels = gtk_label_new (temp);
  }
  else {
    audio_channels = gtk_label_new ("");
  }

  
  gtk_widget_ref (audio_channels);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "audio_channels", audio_channels,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (audio_channels);
  gtk_table_attach (GTK_TABLE (table3), audio_channels, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (audio_channels), 0, 0.5);

  if(audio_info != NULL) {
    temp = (char *) malloc(20);
    sprintf(temp, "%.5d", audio_info->frequency);
    audio_frequency = gtk_label_new (temp);
  }
  else {
    audio_frequency = gtk_label_new ("");
  }


  gtk_widget_ref (audio_frequency);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "audio_frequency", audio_frequency,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (audio_frequency);
  gtk_table_attach (GTK_TABLE (table3), audio_frequency, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (audio_frequency), 0, 0.5);

    
  if(audio_info != NULL) {
    temp = (char *) malloc(20);
    sprintf(temp, "%.2d", audio_info->format.bit_count);
    audio_bits = gtk_label_new (temp);
  }
  else {
    audio_bits = gtk_label_new ("");
  }


  gtk_widget_ref (audio_bits);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "audio_bits", audio_bits,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (audio_bits);
  gtk_table_attach (GTK_TABLE (table3), audio_bits, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (audio_bits), 0, 0.5);

  audio_compression = gtk_label_new ("");

  for(system_output = (GList *) ((xmps_playback_t *) xmps_session->user_data)->system->get(((xmps_playback_t *) xmps_session->user_data)->system, 
											   XMPS_FLAG_OUTPUT_LIST, 
											   NULL); 
      system_output != NULL; 
      system_output = g_list_next(system_output)) {
    
    if(system_output->data != NULL) {
      
      xmps_data_t *data_stream;
      
      data_stream = (xmps_data_t *) system_output->data; 
      
      switch(data_stream->type) {
      
      case XMPS_DATA_AUDIO_COMP:
	{
	  audio_compression = gtk_label_new (data_stream->audio_compression);
	}
	break;
      default:
	break;
	
      }
    }
  }


  gtk_widget_ref (audio_compression);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "audio_compression", audio_compression,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (audio_compression);
  gtk_table_attach (GTK_TABLE (table3), audio_compression, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (audio_compression), 0, 0.5);

  button2 = gtk_button_new_with_label ("OK");
  gtk_widget_ref (button2);
  gtk_object_set_data_full (GTK_OBJECT (playback_file_info), "button2", button2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (vbox1), button2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 5);

  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
                      GTK_SIGNAL_FUNC (on_button2_clicked),
                      NULL);
 
}

void xmps_file_info_show()
{
  if(playback_file_info != NULL) {
    gtk_widget_show(playback_file_info);
  }
}
