/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_utils.c
 *
 *  Miscelaneous functions
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include "xmps_skins_utils.h"

/* FUNCTIONS */

/************* set_progress_bar_value *****************
 * 						      *
 ******************************************************/

void set_progress_bar_value(gint number, gint value)
{
  switch (number)
   {
    case BALANCE_BAR : 
    	     xmps_config.balance_bar.value = value;
    	     xmps_config.balance_bar.cursor_rect.start_x = xmps_config.balance_bar.bar_rect.start_x + 4 + xmps_config.balance_bar.value*(xmps_config.balance_bar.bar_rect.size_x - xmps_config.balance_bar.cursor_rect.size_x - 4)/100;
             xmps_config.balance_bar.cursor_rect.start_y = xmps_config.balance_bar.bar_rect.start_y + (xmps_config.balance_bar.bar_rect.size_y - xmps_config.balance_bar.cursor_rect.size_y)/2;
	     break;
    case VOLUME_BAR : 
    	     xmps_config.volume_bar.value = value;
    	     xmps_config.volume_bar.cursor_rect.start_x = xmps_config.volume_bar.bar_rect.start_x + 4 + xmps_config.volume_bar.value*(xmps_config.volume_bar.bar_rect.size_x - xmps_config.volume_bar.cursor_rect.size_x - 4)/100;
             xmps_config.volume_bar.cursor_rect.start_y = xmps_config.volume_bar.bar_rect.start_y + (xmps_config.volume_bar.bar_rect.size_y - xmps_config.volume_bar.cursor_rect.size_y)/2;
	     break;
    case PROGRESS_BAR : 
    	     xmps_config.progress_bar.value = value;
    	     xmps_config.progress_bar.cursor_rect.start_x = xmps_config.progress_bar.bar_rect.start_x + 4 + xmps_config.progress_bar.value*(xmps_config.progress_bar.bar_rect.size_x - xmps_config.progress_bar.cursor_rect.size_x - 4)/100;
             xmps_config.progress_bar.cursor_rect.start_y = xmps_config.progress_bar.bar_rect.start_y + (xmps_config.progress_bar.bar_rect.size_y - xmps_config.progress_bar.cursor_rect.size_y)/2;
	     break;
   }
}

/************* set_progress_bar_value_x ***************
 * 						      *
 ******************************************************/

void set_progress_bar_value_x(gint bar, gint x)
{
  switch (bar)
   {
    case BALANCE_BAR : 
    	     xmps_config.balance_bar.value = (x - xmps_config.balance_bar.bar_rect.start_x)*100/xmps_config.balance_bar.bar_rect.size_x;
	     if (xmps_config.balance_bar.value < 0) xmps_config.balance_bar.value = 0;
	     if (xmps_config.balance_bar.value > 100) xmps_config.balance_bar.value = 100;
    	     xmps_config.balance_bar.cursor_rect.start_x = xmps_config.balance_bar.bar_rect.start_x + 4 + xmps_config.balance_bar.value*(xmps_config.balance_bar.bar_rect.size_x - xmps_config.balance_bar.cursor_rect.size_x - 4)/100;
             xmps_config.balance_bar.cursor_rect.start_y = xmps_config.balance_bar.bar_rect.start_y + (xmps_config.balance_bar.bar_rect.size_y - xmps_config.balance_bar.cursor_rect.size_y)/2;
	     break;
    case VOLUME_BAR : 
    	     xmps_config.volume_bar.value = (x - xmps_config.volume_bar.bar_rect.start_x)*100/xmps_config.volume_bar.bar_rect.size_x;
	     if (xmps_config.volume_bar.value < 0) xmps_config.volume_bar.value = 0;
	     if (xmps_config.volume_bar.value > 100) xmps_config.volume_bar.value = 100;
    	     xmps_config.volume_bar.cursor_rect.start_x = xmps_config.volume_bar.bar_rect.start_x + 4 + xmps_config.volume_bar.value*(xmps_config.volume_bar.bar_rect.size_x - xmps_config.volume_bar.cursor_rect.size_x - 4)/100;
             xmps_config.volume_bar.cursor_rect.start_y = xmps_config.volume_bar.bar_rect.start_y + (xmps_config.volume_bar.bar_rect.size_y - xmps_config.volume_bar.cursor_rect.size_y)/2;
	     break;
    case PROGRESS_BAR : 
    	     xmps_config.progress_bar.value = (x - xmps_config.progress_bar.bar_rect.start_x)*100/xmps_config.progress_bar.bar_rect.size_x;
	     if (xmps_config.progress_bar.value < 0) xmps_config.progress_bar.value = 0;
	     if (xmps_config.progress_bar.value > 100) xmps_config.progress_bar.value = 100;
    	     xmps_config.progress_bar.cursor_rect.start_x = xmps_config.progress_bar.bar_rect.start_x + 4 + xmps_config.progress_bar.value*(xmps_config.progress_bar.bar_rect.size_x - xmps_config.progress_bar.cursor_rect.size_x - 4)/100;
             xmps_config.progress_bar.cursor_rect.start_y = xmps_config.progress_bar.bar_rect.start_y + (xmps_config.progress_bar.bar_rect.size_y - xmps_config.progress_bar.cursor_rect.size_y)/2;
	     break;
   }
}

/*************** xmps_set_image_size ******************
 * 						      *
 ******************************************************/

void xmps_set_image_size(GtkWidget *window, gint x, gint y)
{
  xmps_config.window_size_x = 275 + (x - IMAGE_DEFAULT_SIZE_X) - 4;
  xmps_config.window_size_y = 150 + (y - IMAGE_DEFAULT_SIZE_Y) - 1;
  
  gdk_window_resize(window->window, xmps_config.window_size_x, xmps_config.window_size_y);
  gdk_flush();
  /*
  if (xmps_config.is_playlist_glued)
   {
    xmps_config.playlist_size_x = 275 + (x - IMAGE_DEFAULT_SIZE_X) - 4;
    gdk_window_resize(playlist_window->window, playlist.playlist_size_x,  105 + 15*(playlist.nbr_lines-3));
    gtk_widget_set_usize(playlist_window, playlist.playlist_size_x,  105 + 15*(playlist.nbr_lines-3));
    
    playlist.playlist_pos_x = xmps_config.window_pos_x;
    playlist.playlist_pos_y = xmps_config.window_pos_y + xmps_config.window_size_y;
    gtk_widget_set_uposition(playlist_window, playlist.playlist_pos_x, playlist.playlist_pos_y);

    }*/
  
  refresh_zone_rects();
}





























