/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_skins.c
 *
 *  Functions for handling the skins
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include "xmps_skins.h"

/* FUNCTIONS */

/****************** initialize_skins ******************
 * 						      *
 * initialisation				      *
 * 						      *
 ******************************************************/

void initialize_skins()
{
  // the rects
  refresh_zone_rects();

  set_progress_bar_value(PROGRESS_BAR, 0);
  set_progress_bar_value(VOLUME_BAR, 85);
  set_progress_bar_value(BALANCE_BAR, 50);
}

/********************* load_skin **********************
 * 						      *
 * Loads the current skin			      *
 * 						      *
 ******************************************************/

void load_default_skin(GdkWindow *window)
{
  /* The colors */

  xmps_config.current_skin->playlist_bgcolor.red   = 179;
  xmps_config.current_skin->playlist_bgcolor.green = 197;
  xmps_config.current_skin->playlist_bgcolor.blue  = 198;
  xmps_config.current_skin->playlist_bgcolor.pixel = 1;

  xmps_config.current_skin->filename_bgcolor.red   = 179;
  xmps_config.current_skin->filename_bgcolor.green = 197;
  xmps_config.current_skin->filename_bgcolor.blue  = 198;
  xmps_config.current_skin->filename_bgcolor.pixel = 1;

  xmps_config.current_skin->filename_font_color.red   = 0;
  xmps_config.current_skin->filename_font_color.green = 0;
  xmps_config.current_skin->filename_font_color.blue  = 0;
  xmps_config.current_skin->filename_font_color.pixel = 1;

  xmps_config.current_skin->playlist_font_color.red   = 0;
  xmps_config.current_skin->playlist_font_color.green = 0;
  xmps_config.current_skin->playlist_font_color.blue  = 0;
  xmps_config.current_skin->playlist_font_color.pixel = 1;
   
  xmps_config.current_skin->playlist_selected.red   = 115;
  xmps_config.current_skin->playlist_selected.green = 165;
  xmps_config.current_skin->playlist_selected.blue  = 189;
  xmps_config.current_skin->playlist_selected.pixel = 1;
  
#ifdef HAVE_GDKPIXBUF

  /* The pixbufs */

  main_pixbuf = gdk_pixbuf_new_from_file(SKIN_PATH "/default/main.xpm");
  buttons_pixbuf = gdk_pixbuf_new_from_file(SKIN_PATH "/default/buttons.xpm");
  controls_pixbuf = gdk_pixbuf_new_from_file(SKIN_PATH "/default/controls.xpm");
  digits_pixbuf = gdk_pixbuf_new_from_file(SKIN_PATH "/default/digits.xpm");
  titlebar_pixbuf = gdk_pixbuf_new_from_file(SKIN_PATH "/default/titlebar.xpm");
  playlist_pixbuf = gdk_pixbuf_new_from_file(SKIN_PATH "/default/playlist.xpm");

#else

  main_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
                                           &style->bg[GTK_STATE_NORMAL],
                                           SKIN_PATH "/default/main.xpm");

  buttons_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					      &style->bg[GTK_STATE_NORMAL],
					      SKIN_PATH "/default/buttons.xpm");

  controls_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       SKIN_PATH "/default/controls.xpm");

  digits_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					     &style->bg[GTK_STATE_NORMAL],
					     SKIN_PATH "/default/digits.xpm");

  titlebar_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       SKIN_PATH "/default/titlebar.xpm");

  playlist_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       SKIN_PATH "/default/playlist.xpm");

#endif

}

/********************* load_skin **********************
 * 						      *
 * Loads the current skin			      *
 * 						      *
 ******************************************************/

void load_skin(gchar *skin, GdkWindow *window)
{
  gchar *temp;
  xmps_config_file_t *cfgfile;
  gchar   *filename;   

  /* The colors */

  filename = g_strconcat(skin, "/config", NULL);
  cfgfile = xmps_config_open_file(filename);

  XMPS_DEBUG("openning skin config file : %s", filename);

  if(cfgfile)
    {
      xmps_config_read_int(cfgfile, "skin", "filename_bgcolor_red", (gint *) &xmps_config.current_skin->filename_bgcolor.red);
      xmps_config_read_int(cfgfile, "skin", "filename_bgcolor_green", (gint *) &xmps_config.current_skin->filename_bgcolor.green);
      xmps_config_read_int(cfgfile, "skin", "filename_bgcolor_blue", (gint *) &xmps_config.current_skin->filename_bgcolor.blue);
     
      xmps_config_read_int(cfgfile, "skin", "playlist_font_color_red", (gint *) &xmps_config.current_skin->playlist_font_color.red);
      xmps_config_read_int(cfgfile, "skin", "playlist_font_color_green", (gint *) &xmps_config.current_skin->playlist_font_color.green);
      xmps_config_read_int(cfgfile, "skin", "playlist_font_color_blue", (gint *) &xmps_config.current_skin->playlist_font_color.blue);

      xmps_config_read_int(cfgfile, "skin", "filename_font_color_red", (gint *) &xmps_config.current_skin->filename_font_color.red);
      xmps_config_read_int(cfgfile, "skin", "filename_font_color_green", (gint *) &xmps_config.current_skin->filename_font_color.green);
      xmps_config_read_int(cfgfile, "skin", "filename_font_color_blue", (gint *) &xmps_config.current_skin->filename_font_color.blue);

      xmps_config_read_int(cfgfile, "skin", "playlist_bgcolor_red", (gint *) &xmps_config.current_skin->playlist_bgcolor.red);
      xmps_config_read_int(cfgfile, "skin", "playlist_bgcolor_green", (gint *) &xmps_config.current_skin->playlist_bgcolor.green);
      xmps_config_read_int(cfgfile, "skin", "playlist_bgcolor_blue", (gint *) &xmps_config.current_skin->playlist_bgcolor.blue);

      xmps_config_read_int(cfgfile, "skin", "playlist_selected_red", (gint *) &xmps_config.current_skin->playlist_selected.red);
      xmps_config_read_int(cfgfile, "skin", "playlist_selected_green", (gint *) &xmps_config.current_skin->playlist_selected.green);
      xmps_config_read_int(cfgfile, "skin", "playlist_selected_blue", (gint *) &xmps_config.current_skin->playlist_selected.blue);

    }
  g_free(filename);

  /* The pixmaps */

#ifdef HAVE_GDKPIXBUF

  temp = g_strconcat(skin, "/main.xpm", NULL);
  main_pixbuf = gdk_pixbuf_new_from_file(temp);

  temp = g_strconcat(skin, "/buttons.xpm", NULL);
  buttons_pixbuf = gdk_pixbuf_new_from_file(temp);

  temp = g_strconcat(skin, "/controls.xpm", NULL);
  controls_pixbuf = gdk_pixbuf_new_from_file(temp);

  temp = g_strconcat(skin, "/digits.xpm", NULL);
  digits_pixbuf = gdk_pixbuf_new_from_file(temp);

  temp = g_strconcat(skin, "/titlebar.xpm", NULL);
  titlebar_pixbuf = gdk_pixbuf_new_from_file(temp);

  temp = g_strconcat(skin, "/playlist.xpm", NULL);
  playlist_pixbuf = gdk_pixbuf_new_from_file(temp);

#else

  temp = g_strconcat(skin, "/main.xpm", NULL);
  main_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
                                           &style->bg[GTK_STATE_NORMAL],
                                           temp);

  temp = g_strconcat(skin, "/buttons.xpm", NULL);
  buttons_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					      &style->bg[GTK_STATE_NORMAL],
					      temp);

  temp = g_strconcat(skin, "/controls.xpm", NULL);
  controls_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       temp);

  temp = g_strconcat(skin, "/digits.xpm", NULL);
  digits_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					     &style->bg[GTK_STATE_NORMAL],
					     temp);

  temp = g_strconcat(skin, "/titlebar.xpm", NULL);
  titlebar_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       temp);
  
  temp = g_strconcat(skin, "/playlist.xpm", NULL);
  playlist_pixmap = gdk_pixmap_create_from_xpm(window,  &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       temp);

#endif

}

/**************** draw_current_skin *******************
 * 						      *
 * draws everything				      *
 * 						      *
 ******************************************************/

void draw_current_skin(GtkWidget *widget, int playing)
 {
  draw_background(widget, playing);
    
 draw_full_screen_button(NORMAL, widget); 
  if (xmps_config.is_loop)
   draw_loop_digit(ACTIVE, widget); 
  else
  draw_loop_digit(INACTIVE, widget);
  
  if (xmps_config.is_invert_time)
   draw_minus_digit(ACTIVE, widget);
  else 
   draw_minus_digit(INACTIVE, widget);
  
  draw_time(xmps_config.current_time, widget);
  draw_small_time(xmps_config.total_time, widget);
      
  draw_rewind_button(NORMAL, widget); 
  draw_stop_button(NORMAL, widget); 
  draw_play_button(NORMAL, widget); 
  draw_pause_button(NORMAL, widget); 
  draw_fast_forward_button(NORMAL, widget); 
  draw_load_button(NORMAL, widget); 
  draw_loop_button(NORMAL, widget); 
  if (xmps_config.is_playlist_toggled)
   draw_playlist_button(NORMAL_TOGGLED, widget); 
  else
   draw_playlist_button(NORMAL, widget); 
  draw_progress_bar(xmps_config.balance_bar, widget);
  draw_progress_bar(xmps_config.volume_bar, widget);
  draw_progression_bar(widget);
  
  if (xmps_config.has_focus) 
    draw_titlebar(ACTIVE, widget); 
  else
    draw_titlebar(INACTIVE, widget);

  draw_resize(widget);

  if( xmps_config.playlist->nbr_items > 0)
    {
      // FIX : segfaults on some files
      
      //draw_file_name(widget, xmps_playlist_get_item(xmps_config.playlist)->display_name);
    }
 }














































