/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_main.h
 *
 *  Functions for handling the background
 *  @Author : Damien Chavarria (1999)
 *
 */

#include "skins_draw_main.h"

/***************** draw_background ********************
 * 						      *
 * draws the background 			      *
 * 						      *
 ******************************************************/

void draw_background(GtkWidget *widget, int playing)
{
  GdkGC *gc;
  gint dx, dy;
  int i;
  
  dx = xmps_config.window_size_x - 275;
  dy = xmps_config.window_size_y - 150;


#ifdef HAVE_GDKPIXBUF

  gdk_pixbuf_render_to_drawable (main_pixbuf,
				 widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 0,
				 0,
				 0,
				 0,
				 50,
				 23,
				 GDK_RGB_DITHER_NONE,
				 0, 0);
  
  for (i=0; i < dx / 2; i++)
    gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   50, 0,
				   50+i, 0,
				   1, 23,GDK_RGB_DITHER_NONE, 0, 0);
  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 50, 0,
				 50+dx/2, 0,
				 175, 23,GDK_RGB_DITHER_NONE, 0, 0);

  for (i=0; i <dx - (dx / 2,GDK_RGB_DITHER_NONE, 0, 0); i++)
    gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   225, 0,
				   225+dx/2+i, 0,
				   1, 23,GDK_RGB_DITHER_NONE, 0, 0);
		  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 225, 0,
				 225+dx, 0,
				 50, 23,GDK_RGB_DITHER_NONE, 0, 0);

  // l'ecran

  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 0, 23,
				 0, 23,
				 60, 37,GDK_RGB_DITHER_NONE, 0, 0);
  
  for (i=0; i<dx; i++)
    gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   60, 23,
				   60+i, 23,
				   1, 37,GDK_RGB_DITHER_NONE, 0, 0);
  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 60, 23,
				 60+dx, 23,
				 60, 37,GDK_RGB_DITHER_NONE, 0, 0);

  //le milieu

  if(!playing) {

    for (i=0; i<dy; i++)
      {  
	gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				       widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				       0, 60,
				       0, 60+i,
				       60, 1,GDK_RGB_DITHER_NONE, 0, 0);
	
	gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				       widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				       60, 60,
				       60+dx, 60+i,
				       60, 1,GDK_RGB_DITHER_NONE, 0, 0);
      }
  }
  
  gc = gdk_gc_new(widget->window);
  
  gdk_rgb_gc_set_foreground(gc, 179*65536+197*256+198);
  gdk_draw_rectangle(widget->window, gc, TRUE, 60, 60, dx, dy);
  gdk_gc_destroy(gc);
  
  // le bas
  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 0, 60,
				 0, 60+dy,
				 60, 51,GDK_RGB_DITHER_NONE, 0, 0);
  
  for (i=0; i<dx; i++)
    gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   60, 60,
				   60+i, 60+dy,
				   1, 51,GDK_RGB_DITHER_NONE, 0, 0);
		  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 60, 60,
				 60+dx, 60+dy,
				 60, 51,GDK_RGB_DITHER_NONE, 0, 0);
  
  // Les chiffres et controls
  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 120, 23,
				 120+dx, 23,
				 155, 88,GDK_RGB_DITHER_NONE, 0, 0);
  
  for (i=0; i<dy; i++)
    gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   120, 111,
				   120+dx, 111+i,
				   155, 1,GDK_RGB_DITHER_NONE, 0, 0);
		  
  // barre de progression
  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 0, 111,
				 0, 111+dy,
				 60, 10,GDK_RGB_DITHER_NONE, 0, 0);
  
  for (i=0; i<dx; i++)
    gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   60, 111,
				   60+i, 111+dy,
				   1, 10,GDK_RGB_DITHER_NONE, 0, 0);

  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 60, 111,
				 60+dx, 111+dy,
				 215, 10,GDK_RGB_DITHER_NONE, 0, 0);

  // boutons  

  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 0, 121,
				 0, 121+dy,
				 245, 29,GDK_RGB_DITHER_NONE, 0, 0);
  
  for (i=0; i<dx; i++)
    gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   245, 121,
				   245+i, 121+dy,
				   1, 29,GDK_RGB_DITHER_NONE, 0, 0);
  
  gdk_pixbuf_render_to_drawable (main_pixbuf,widget->window,
				 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				 245, 121,
				 245+dx, 121+dy,
				 30, 29,GDK_RGB_DITHER_NONE, 0, 0);
   
#else
   
  /* title */
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  0, 0,
                  0, 0,
                  50, 23);

  for (i=0; i <dx / 2; i++)
   gdk_draw_pixmap(widget->window,
                   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                   main_pixmap,
                   50, 0,
                   50+i, 0,
                   1, 23);

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  50, 0,
                  50+dx/2, 0,
                  175, 23);
  for (i=0; i <dx - (dx / 2); i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  225, 0,
                  225+dx/2+i, 0,
                  1, 23);

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  225, 0,
                  225+dx, 0,
                  50, 23);

 // l'?cran

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  0, 23,
                  0, 23,
                  60, 37);
  for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  60, 23,
                  60+i, 23,
                  1, 37);

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  60, 23,
                  60+dx, 23,
                  60, 37);

  //le milieu
  for (i=0; i<dy; i++)
  { gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  0, 60,
                  0, 60+i,
                  60, 1);
     gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  60, 60,
                  60+dx, 60+i,
                  60, 1);
  }

  gc = gdk_gc_new(widget->window);
  gdk_rgb_init();
  gdk_rgb_gc_set_foreground(gc, 179*65536+197*256+198);
  gdk_draw_rectangle(widget->window, gc, TRUE, 60, 60, dx, dy);
  gdk_gc_destroy(gc);

  // le bas
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  0, 60,
                  0, 60+dy,
                  60, 51);
  for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  60, 60,
                  60+i, 60+dy,
                  1, 51);

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  60, 60,
                  60+dx, 60+dy,
                  60, 51);

  // Les chiffres et controls
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  120, 23,
                  120+dx, 23,
                  155, 88);
  for (i=0; i<dy; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  120, 111,
                  120+dx, 111+i,
                  155, 1);
  // barre de progression

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  0, 111,
                  0, 111+dy,
                  60, 10);
  for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  60, 111,
                  60+i, 111+dy,
                  1, 10);
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  60, 111,
                  60+dx, 111+dy,
                  215, 10);
  // buttons  
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  0, 121,
                  0, 121+dy,
                  245, 29);
  for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  245, 121,
                  245+i, 121+dy,
                  1, 29);

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  main_pixmap,
                  245, 121,
                  245+dx, 121+dy,
                  30, 29);


#endif
   
}






