/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_buttons.c
 *
 *  Functions for handling the buttons.xpm
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include <skins_draw_buttons.h>

/* FUNCTIONS */

/**************** draw_rewind_button ******************
 * 						      *
 ******************************************************/

void draw_rewind_button(gint state, GtkWidget *widget)
{
  gint dy;
  dy = xmps_config.window_size_y - 150;
  switch (state)
  {
    case NORMAL :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     2, 2,
				     12, 125+dy,
				     25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      2, 2,
		      12, 125+dy,
		      25, 17);
#endif
      break;

    case PUSHED :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     2, 21,
				     12, 125+dy,
				     25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      2, 21,
		      12, 125+dy,
		      25, 17);
#endif	  
      break;
  }
}

/***************** draw_stop_button *******************
 * 						      *
 ******************************************************/

void draw_stop_button(gint state, GtkWidget *widget)
{
  gint dy;
  dy = xmps_config.window_size_y - 150;
  switch (state)
  {
    case NORMAL :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     29, 2,
				     47, 125+dy,
				     25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      29, 2,
		      47, 125+dy,
		      25, 17);
#endif
      break;

    case PUSHED :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     29, 21,
				     47, 125+dy,
				     25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      29, 21,
		      47, 125+dy,
		      25, 17);
#endif
      break;
  }
}

/****************** draw_play_button ******************
 * 						      *
 ******************************************************/

void draw_play_button(gint state, GtkWidget *widget)
{
  gint dy;
  dy = xmps_config.window_size_y - 150;
  switch (state)
  {
  case NORMAL :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   56, 2,
				   82, 125+dy,
				   25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    buttons_pixmap,
		    56, 2,
		    82, 125+dy,
		    25, 17);
#endif    		  
    break;
    
  case PUSHED :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   56, 21,
				   82, 125+dy,
				   25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    buttons_pixmap,
		    56, 21,
		    82, 125+dy,
		    25, 17);
#endif
    break;
  }
}

/**************** draw_pause_button *******************
 * 						      *
 ******************************************************/

void draw_pause_button(gint state, GtkWidget *widget)
{
  gint dy;
  dy = xmps_config.window_size_y - 150;
  switch (state)
    {
    case NORMAL :  
#ifdef HAVE_GDKPIXBUF    
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     83, 2,
				     117, 125+dy,
				     25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      83, 2,
		      117, 125+dy,
		      25, 17);
#endif    		  
      break;
      
    case PUSHED :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     83, 21,
				     117, 125+dy,
				     25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      83, 21,
		      117, 125+dy,
		      25, 17);
#endif    		  
      break;
  }
}

/************* draw_fast_forward_button ***************
 * 						      *
 ******************************************************/

void draw_fast_forward_button(gint state, GtkWidget *widget)
{
  gint dy;
  dy = xmps_config.window_size_y - 150;
  switch (state)
  {
  case NORMAL :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   110, 2,
				   152, 125+dy,
				   25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    buttons_pixmap,
		    110, 2,
		    152, 125+dy,
		    25, 17);
#endif	  
    break;
    
  case PUSHED :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   110, 21,
				   152, 125+dy,
				   25, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    buttons_pixmap,
		    110, 21,
		    152, 125+dy,
		    25, 17);
#endif
    break;
  }
}

/***************** draw_load_button *******************
 * 						      *
 ******************************************************/

void draw_load_button(gint state, GtkWidget *widget)
{
  gint dy;
  dy = xmps_config.window_size_y - 150;
  switch (state)
    {
    case NORMAL :  
#ifdef HAVE_GDKPIXBUF      
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
                  		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  		  
                  		  137, 2,
                  		  189, 125+dy,
                  		  51, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      137, 2,
		      189, 125+dy,
		      51, 17);
#endif
      break;

    case PUSHED :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (buttons_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     137, 21,
				     189, 125+dy,
				     51, 17,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      buttons_pixmap,
		      137, 21,
		      189, 125+dy,
		      51, 17);
#endif
      break;
  }
}

