/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/**
 *  playlist.c
 *
 *  Code file for the playlist.
 *  @Author : Damien Chavarria (1999)
 *
 */

/* includes */

#include <skinned_playlist.h>

GtkItemFactory  *add_menu, *remove_menu, *sort_menu, *rand_menu;

GtkWidget *playlist_window;
GtkWidget *playlist_drawing_area;
GtkWidget *playlist_file_selection;

gdouble p_move_x, p_move_y, cursor_y;
int     nbr_lines;
gint    p_dy;

/* menus */

/* add files menu */

void add_menu_callback(gpointer cb_data, guint action, GtkWidget * w);

enum
{
  ADD_FILES, ADD_DIR, ADD_URL // to do
};

#define ADD_MENU_ENTRIES 1

GtkItemFactoryEntry add_menu_entries[] =
{
  { "/Add files", "<control>F", add_menu_callback, ADD_FILES, "<Item>"   }
};

 /* remove files menu */

void remove_menu_callback(gpointer cb_data, guint action, GtkWidget * w);

enum
{
  REMOVE_SELECTION, REMOVE_ALL
};

#define REMOVE_MENU_ENTRIES 2

GtkItemFactoryEntry remove_menu_entries[] =
{
  { "/Remove selection", "<control>S", remove_menu_callback, REMOVE_SELECTION, "<Item>" },
  { "/Remove all", "<control>A", remove_menu_callback, REMOVE_ALL, "<Item>" }
};

 /* sort files menu */

void sort_menu_callback(gpointer cb_data, guint action, GtkWidget * w);

enum
{
  SORT_AZ, SORT_ZA, SORT_TIME 
};

#define SORT_MENU_ENTRIES 2

GtkItemFactoryEntry sort_menu_entries[] =
{
  { "/Sort A->Z", "<control><alt>A", sort_menu_callback, SORT_AZ, "<Item>" },
  { "/Sort Z->A", "<control><alt>R", sort_menu_callback, SORT_ZA, "<Item>" }
};

 /* rand files menu */

void rand_menu_callback(gpointer cb_data, guint action, GtkWidget * w);

enum
{
  SELECT_ALL, SELECT_NONE, INVERT_SEL, RANDOMIZE, INVERT 
};

#define RAND_MENU_ENTRIES 5

GtkItemFactoryEntry rand_menu_entries[] =
{
  { "/Select All", "<control><alt>S", rand_menu_callback, SELECT_ALL, "<Item>" },
  { "/Clear Selection", "<control><alt>C", rand_menu_callback, SELECT_NONE, "<Item>" },
  { "/Invert Selection", "<control><alt>I", rand_menu_callback, INVERT_SEL, "<Item>" },
  { "/-", NULL, NULL, 0, "<Separator>" },
  { "/Randomize", "<control><alt>M", rand_menu_callback, RANDOMIZE, "<Item>" }
};

/* FUNCTIONS */

void playlist_remove_selected();
int  playlist_unselect_all();
int  playlist_select_all();
int  playlist_invert_selection();
void playlist_clear();
void playlist_toggle_item_selection(gint index);
int  playlist_randomize();
void draw_playlist_items(GtkWidget *widget);
void playlist_clear_items(GtkWidget *widget);

/********************** Comparison function ************************/

gint playlist_sort_az_cmpfunc(xmps_item_t * a, xmps_item_t * b)
{
  return strcasecmp( a->display_name, b->display_name);
}

gint playlist_sort_za_cmpfunc(xmps_item_t * a, xmps_item_t * b)
{
  if ( strcasecmp( a->display_name, b->display_name) < 0 )
    return 1;
  if ( strcasecmp( a->display_name, b->display_name) > 0 )
    return -1;
  else
    return 0;
}
/********************** file_selection functions ************************
 *									*
 ************************************************************************/

void playlist_file_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
  GList *file_node;
  char  *filename;
  gint   index;
  gchar *dir = NULL;
  struct stat buf;
  xmps_item_t *item;

  XMPS_DEBUG("trying to add files to playlist...");

  gtk_widget_hide(GTK_WIDGET(fs));
  
  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));

  /* remove the blanks */
  g_strstrip(filename);

  /* remember the directory into config */

  /* check if it's a directory or a file */
  if (stat(filename, &buf) == 0)
    {
      if (S_ISDIR(buf.st_mode))
	{
	  /* set the dir for next time */
	  gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs),
					  g_strdup_printf("%s/", filename));
	  return;
	}
      else 
	/* remember the dir in case of multiple sel */
	{
	  index = strlen(filename);
	  while (filename[index - 1] != '/')
	    {
	      filename[index - 1] = '\0';
	      index = strlen(filename);
	    }
	  
	  dir = filename;
	
	}
    }
  
  if(xmps_config.playlist->nbr_items == 0) {

    xmps_config.playlist_current_display_position = 1;
  }

  /* process the selected files */

  for(file_node = GTK_CLIST(GTK_FILE_SELECTION(fs)->file_list)->selection; file_node != NULL; file_node = g_list_next(file_node))
    {
      gtk_clist_get_text(GTK_CLIST(GTK_FILE_SELECTION(fs)->file_list), (gint) file_node->data, 0, &filename);
      
      XMPS_DEBUG("trying to add %s", filename);

      item = (xmps_item_t *) xmps_item_new(XMPS_MEDIA_FILE, (char *) g_strconcat(dir, filename, NULL));
      
      xmps_playlist_add(xmps_config.playlist, item);
    }

  

  playlist_clear_items(playlist_drawing_area);
  draw_playlist_items(playlist_drawing_area);
}

void playlist_file_sel_destroy (GtkWidget *widget, gpointer data)
{
  gtk_widget_hide(playlist_file_selection);
}

void playlist_create_file_selection()
{
 /* the file selection widget */
 
  playlist_file_selection = gtk_file_selection_new("Open Video files..."); 
  
  /* multiple selection */
  gtk_clist_set_selection_mode(GTK_CLIST(GTK_FILE_SELECTION(playlist_file_selection)->file_list), GTK_SELECTION_EXTENDED);
 
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (playlist_file_selection)->ok_button),
		      "clicked", (GtkSignalFunc) playlist_file_ok_sel, playlist_file_selection );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (playlist_file_selection)->cancel_button),
			     "clicked", (GtkSignalFunc) playlist_file_sel_destroy,
			     GTK_OBJECT (playlist_file_selection));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION(playlist_file_selection), xmps_config.filesel_dir);
}

/************************** Window Functions ********************************/
/*
void  playlist_dnd_data_received  (GtkWidget          *widget,
				   GdkDragContext     *context,
				   gint                x,
				   gint                y,
				   GtkSelectionData   *data,
				   guint               info,
				   guint               time)
{
}
*/

/******************************* quit() *********************************
 *									*
 * Hide the playlist window						*
 ************************************************************************/
   
void playlist_quit ()
{
  playlist_window_hide();
}


void playlist_focus_in_event(GtkWidget * widget, GdkEvent * event, gpointer callback_data)
{
  xmps_config.playlist_has_focus = TRUE;
  draw_playlist_titlebar(playlist_drawing_area, ACTIVE);
}

void playlist_focus_out_event(GtkWidget * widget, GdkEventButton * event, gpointer callback_data)
{
  xmps_config.playlist_has_focus = FALSE;
  draw_playlist_titlebar(playlist_drawing_area, INACTIVE);
}

/*************************** expose_event() *****************************
 *									*
 * Called by the drawing area when redrawing needed			*
 ************************************************************************/

static gint playlist_expose_event (GtkWidget *widget, GdkEventExpose *event)
 {
   
   if(!xmps_config.showing_prop) {
     
     draw_playlist_main(widget);
     if (xmps_config.playlist_has_focus)
       draw_playlist_titlebar(widget, ACTIVE);
     else
       draw_playlist_titlebar(widget, INACTIVE);
     draw_playlist_add_button(widget, NORMAL);
     draw_playlist_remove_button(widget, NORMAL);
     draw_playlist_sort_button(widget, NORMAL);
     draw_playlist_rand_button(widget, NORMAL);
     draw_playlist_progress_bar(widget);
     draw_playlist_cursor(widget);
     draw_playlist_resize(widget);
     draw_playlist_items(widget);
   }
   
   return FALSE;
 }

/************************ button_press_event() **************************
 *									*
 * Called when the drawing area is clicked				*
 ************************************************************************/

static gint playlist_button_press_event (GtkWidget *widget, GdkEventButton *event)
{
  //gdk_window_raise(window->window);
  if( xmps_config.is_playlist_toggled )
    gdk_window_raise(playlist_window->window);
  
  if (event->button == 1)
    /* bouton gauche */
    switch (playlist_get_selected_zone(event->x, event->y))
      {
      case PLAYLIST_MENU 	  :
	/* popup menu */
	xmps_config.current_action = PLAYLIST_MENU_CLICKED;
	break;
      case PLAYLIST_TITLE 		  :
	/* Clic on the title */
	xmps_config.current_action = PLAYLIST_TITLE_CLICKED;
	break;
      case PLAYLIST_CLOSE 	 	  :
	/* Close the window */
	xmps_config.current_action = PLAYLIST_CLOSE_CLICKED;
	break;
      case PLAYLIST_ITEMS 	  :
	/* the items */
	xmps_config.current_action = PLAYLIST_ITEMS_CLICKED;
	break;
      case PLAYLIST_ADD_BUTTON  :
	/* add file, dir... */
	xmps_config.current_action = PLAYLIST_ADD_BUTTON_CLICKED;
	draw_playlist_add_button(widget, PUSHED);
	break;
      case PLAYLIST_REMOVE_BUTTON  :
	/* remove file, all... */
	xmps_config.current_action = PLAYLIST_REMOVE_BUTTON_CLICKED;
	draw_playlist_remove_button(widget, PUSHED);
	break;
      case PLAYLIST_SORT_BUTTON 	  :
	/* sort the entries */
	xmps_config.current_action = PLAYLIST_SORT_BUTTON_CLICKED;
	draw_playlist_sort_button(widget, PUSHED);
	break;
      case PLAYLIST_RAND_BUTTON  :
	/* randomze and misc funcs... */
	xmps_config.current_action = PLAYLIST_RAND_BUTTON_CLICKED;
	draw_playlist_rand_button(widget, PUSHED);
	break;
      case PLAYLIST_RESIZE 	  :
	/* resize the window */
	p_move_x = event->x;
	p_move_y = event->y;
	p_dy = 0;
	xmps_config.current_action = PLAYLIST_RESIZE_CLICKED;
	break;
      case PLAYLIST_CURSOR 	  :
	/* for scrolling */
	cursor_y = event->y;
	xmps_config.current_action = PLAYLIST_CURSOR_CLICKED;
	break;

      default:
	break;
      }
  return TRUE;
}   

/*********************** button_release_event() *************************
 *									*
 * Called when a clic on the drawing area is released			*
 ************************************************************************/
     
static gint playlist_button_release_event (GtkWidget *widget, GdkEventButton *event)
{
  gint index;
  
  if (event->button == 1)
    /* bouton gauche */
    switch (xmps_config.current_action)
      {
      case PLAYLIST_MENU_CLICKED : 
	break;
      case PLAYLIST_TITLE_CLICKED : 
	break;
      case PLAYLIST_CLOSE_CLICKED :
	xmps_config.is_playlist_toggled = FALSE;
	gtk_widget_hide(playlist_window); 
	break;
      case PLAYLIST_ITEMS_CLICKED :
	index = get_playlist_item_selected(event->y);
	
	if (index != -1)
	  {
	    if( event->state & GDK_CONTROL_MASK )
	      {
		playlist_toggle_item_selection(index);
	      }
	    else
	      {
		playlist_unselect_all();
		xmps_playlist_toggle_selection_at(xmps_config.playlist, index);
	      }
	  }

	playlist_clear_items(widget);
	draw_playlist_items(widget); 
	break;
      case PLAYLIST_ADD_BUTTON_CLICKED : 
	draw_playlist_add_button(widget, NORMAL);
	gtk_menu_popup(GTK_MENU(add_menu->widget), NULL, NULL, 
		       (GtkMenuPositionFunc) NULL, NULL, event->button, event->time);
	break;
      case PLAYLIST_REMOVE_BUTTON_CLICKED : 
	draw_playlist_remove_button(widget, NORMAL);
	gtk_menu_popup(GTK_MENU(remove_menu->widget), NULL, NULL, 
		       (GtkMenuPositionFunc)NULL, NULL, event->button, event->time);
	break;
      case PLAYLIST_SORT_BUTTON_CLICKED : 
	draw_playlist_sort_button(widget, NORMAL);
	gtk_menu_popup(GTK_MENU(sort_menu->widget), NULL, NULL, 
		       (GtkMenuPositionFunc)NULL, NULL, event->button, event->time);
	break;
      case PLAYLIST_RAND_BUTTON_CLICKED : 
	draw_playlist_rand_button(widget, NORMAL);
	gtk_menu_popup(GTK_MENU(rand_menu->widget), NULL, NULL, 
		       (GtkMenuPositionFunc)NULL, NULL, event->button, event->time);
	break;
      case PLAYLIST_RESIZE_CLICKED : 
	break;
      default:
	break;
      }
  xmps_config.current_action = NONE;
  return TRUE;
}

/************************ motion_notify_event() *************************
 *									*
 * Called when the mouse moves over the drawing area			*
 ************************************************************************/

static gint playlist_motion_notify_event (GtkWidget *widget, GdkEventMotion *event)
 {
  gint x, y;
  int dx, dy;
  int pl_dy;
  GdkModifierType state;

  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x, &y, &state);
  else
    {
      x = (gint) event->x;
      state = (GdkModifierType) event->state;
    }
  switch (xmps_config.current_action)
    {
      
    case PLAYLIST_RESIZE_CLICKED : 
      {
	dx = x - p_move_x;
	dy = y - p_move_y;
	p_move_x = x;

	if (dy > 14)
	  {
	    p_move_y = y;
	    xmps_config.playlist_nbr_lines++;
	    gdk_window_resize(widget->parent->window, xmps_config.playlist_size_x, 105 + 15*(xmps_config.playlist_nbr_lines-3));
	    gtk_widget_set_usize(widget->parent, xmps_config.playlist_size_x, 105 + 15*(xmps_config.playlist_nbr_lines-3));
	    refresh_zone_rects();
	    if (xmps_config.playlist->nbr_items > 0)
	      {
		if (xmps_config.playlist_nbr_lines >= xmps_config.playlist->nbr_items)
		  xmps_config.playlist_current_display_position = 1;
		if ((xmps_config.playlist_nbr_lines > (xmps_config.playlist->nbr_items - xmps_config.playlist_current_display_position+1)) && 
		    (xmps_config.playlist_current_display_position > 1))
		  xmps_config.playlist_current_display_position--;
	      }
	  }
	if (dy < -14)
	  {
	    p_move_y = y;
	    if (xmps_config.playlist_nbr_lines != 4)
	      xmps_config.playlist_nbr_lines--;
	    refresh_zone_rects();
	    gdk_window_resize(widget->parent->window, xmps_config.playlist_size_x, 105 + 15*(xmps_config.playlist_nbr_lines-3));
	    gtk_widget_set_usize(widget->parent, xmps_config.playlist_size_x, 105 + 15*(xmps_config.playlist_nbr_lines-3));
	  }
      }
      break;
      
    case PLAYLIST_CURSOR_CLICKED : 
      
      if (xmps_config.playlist->nbr_items > xmps_config.playlist_nbr_lines)
	{
	  dy = y - cursor_y;
	  
	  pl_dy = (PLAYLIST_PROGRESS_BAR_RECT.size_y - 27) / (xmps_config.playlist->nbr_items - xmps_config.playlist_nbr_lines);
	  
	  if (dy > pl_dy)
	    {
	      cursor_y = y;
	      if (xmps_config.playlist_current_display_position < (xmps_config.playlist->nbr_items - xmps_config.playlist_nbr_lines +1))
		{
		  xmps_config.playlist_current_display_position++;
		  draw_playlist_progress_bar(widget);
		  draw_playlist_cursor(widget);
		  playlist_clear_items(playlist_drawing_area);
		  draw_playlist_items(widget);
		  refresh_zone_rects();
		}
	    }
	  if (dy < -pl_dy)
	    {
	      cursor_y = y;
	      if (xmps_config.playlist_current_display_position > 1)
		{
		  xmps_config.playlist_current_display_position--;
		  draw_playlist_progress_bar(widget);
		  draw_playlist_cursor(widget);
		  playlist_clear_items(playlist_drawing_area);
		  draw_playlist_items(widget);
		  refresh_zone_rects();
		} 
	    }
	}
      break;
    default:
      break;
    }
  return TRUE;
 }

/* MENUS */

void add_menu_callback(gpointer cb_data, guint action, GtkWidget * w)
{
  switch (action)
    {
    case ADD_FILES :
      gtk_widget_show(playlist_file_selection);
      break;
    case ADD_DIR :

      break;
    case ADD_URL :

      break;
    default:
      break;
    }    
}

void remove_menu_callback(gpointer cb_data, guint action, GtkWidget * w)
{
  switch (action)
   {
   case REMOVE_SELECTION:
     playlist_remove_selected();
     playlist_clear_items(playlist_drawing_area);
     break;
   case REMOVE_ALL:
     xmps_playlist_clear(xmps_config.playlist);
     playlist_clear_items(playlist_drawing_area);
     break;
   default:
     break;
   }
  draw_playlist_items(playlist_drawing_area);
}

void sort_menu_callback(gpointer cb_data, guint action, GtkWidget * w)
{/*
  GList *node;
  if( playlist.list != NULL )
   switch (action)
   {
   case SORT_AZ:
     PL_LOCK();
     g_list_sort(playlist.list, (GCompareFunc) playlist_sort_az_cmpfunc);
     if( playlist.list->next == NULL )
       {
	 node = playlist.list;
	 while ( node->prev != NULL )
	   node = node->prev;
	 playlist.list = node;
       }
     PL_UNLOCK();
     break; 
   case SORT_ZA:
     PL_LOCK();
     g_list_sort(playlist.list, (GCompareFunc) playlist_sort_za_cmpfunc);
     if( playlist.list->next == NULL )
       {
	 node = playlist.list;
	 while ( node->prev != NULL )
	   node = node->prev;
	 playlist.list = node;
       }
     PL_UNLOCK();
     break;
   default:
     break;
   }
   playlist_clear_items(playlist_drawing_area);
   draw_playlist_items(playlist_drawing_area);
 */
}

void rand_menu_callback(gpointer cb_data, guint action, GtkWidget * w)
{
  switch (action)
   {
   case SELECT_ALL:
     playlist_select_all();
     break;
   case SELECT_NONE:
     playlist_unselect_all();
     break;
   case INVERT_SEL:
     playlist_invert_selection();
     break;
   case RANDOMIZE:
     playlist_randomize();
     break;
   default:
     break;
   }
 
  playlist_clear_items(playlist_drawing_area);
  draw_playlist_items(playlist_drawing_area);
 
}

void playlist_create_menus()
{
 add_menu = gtk_item_factory_new(GTK_TYPE_MENU, "<Add>", xmps_config.global_accel);
 gtk_item_factory_create_items(add_menu, ADD_MENU_ENTRIES, add_menu_entries, NULL);

 remove_menu = gtk_item_factory_new(GTK_TYPE_MENU, "<Remove>", xmps_config.global_accel);
 gtk_item_factory_create_items(remove_menu, REMOVE_MENU_ENTRIES, remove_menu_entries, NULL);

 sort_menu = gtk_item_factory_new(GTK_TYPE_MENU, "<Sort>", xmps_config.global_accel);
 gtk_item_factory_create_items(sort_menu, SORT_MENU_ENTRIES, sort_menu_entries, NULL);

 rand_menu = gtk_item_factory_new(GTK_TYPE_MENU, "<Rand>", xmps_config.global_accel);
 gtk_item_factory_create_items(rand_menu, RAND_MENU_ENTRIES, rand_menu_entries, NULL);

}


void playlist_window_create()
{
  playlist_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 
 /* default size 4 lines */
  gtk_widget_set_usize(GTK_WIDGET(playlist_window), 275, 120);
  gtk_widget_set_name (playlist_window, "X Movie Player System Playlist");
  gtk_window_set_policy(GTK_WINDOW(playlist_window), FALSE, FALSE, TRUE);
        
 /* position loaded from options */
  gtk_widget_set_uposition(GTK_WIDGET(playlist_window), xmps_config.window_pos_x, xmps_config.window_pos_y + 150);
 /* we never know */
  gtk_signal_connect (GTK_OBJECT (playlist_window), "destroy",
                      GTK_SIGNAL_FUNC (playlist_quit), NULL);
       
 /* Create the drawing area */
  playlist_drawing_area = gtk_drawing_area_new ();
  gtk_container_add (GTK_CONTAINER (playlist_window), playlist_drawing_area);

  gtk_widget_show (playlist_drawing_area);

  gtk_widget_realize(playlist_window);

  //  gtk_drag_dest_set (playlist_window, GTK_DEST_DEFAULT_ALL,
  //	     dnd_target_table, 1, GDK_ACTION_COPY);

 /* connect to all the signals we need */
  gtk_signal_connect(GTK_OBJECT (playlist_drawing_area), "expose_event",
		     (GtkSignalFunc) playlist_expose_event, NULL);
  gtk_signal_connect(GTK_OBJECT (playlist_drawing_area), "button_press_event",
		     (GtkSignalFunc) playlist_button_press_event, NULL);
  gtk_signal_connect(GTK_OBJECT (playlist_drawing_area), "button_release_event",
		     (GtkSignalFunc) playlist_button_release_event, NULL);
  gtk_signal_connect(GTK_OBJECT (playlist_drawing_area), "motion_notify_event",
		     (GtkSignalFunc) playlist_motion_notify_event, NULL);
  gtk_signal_connect(GTK_OBJECT(playlist_window), "focus_in_event", 
		     GTK_SIGNAL_FUNC(playlist_focus_in_event), NULL);
  gtk_signal_connect(GTK_OBJECT(playlist_window), "focus_out_event", 
		     GTK_SIGNAL_FUNC(playlist_focus_out_event), NULL);
  //gtk_signal_connect(GTK_OBJECT (playlist_window), "drag_data_received",
  //	     GTK_SIGNAL_FUNC (playlist_dnd_data_received),NULL);

 /* define what we want to be noticed for */ 
  gtk_widget_set_events (playlist_drawing_area, GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_BUTTON_RELEASE_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);

  gdk_window_set_decorations(playlist_window->window, 0);

  xmps_config.playlist_window = playlist_drawing_area;

  playlist_create_menus();
  playlist_create_file_selection();
}

void playlist_window_show()
{
  gtk_widget_show(playlist_window);
}

void playlist_window_hide()
{
 gtk_widget_hide(playlist_window);
}

void playlist_clear_items(GtkWidget *widget)
{
  /*  GdkGC *gc;
 
 gc = gdk_gc_new(widget->window);

 gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_bgcolor.red*65536 + 
				      xmps_config.current_skin->playlist_bgcolor.green*256 + 
				      xmps_config.current_skin->playlist_bgcolor.blue);

 gdk_draw_rectangle(widget->window, gc, TRUE, 10, 30, xmps_config.playlist_size_x - 33, 18+15*(xmps_config.playlist_nbr_lines - 3)+27);

 gdk_gc_destroy(gc);
  */
}

/************************** Playlist Functions ********************************/

void initialize_playlist()
{
 xmps_config.playlist_pos_x = xmps_config.window_pos_x;
 xmps_config.playlist_pos_y = xmps_config.window_pos_y + xmps_config.window_size_y;
 xmps_config.playlist_size_x = 275;
 xmps_config.playlist_nbr_lines = 4;

 xmps_config.playlist_current_display_position = -1;
}

void playlist_toggle_item_selection(gint index)
{
  xmps_playlist_toggle_selection_at(xmps_config.playlist, index);
}

int playlist_unselect_all()
{
  int i;

  for(i = 0; i < xmps_config.playlist->nbr_items; i++) {

    xmps_playlist_unselect_at(xmps_config.playlist, i);
  }

  return 1;
}

int playlist_select_all()
{
  int i;

  for(i = 0; i < xmps_config.playlist->nbr_items; i++) {

    xmps_playlist_select_at(xmps_config.playlist, i);
  }

  return 1;
}

int playlist_invert_selection()
{

  int i;

  for(i = 0; i < xmps_config.playlist->nbr_items; i++) {

    xmps_playlist_toggle_selection_at(xmps_config.playlist, i);
  }

  return 0;
}

void playlist_remove_selected()
{
  
}

void playlist_clear()
{
  xmps_playlist_clear(xmps_config.playlist);
}

int playlist_randomize()
{
  return 0;
}

/* Add directory */

void playlist_add_dir(gchar *dir)
{
}




