/*
 * mpeg2.h
 * Copyright (C) 1999-2000 Aaron Holtzman <aholtzma@ess.engr.uvic.ca>
 *
 * This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 *
 * mpeg2dec is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * mpeg2dec is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <inttypes.h>
#include "libxmps/libxmps.h"

#define MPEG2_MLIB_ENABLE  1
#define MPEG2_MMX_ENABLE   2
#define MPEG2_3DNOW_ENABLE 4
#define MPEG2_SSE_ENABLE   8

typedef struct mpeg2_config_s {
  uint32_t flags;
} mpeg2_config_t;

void mpeg2_init (void);
int  mpeg2_width(void);
int  mpeg2_height(void);
int  mpeg2_frame_rate_code(void);
int  mpeg2_decode_data (void *yuv_output, xmps_system_plugin_t *system, unsigned int stream_id);
void mpeg2_closempeg2 (void);
void mpeg2_drop (int flag);
void mpeg2_output_init (int flag);
