#!/usr/bin/python
#
#  findTeX.py - find out where TeX lives.
#
#  $Id: findTeX.py,v 1.2 1998/10/17 20:21:19 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#

"""
NAME

    findTeX - find out where TeX lives

SYNOPSIS

   texmfdir = findTeX()

DESCRIPTION

    The subroutine findTeX tries various ways to find a TeX
    directory. This little script is necessary because of small
    differences in kpsewhich arguments between TeX versions.

"""

from whence import whence, isexecutable
from string import rstrip
import os, stat

def findTeX():

    def __getit(cmd):
	"""
	    Open a pipe to cmd and read a line. If the returned line
	    is a directory, return that.
	"""
	fh = os.popen(cmd, 'r');
	texmf = rstrip(fh.readline());
	fh.close();
	try:
	    if stat.S_ISDIR(os.stat(texmf)[stat.ST_MODE]):
		return texmf
	    else:
		return ''
	except Exception, e:
	    return ''


    #
    #  Try zero: user override.
    #
    if os.environ.has_key('TEXMF_DIR'):
	return os.environ['TEXMF_DIR']

    #
    #  Try one: kpsexpand (teTeX)
    #
    program = whence('kpsexpand')
    if isexecutable(program):
	texmf = __getit(program + ' \\$TEXMF 2>/dev/null')
	if len(texmf) > 0:
	    return texmf

    #
    #  Try two: kpsewhich (TeX Live)
    #
    program = whence('kpsewhich')
    if isexecutable(program):
	texmf = __getit(program + ' -expand-var \\$TEXMFMAIN 2>/dev/null')
	if len(texmf) > 0:
	    return texmf
	texmf = __getit(program + ' -expand \\$TEXMF 2>/dev/null') 
	if len(texmf) > 0:
	    return texmf

    #
    #  Desperation time. 
    #
    raise Exception, 'Couldn\'t find TeX!'


#
#  Testcode/default usage
#
if __name__ == '__main__':
    print findTeX()

