#!/bin/env python
#
#  gensgmlenv.py - generate /etc/sgml.env
#
#  $Id: gensgmlenv.py,v 1.1 1998/08/24 21:41:51 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#

"""
head1 NAME

    gensgmlenv - Generate /etc/sgml.env

SYNOPSIS

   gensgmlenv

DESCRIPTION

    The subroutine gensgmlenv generates a file /etc/sgml.env that contains
    the bourne shell command that sets SGML_CATALOG_FILES. It is meant to be
    included in SGML-processing scripts and/or in /etc/profile.

EXCEPTIONS

    There are some exceptions which can be thrown by this module. They
    are:

    Error: Base error. If that module throws an exception, and you don't
    want to catch every specific one, catching of Error would be enough.

    NoCatalogError: There was no catalog files found.

    ReadLinkError: There was an error occured during trial of getting
    the real name of the file pointed by a symbolic link.

    WriteScriptError: Could not write the configuration script. The type
    of the shell will be thrown within the detail attribute.

"""

import glob, os, re, string


class Error(Exception):
    pass

class NoCatalogError(Error):
    pass

class ReadLinkError(Error):
    pass

class WriteScriptError(Error):
    pass

_subdot = re.compile("\.\.\/\.\.\/\.\.").sub
_subslash = re.compile("\/\/").sub


def gensgmlenv():
    catfiles = []
    for link in glob.glob("/etc/sgml/catalog.d/*"):
	try:
            file = os.readlink(link)
	except os.error:
	    raise ReadLinkError, file
        file = _subdot("", file, 1)
        file = _subslash("/", file)
	catfiles.append(file)
    if not catfiles:
        raise NoCatalogError
    files = string.join(catfiles, ":")
    try:
        sgmlenv = open("/etc/sgml/sgml.env", "w")
        sgmlenv.write("SGML_CATALOG_FILES=%s\n"
	              "export SGML_CATALOG_FILES\n" % files)
        sgmlenv.close()
    except IOError:
        raise WriteScriptError, "sh"
    try:
        sgmlenv = open("/etc/sgml/sgml.cenv", "w")
        sgmlenv.write("setenv SGML_CATALOG_FILES %s\n" % files)
        sgmlenv.close()
    except IOError:
        raise WriteScriptError, "csh"
    

if __name__ == "__main__":
    # testcode 
    gensgmlenv()
