/*
 * xconvers - GTK+ convers client for amateur radio
 * Copyright (C) 2000-2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * preferences.c - private functions for saving and recalling xconvers preferences.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/stat.h>
#include "support.h"
#include "preferences.h"
#include "types.h"
#include "color.h"

extern GtkWidget *mainwindow;
extern gchar *preferencesdir;
extern preferencestype preferences;
GdkColormap *colormap;

/*
 * Check if ~/.xconvers directory exists. If not: create it and exit if errors.
 */
 
void dircheck()
{
  GString *packagedir;
  struct stat statdir;

  packagedir = g_string_new("/.");
  g_string_append(packagedir, PACKAGE);
  preferencesdir = g_strconcat(g_get_home_dir(), packagedir->str, NULL);
  if (stat(preferencesdir, &statdir) == -1)
  {
    if (mkdir(preferencesdir, S_IRUSR | S_IWUSR | S_IXUSR) == -1)
      g_error(_("Creating ~%s directory."), packagedir->str);
  }
  else if (!S_ISDIR(statdir.st_mode)) g_error(_("~%s is not a directory."), packagedir->str);
}

/*
 * Lookup settings in ~/.xconvers/preferences. I have put in the many '{}' for
 * clarity. The default for menu, statusbar and scrollbar is 'on'.
 */

void loadpreferences(void)
{
  gchar *preferencesfile, label[100], value[100];
  FILE *fp;

  /* defaults */
  preferences.logging = FALSE;
  preferences.autologin = FALSE;
  preferences.menu = TRUE;
  preferences.statusbar = TRUE;
  preferences.scrollbar = TRUE;
  preferences.font = g_string_new("fixed");
  colormap = gdk_colormap_get_system();
  gdk_color_parse("grey1", &preferences.backgroundcolor);
  gdk_color_alloc(colormap, &preferences.backgroundcolor);
  gdk_color_parse("white", &preferences.txfgcolor);
  gdk_color_alloc(colormap, &preferences.txfgcolor);
  gdk_color_parse("light grey", &preferences.rxfgcolor);
  gdk_color_alloc(colormap, &preferences.rxfgcolor);
  gdk_color_parse("red", &preferences.statusfgcolor);
  gdk_color_alloc(colormap, &preferences.statusfgcolor);
  gdk_color_parse("pink", &preferences.privatefgcolor);
  gdk_color_alloc(colormap, &preferences.privatefgcolor);
  gdk_color_parse("grey1", &preferences.privatebgcolor);
  gdk_color_alloc(colormap, &preferences.privatebgcolor);
  gdk_color_parse("yellow", &preferences.userfgcolor[0]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[0]);
  gdk_color_parse("green", &preferences.userfgcolor[1]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[1]);
  gdk_color_parse("blue", &preferences.userfgcolor[2]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[2]);
  gdk_color_parse("magenta", &preferences.userfgcolor[3]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[3]);
  gdk_color_parse("orange", &preferences.userfgcolor[4]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[4]);
  gdk_color_parse("cyan", &preferences.userfgcolor[5]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[5]);
  gdk_color_parse("purple", &preferences.userfgcolor[6]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[6]);
  gdk_color_parse("DarkKhaki", &preferences.userfgcolor[7]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[7]);
  gdk_color_parse("DarkCyan", &preferences.userfgcolor[8]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[8]);
  gdk_color_parse("DeepPink", &preferences.userfgcolor[9]);
  gdk_color_alloc(colormap, &preferences.userfgcolor[9]);
  preferences.commands = g_string_new("");

  /* open preferences file */
  preferencesfile = g_strconcat(preferencesdir, "/preferences", NULL);
  fp = fopen(preferencesfile, "r");
  if (fp == NULL) return;

  /* read preferences file */
  while(!feof(fp))
  {
    if (fscanf(fp, "%s %s", label, value) == EOF) break;
    if (!g_strcasecmp(label, "logging"))
    {
      if (!g_strcasecmp(value,"on"))
        preferences.logging = TRUE;
    }
    else
    {
      if (!g_strcasecmp(label, "autologin"))
      {
        if (!g_strcasecmp(value,"on"))
          preferences.autologin = TRUE;
      }
      else
      {
        if (!g_strcasecmp(label, "name"))
          preferences.name = g_string_new(value);
        else
        {
          if (!g_strcasecmp(label, "menu"))
          {
            if (!g_strcasecmp(value,"off"))
              preferences.menu = FALSE;
          }
          else
          {
            if (!g_strcasecmp(label, "statusbar"))
            {
              if (!g_strcasecmp(value,"off"))
                preferences.statusbar = FALSE;
            }
            else
            {
              if (!g_strcasecmp(label, "scrollbar"))
              {
                if (!g_strcasecmp(value,"off"))
                  preferences.scrollbar = FALSE;
              }
              else
              {
                if (!g_strcasecmp(label, "channel"))
                  preferences.channel = g_string_new(value);
                else
                {
                  if (!g_strcasecmp(label, "font"))
                    preferences.font = g_string_new(value);
                  else 
                  {
                    if (!g_strcasecmp(label, "backgroundpixmap"))
                      preferences.backgroundpixmap = g_string_new(value);
                    else
                    {
                      if (!g_strcasecmp(label, "commands"))
                        {
                        g_strdelimit(value, "-", ' ');
                        g_strchug(g_strchomp(value));
                        preferences.commands = g_string_new(value);
                        }
                      else 
                      {
                        if (!g_strcasecmp(label, "backgroundcolor"))
                          gdk_color_parse(color_parse(value), &preferences.backgroundcolor);
                        else 
                        {
                          if (!g_strcasecmp(label, "txfgcolor"))
                            gdk_color_parse(color_parse(value), &preferences.txfgcolor);
                          else
                          {
                            if (!g_strcasecmp(label, "rxfgcolor"))
                              gdk_color_parse(color_parse(value), &preferences.rxfgcolor);
                            else
                            {
                              if (!g_strcasecmp(label, "statusfgcolor"))
                                gdk_color_parse(color_parse(value), &preferences.statusfgcolor);
                              else
                              {
                                if (!g_strcasecmp(label, "privatefgcolor"))
                                  gdk_color_parse(color_parse(value), &preferences.privatefgcolor);
                                else
                                {
                                  if (!g_strcasecmp(label, "privatebgcolor"))
                                  gdk_color_parse(color_parse(value), &preferences.privatebgcolor);
                                  else
                                  {
                                    if (!g_strcasecmp(label, "user1fgcolor"))
                                     gdk_color_parse(color_parse(value), &preferences.userfgcolor[0]);
                                    else
                                    {
                                      if (!g_strcasecmp(label, "user2fgcolor"))
                                        gdk_color_parse(color_parse(value), &preferences.userfgcolor[1]);
                                      else
                                      {
                                        if (!g_strcasecmp(label, "user3fgcolor"))
                                          gdk_color_parse(color_parse(value), &preferences.userfgcolor[2]);
                                        else
                                        {
                                          if (!g_strcasecmp(label, "user4fgcolor"))
                                            gdk_color_parse(color_parse(value), &preferences.userfgcolor[3]);
                                          else
                                          {
                                            if (!g_strcasecmp(label, "user5fgcolor"))
                                              gdk_color_parse(color_parse(value), &preferences.userfgcolor[4]);
                                            else
                                            {
                                              if (!g_strcasecmp(label, "user6fgcolor"))
                                                gdk_color_parse(color_parse(value), &preferences.userfgcolor[5]);
                                              else
                                              {
                                                if (!g_strcasecmp(label, "user7fgcolor"))
                                                  gdk_color_parse(color_parse(value), &preferences.userfgcolor[6]);
                                                else
                                                {
                                                  if (!g_strcasecmp(label, "user8fgcolor"))
                                                    gdk_color_parse(color_parse(value), &preferences.userfgcolor[7]);
                                                  else
                                                  {
                                                    if (!g_strcasecmp(label, "user9fgcolor"))
                                                      gdk_color_parse(color_parse(value), &preferences.userfgcolor[8]);
                                                    else
                                                    {
                                                      if (!g_strcasecmp(label, "user10fgcolor"))
                                                        gdk_color_parse(color_parse(value), &preferences.userfgcolor[9]);
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  fclose(fp);
}

/*
 * Save preferences in ~/.xconvers/preferences.The default for menu, statusbar
 * and scrollbar is 'on', so we only save it if it is 'off'.
 */
 
void savepreferences(gboolean coloryes)
{
  gchar *preferencesfile, *commandstring;
  FILE *fp;

  /* open preferences file */
  preferencesfile = g_strconcat(preferencesdir, "/preferences", NULL);
  fp = fopen(preferencesfile, "w");
  if (fp == NULL) return;

  /* warning and version */
  fprintf(fp, "# settings file for xconvers, do not edit\n");
  fprintf(fp, "version %s\n", VERSION);

  /* settings */
  if (preferences.logging) fprintf(fp, "logging on\n");
  if (preferences.autologin) 
    {
    fprintf(fp, "autologin on\n");
    if (preferences.name) if (preferences.name->len > 0)
      fprintf(fp, "name %s\n", preferences.name->str);
    if (preferences.channel) if (preferences.channel->len > 0)
      fprintf(fp, "channel %s\n", preferences.channel->str);
    if (preferences.commands) 
      {
      if (preferences.commands->len > 0)
        {
        commandstring = g_strdup(preferences.commands->str);
        g_strdelimit(commandstring, " ", '-');
        fprintf(fp, "commands %s\n", commandstring);
        } else if (preferences.commands->len == 0) fprintf(fp, "commands -\n");
      }
    }
  if (!preferences.menu) fprintf(fp, "menu off\n");
  if (!preferences.statusbar) fprintf(fp, "statusbar off\n");
  if (!preferences.scrollbar) fprintf(fp, "scrollbar off\n");
  if (preferences.font) if (preferences.font->len > 0)
    fprintf(fp, "font %s\n", preferences.font->str);
  if (!coloryes) if (preferences.backgroundpixmap) if (preferences.backgroundpixmap->len > 0)
    fprintf(fp, "backgroundpixmap %s\n", preferences.backgroundpixmap->str);

  /* save the color settings */
  fprintf(fp, "backgroundcolor %04X,%04X,%04X\n", preferences.backgroundcolor.red, preferences.backgroundcolor.green, preferences.backgroundcolor.blue);
  fprintf(fp, "txfgcolor %04X,%04X,%04X\n", preferences.txfgcolor.red, preferences.txfgcolor.green, preferences.txfgcolor.blue);
  fprintf(fp, "rxfgcolor %04X,%04X,%04X\n", preferences.rxfgcolor.red, preferences.rxfgcolor.green, preferences.rxfgcolor.blue);
  fprintf(fp, "statusfgcolor %04X,%04X,%04X\n", preferences.statusfgcolor.red, preferences.statusfgcolor.green, preferences.statusfgcolor.blue);
  fprintf(fp, "privatefgcolor %04X,%04X,%04X\n", preferences.privatefgcolor.red, preferences.privatefgcolor.green, preferences.privatefgcolor.blue);
  fprintf(fp, "privatebgcolor %04X,%04X,%04X\n", preferences.privatebgcolor.red, preferences.privatebgcolor.green, preferences.privatebgcolor.blue);
  fprintf(fp, "user1fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[0].red, preferences.userfgcolor[0].green, preferences.userfgcolor[0].blue);
  fprintf(fp, "user2fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[1].red, preferences.userfgcolor[1].green, preferences.userfgcolor[1].blue);
  fprintf(fp, "user3fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[2].red, preferences.userfgcolor[2].green, preferences.userfgcolor[2].blue);
  fprintf(fp, "user4fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[3].red, preferences.userfgcolor[3].green, preferences.userfgcolor[3].blue);
  fprintf(fp, "user5fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[4].red, preferences.userfgcolor[4].green, preferences.userfgcolor[4].blue);
  fprintf(fp, "user6fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[5].red, preferences.userfgcolor[5].green, preferences.userfgcolor[5].blue);
  fprintf(fp, "user7fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[6].red, preferences.userfgcolor[6].green, preferences.userfgcolor[6].blue);
  fprintf(fp, "user8fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[7].red, preferences.userfgcolor[7].green, preferences.userfgcolor[7].blue);
  fprintf(fp, "user9fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[8].red, preferences.userfgcolor[8].green, preferences.userfgcolor[8].blue);
  fprintf(fp, "user10fgcolor %04X,%04X,%04X\n", preferences.userfgcolor[9].red, preferences.userfgcolor[9].green, preferences.userfgcolor[9].blue);
  fclose(fp);
}
