/*
 *  MoniKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DXCLUSTER_H
#define DXCLUSTER_H


typedef struct _s_dxc_dat
{
   struct _s_dxc_dat *next;
   char *prefixes;
   char *desc;
   int zone;
   double north;
   double east;
} s_dxc_dat;


class DXCluster
{
public:
   DXCluster();
   ~DXCluster();

   s_dxc_dat * getCallDescription( const char *call );
   void calcStnInfos(double north, double east, float & dist, double & degree);
   const char * courseName(double a);

private:
   void readDxcDat();

   s_dxc_dat *dxcroot;
};


#endif

