/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef GPG_H
#define GPG_H
//---------------------------------------------------------------------------
#include "senddata.h"

#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qstring.h>
//---------------------------------------------------------------------------
#define TRUST_UNDEFINED 0
#define TRUST_NEVER 1
#define TRUST_MARGINAL 2
#define TRUST_FULLY 3
#define TRUST_ULTIMATE 4
//---------------------------------------------------------------------------
#define SIG_BAD 0					// Signatur ist fehlerhaft
#define SIG_GOOD 1				// Signatur ist ok
#define SIG_ERR_UNKNOWN 2		// Unbekannter Algorithmus
#define SIG_ERR_MISSING 3		// Fehlender Public-Key
//---------------------------------------------------------------------------
#define TYPE_UNKNOWN 0
#define TYPE_SIGNATURE 1
#define TYPE_PUBKEY 2
//---------------------------------------------------------------------------
#define IMPORT_UNKNOWN 0
#define IMPORT_OK 1
//---------------------------------------------------------------------------
typedef struct
{
	char *type;
   char *bits;
   char *iType;
   char *id;
   char *uid;
} s_GPGKey;
//---------------------------------------------------------------------------
class GPGKeys : public QObject
{
	Q_OBJECT;
public:
   GPGKeys();
   ~GPGKeys();

   void listPub();
   void listSec();
	void freeKey( s_GPGKey *key );

signals:
	void gpgKey( s_GPGKey *key );

private:
	bool rxData( int fd );

   char save[500];
};
//---------------------------------------------------------------------------
class DlgGetPW : public QDialog
{
	Q_OBJECT;

public:
	DlgGetPW( QWidget *parent );
   ~DlgGetPW();

	QString getPw();

private:
	QLabel *l;
   QLineEdit *pw;
   QPushButton *ok, *abort;
   QAccel *a;
};
//---------------------------------------------------------------------------
class GPGDialog : public QDialog, SendData
{
	Q_OBJECT;
public:
	GPGDialog( QWidget *parent, Channel *chan );
	~GPGDialog();

   void resizeEvent(QResizeEvent *event);
	void setData( const QString & board, const QString & mbx, const QString & subject );
   void setComment( const QString & sendString, int nr, const QString & board, const QString & sender );
   void setReply( const QString & sendString, int nr, const QString & board, const QString & sender );

public slots:
	void slotSendClicked();
   void slotImportClicked();
	void slotTypeSelected( const QString & str );

protected:
	void closeEvent( QCloseEvent * );

private:
	bool getPW();
	int callGPG();
	void addSignature();

   QString strReplyComment;
   char *infile, *outfile, *pw;
	QComboBox *cmbType;
   QLineEdit *edBoard, *edMbx, *edLt, *edSubject;
   QMultiLineEdit *medMessage;
   QPushButton *btnImport, *btnSend, *btnCancel;
   QLabel *lSubject, *lReplyComment;
};
//---------------------------------------------------------------------------
// Diese Klasse wird mit allen empfangenen Daten, die nicht binaer sind,
// aufgerufen. Wird ein GPG-File entdeckt, wird es mitgeschrieben.
class CheckGPG : public QObject, SendData
{
	Q_OBJECT;
public:
	CheckGPG( Channel *chan );
   ~CheckGPG();

	void proceed( const char *data, int len );
   void abort();

private:
	char * getUniqueFilename();
	void checkSignature();
	void checkPubKey();
	bool rxSignatureData( int fd );
   bool rxPubkeyData( int fd );

   int fd;
   int lines;
   char *filename;
   char save[500];
   char username[500];
   int sig, trust, type, import;
   long sigdate;
   char keyid[50];
	int k_count, k_nouid, k_imported, k_unchanged, k_uid, k_subk, k_sigs;
   int k_revoc, k_secread, k_secimp, k_secups;
};
//---------------------------------------------------------------------------
class GPGSendPKey : public QDialog, SendData
{
	Q_OBJECT;
public:
	GPGSendPKey(  QWidget *parent, Channel *chan );
   ~GPGSendPKey();

public slots:
	void slotSendClicked();
   void slotIDFragChanged( const QString & string );

private:
	bool rxData( int fd );
	bool rxDataB( int fd );

   int len;
   char save[500];
   char *data;
	QListView *IDs;
   QList<QListViewItem> *keyList;
   QWidget *fragmWidget;
   QLineEdit *edIDFrag;
   QPushButton *btnSend, *btnAbort;
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

