/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "checksums.h"

#include "md5.h"
#include "crc.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
//---------------------------------------------------------------------------
CheckSums::CheckSums()
{
}
//---------------------------------------------------------------------------
CheckSums::~CheckSums()
{
}
//---------------------------------------------------------------------------
/* Berechnet die CRC aus einem ganzen String */
unsigned short CheckSums::calcCrcthpStr( const char *str, const int len, unsigned short crc )
{
  int i;
  
  i = 0;
  while (i < len)
  {
    crcthp(str[i],&crc);
    i++;
  }
  
  return(crc);
}
//---------------------------------------------------------------------------
unsigned short CheckSums::calcCrcthpWholefile( const QString & path )
{
	unsigned short crc=0;
	int fd,count,ready=FALSE;
	char tmp[500];
  
  
	if ((fd = open(path.latin1(),O_RDONLY)) == -1) return 0;
  
	while (!ready)
   {
		count = read(fd,tmp,499);
		if (count != 499) ready = TRUE;
    
		crc = calcCrcthpStr( tmp, count, crc );
	}

	::close(fd);

	return crc;
}
//---------------------------------------------------------------------------
bool CheckSums::calcMD5wholefile( const QString & filename, unsigned char *digest )
{
  int fd,count,ready=FALSE;
  char tmp[500];
  MD5_CTX md5Context;


  if ((fd = open(filename.latin1(), O_RDONLY)) == -1) return false;

  MD5Init(&md5Context);

  while (!ready)
  {
    count = read(fd,tmp,499);
    if (count != 499) ready = TRUE;

    MD5Update(&md5Context, (unsigned char *) tmp, count);
  }

  ::close(fd);

  MD5Final(&md5Context);

  memcpy(digest, md5Context.digest, 16);

  return true;
}
//---------------------------------------------------------------------------
// Berechnet den MD5-Hash nur von einem Teil des Files, und zwar bis nur
// "length" Bytes.
bool CheckSums::calcMD5partfile( const QString & filename, unsigned char *digest, int length )
{
   int fd,count,ready=FALSE;
   char tmp[500];
   MD5_CTX md5Context;


   if ((fd = open(filename.latin1(), O_RDONLY)) == -1) return false;

   MD5Init(&md5Context);

   while (!ready)
   {
      if (length < 499)
      {
         count = read(fd,tmp,length);
         if (count != length) ready = TRUE;
      }
      else
      {
         count = read(fd,tmp,499);
         if (count != 499) ready = TRUE;
      }

      length -= count;

      MD5Update(&md5Context, (unsigned char *) tmp, count);
   }

   ::close(fd);

   MD5Final(&md5Context);

   memcpy(digest, md5Context.digest, 16);

   return true;
}
//---------------------------------------------------------------------------
