.\" t
.\" @(#)WinList.1	002/07/00
.TH WinList 1.8 "Feb 7 2000"
.UC
.SH NAME
\fBWinList\fP \- the AfterStep window list module

.SH SYNOPSIS
\fBWinList\fP [\-f \fIconfig_file\fP] [\-v | \--version] [\-h | \--help]
.sp
Although \fBWinList\fP can be run from the command line, it is normally 
spawned by afterstep in the \fIautoexec\fP file, in the following manner:
.nf
.sp
	Module	"I"	WinList
.sp
.fi
From within an \fIafterstep\fP menu file by 'WinList':
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/WinList"
	Module "WinList" WinList
	MiniPixmap "mini-as.xpm"
.fi

To stop the \fBWinList\fP module, a menu item can be used:
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/WinList_Stop"
	KillModuleByName "Stop WinList" WinList
	MiniPixmap "mini-as.xpm"
.fi

.SH DESCRIPTION
The \fBWinList\fP module provides a window list made up of buttons, each
corresponding to a window that AfterStep is managing.  Clicking on the
buttons with any of the three mouse buttons will either do a default
action or can be user configured by editing the \fIwinlist\fP file.

.SH OPTIONS
.IP "\-f \fIconfig_file\fP"
Use \fIconfig_file\fP instead of the default configuration file.

.IP "\-h | \--help"
Print a usage message and exit successfully.

.IP "\-v | \--version"
Print version information and exit successfully.

.SH INITIALIZATION
During initialization, \fBWinList\fP will search a configuration file
which describes the colors, font, actions to take on mouse clicks, and
geometry settings to use. This file will be the one specified by the 
\fI\-f\fP option (if given).  Else, the ~/GNUstep/Library/AfterStep/winlist 
file will be used if it exists.  Else, /usr/local/share/afterstep/winlist 
will be used.

If the \fBWinList\fP executable is linked to another name, ie 'ln -s
\fBWinList\fP \fBOtherWinList\fP', then another module called
\fBOtherWinList\fP can be started, with a completely different set of
configurations than \fBWinList\fP, simply by adding \fI*OtherWinList\fP
options following the same \fI*WinList\fP configuration options below to the
\fIwinlist\fP file. This way multiple Identify programs can be used.

.SH INVOCATION
\fBWinList\fP can be invoked from the \fIautoexec\fP file or from a menu
item as shown in the Synopsis section above.

\fBWinList\fP can also be invoked from binding "Module WinList
\fIargument\fP" to a keystroke or mouse button using \fITransient\fP as an
argument which will cause \fBWinList\fP to resemble the built-in window
list.

AfterStep will search through the directories specified in the
\fIModulePath\fP configuration in the \fIbase.#bpp\fP (where # is your
colordepth) to attempt to locate WinList.

.SH CONFIGURATION OPTIONS
\fBWinList\fP reads the \fIwinlist\fP file when it starts up, and looks
for its configuration options.  The MyStyle structure should now be specified
in the look files.  This allows for a greater control of the running module
(different WinList look with different desktop looks, dynamic reconfiguration
etc.).

.IP "MyStyle ""*WinList"""
.IP "  \fIstyle_option\fP"
.IP "~MyStyle"

The possible \fIstyle_option\fPs follow:

.RS
.IP "Font \fIfont\fP"
Specifies the font associated with this style. \fIfont\fP is a standard 
X11 font definition.

.IP "ForeColor \fIcolor\fP"
Specifies the text color associated with this style. \fIcolor\fP is a 
standard X11 color definition.

.IP "BackColor \fIcolor\fP"
Specifies the background color associated with this style. \fIcolor\fP 
is a standard X11 color definition.

.IP "TextStyle \fIstyle\fP"
Specifies the text \fIstyle\fP associated with this style. \fIstyle\fP 
can be 0, 1, or 2:

.nf
0: normal text
1: 3d effect #1
2: 3d effect #2
.fi

.IP "MaxColors \fImaximum\fP"
Specifies the \fImaximum\fP number of colors that the \fIBackGradient\fP 
can use. jpegs specified with \fIBackPixmap\fP will also be limited to 
this number of colors.

.IP "BackGradient \fItype\fP \fIfrom\fP \fIto\fP"
Specifies that a gradient should be used as a background instead of a 
solid color. The gradient colors start at \fIfrom\fP and end at \fIto\fP. 
\fIfrom\fP and \fIto\fP are standard X11 color definitions. \fItype\fP 
can be 1, 2, 3, 4, or 5:

.nf
1: Wharf-style diagonal gradient
2: Horizontal from top to bottom
3: Horizontal from top/bottom to center
4: Vertical from left to right
5: Vertical from left/right to center
.fi

.IP "BackPixmap \fItype\fP \fIpixmap_name|color_name\fP"
Specifies that a pixmap should be used as a background instead of a 
solid color. This option has two forms, depending on the value of 
\fItype\fP. If \fItype\fP is 128, the second parameter, \fIpixmap_name\fP 
must be the name of an xpm, jpeg, or png image which can be found in 
\fIPixmapPath\fP. If \fItype\fP is 129, the root pixmap (desktop 
background) will be used, and the optional second parameter must be a 
color with which the root pixmap will be shaded.

.nf
128: tiled pixmap from the upper left
129: "transparent"
.fi

.RE

.IP "*WinListGeometry \fIgeometry\fP"
Specifies the location and gravity of the WinList window.  At the current
time, size is not supported and WinList will resize itself as buttons are
added.  If the NoAnchor option is not specified then the window's gravity
corner will be anchored, and the window will grow in the opposite direction.
(i.e. If the geometry is specified -5-5, that is SoutEastGravity.  This will
cause the window to draw up and to the left as windows are added)

.IP "*WinListHideGeometry \fIgeometry\fP"
Specifies the location of the WinList window when there are no windows. 
It will cause WinList to display nice little window with AfterStep version
in there. If size is supplied WinList will center the label within the 
window.

.IP "*WinListUseSkipList"
Tells \fBWinList\fP to not show the windows that are have
\fIWindowListSkip\fP as a \fIStyle\fP option in the \fdatabase\fP file.

.IP "*WinListNoAnchor"
By default, \fBWinList\fP will anchor the gravity corner so the window will
grow in the opposite direction.  This undoes that option.

.IP "*WinListUseIconNames"
Tells WinList to use the icon name of the window instead of the full window
name.  This is useful to keep the width of the window small.

.IP "*WinListAction \fIaction response[,reponse...]\fP"
Tells WinList to do \fIresponse\fP when \fIaction\fP is done.  The
currently supported \fIaction\fPs are: Click1, Click2, Click3.  The
currently supported \fIresponse\fPs are any AfterStep built-in commands,
including modules and functions.

.IP "*WinListOrientation \fIdown|across\fP"
Will make a vertical or horizontal winlist.

.IP "*WinListMaxWidth \fIwidth in pixel\fP"
Sets either maxwidth for a vertical winlist or the actual width for a
horizontal "taskbar".

.IP "*WinListJustify \fI<Left|Center|Right>\fP"
If used, will justify the text as specifyed. If unspecified, the default is
to center text.

.IP "*WinListAutoHide \fInumber\fP"
Makes \fBWinList\fP auto-hide, when the mouse cursor travels off \fBWinList\fP it reduces its size and becomes a line, when the mouse cursor travels onto hidden \fBWinList\fP it readjusts its size to normal dimensions.  0 turns this feature off, positive numbers turn it on.  This option makes sense only when \fBWinList\fP is set to \fIStaysOnTop\fP in the database file. It is possible to turn \fIAutoHide\fP on/off when the module is running: pressing 'u' while the cursor is in the \fBWinList\fP window permanently unhides, pressing 'h' while the cursor is in the \fBWinList\fP window turns \fIAutoHide\fP on.

.IP "*WinListBalloons"
Turns on the balloon feature. A "balloon" is displayed showing the name 
of the button the pointer is resting on in the \fBWinList\fP. The balloon 
background and text are configured with the MyStyle "*WinListBalloon".  
See \fBafterstep(1x)\fP for more information on MyStyles.

.IP "*WinListBalloonBorderWidth \fInumber\fP"
Sets the width of the balloon window's border. Defaults to 1.

.IP "*WinListBalloonBorderColor \fIcolor\fP"
Sets the color of the balloon window's border. Defaults to black.

.IP "*WinListBalloonDelay \fInumber\fP"
Specifies the period in milliseconds to delay the appearance of the balloon.

.IP "*WinListBalloonYOffset \fInumber\fP"
The balloon window is positioned to be horizontally centered against
the \fBWinList\fP window it is describing. The vertical position may be
set as an offset. Negative offsets of \fI-N\fP are placed \fIN\fP
pixels above the \fBWinList\fP window, positive offsets of \fI+N\fP are 
placed \fIN\fP pixels below. Defaults to +2.

.SH FILES

.IP \fI/usr/local/share/afterstep/winlist\fP
The global configuration file for system wide defaults of all users.

.IP \fI$HOME/GNUstep/Library/AfterStep/winlist\fP
This file should be copied from the \fI/usr/local/share/afterstep/winlist\fP and edited to suit the user's specific requirements.  This file, if exists, will override the system wide default file.

.SH EXAMPLES
The \fIwinlist\fP file shipped contains a working example, refer to the
\fBFILES\fP section above for its configuration options.

.sp
To pop up the window list in tranient mode (appear only when button 3 is
pressed & held):
.sp
	...the \fIfeel\fP file would contain \-
.nf
	Mouse 3  R  A  Module "WinList" WinList Transient
.sp
.fi

.SH AUTHORS
Rene Fichter <ceezaer@cyberspace.org>
.nf
Mike Finger <mfinger@mermaid.micro.umn.edu>
.nf
David Mihm <dmihm@swbell.net> [Man page]
.nf
Rafal Wierzbicki <rafal@mcss.mcmaster.ca>
.SH SEE ALSO
.BR afterstep (1),
