/* symbols.h - header file for speakup's internal symbols. */

#ifndef _SYMBOLS_H
#define _SYMBOLS_H

/* ioctls to call kernel */
#define SPKLOADCFG	0x5301
#define SPKDUMPCFG	0x5302
#define SPKHARDWARE	0x5303
#define SPKDIRECTSEND	0x5304

/* error codes */
#define ESYNTAX		2
#define ENOVAR		3
#define ESPKRANGE	4
#define EIOCTL		5
#define EALIAS		6

struct spk_variable {
	char *id;	/* command as displayed in loadspk/dumpspk */
	char *param;	/* value of the parameter to the command */
	char *build;	/* a string, describing how to construct the 
			 * string sent to the synth, with the character '_' 
			 * to be filled in with the parameter.  eg.  "\x01_P"
			 * will convert to "\x01+30P", if param is "+30"
			 */
	int flags;	/* see #defines below */
	char valid[33];	/* If the flag USE_RANGE is given, valid is a
			 * range described by "lowval,highval".  For example,
			 * "0,20" is the range 0-20.
			 *
			 * If USE_RANGE is not given, valid is a
			 * "-1"-terminated set of valid values for param.
			 * eg. { 'a', 'e', 'i', 'o', 'u', -1 } or "aeiou\xff"
			 *
			 * an empty set { -1 } matches anything.
			 */
};

#define DIRECT_CMD "direct"

/* flags */
#define HARD_DIRECT	0x01	/* a variable that is immediately sent to the
				 * hardware synth 
				 */
#define SOFT_DIRECT	0x02	/* as above, but sent to speakup */
#define NUMERIC		0x04	/* ascii-represented numerical value
				 * currently requires USE_RANGE to be set
				 * as well
				 */
#define USE_RANGE	0x08	/* all variables from valid_set[0] to 
				 * valid_set[1] are accepted (ascii range) 
				 */
#define BUILDER		0x10	/* variable must be built into the
				 * reset string
				 */
#define NO_USER		0x20	/* if set, this variable is not allowed to
				 * be set by the user.  I recommend naming
				 * the variable with the first character
				 * '#', so it's commented out when dumpspk
				 * is run
				 */
#define ALLOW_BLANK	0x40	/* alias-only flag to allow a blank parameter */



#define ZILCH { "", "", "_", 0 , { -1 } }
#define TOGGLE "0,1"

/* speakup only (not synth) variables */
#define NUM_SPKUP_VARS 11

#define SPKUP_VARS {\
	{ "line_wrap_bleep", "1", "_", (NUMERIC|SOFT_DIRECT|USE_RANGE), TOGGLE }, \
	{ "attribute_bleep", "1", "_", (NUMERIC|SOFT_DIRECT|USE_RANGE), TOGGLE }, \
	{ "bleep_time", "3", "_", (NUMERIC|SOFT_DIRECT|USE_RANGE), "0,9" }, \
	{ "spell_delay", "2", "_", (NUMERIC|SOFT_DIRECT|USE_RANGE), "1,5" }, \
	{ "punc_level", "1", "_", (NUMERIC|SOFT_DIRECT|USE_RANGE), "0,3" }, \
	{ "say_control", "0", "_", (NUMERIC|SOFT_DIRECT|USE_RANGE), TOGGLE }, \
	{ "no_interrupt", "0", "_", (NUMERIC|SOFT_DIRECT|USE_RANGE), TOGGLE }, \
	{ "#punc_none", "", "_", (SOFT_DIRECT|NO_USER), { -1 } }, \
	{ "punc_some", "/$%&", "_", SOFT_DIRECT, { '*',-1 } }, \
	{ "punc_most", "($%&#@=+*^<>|\\)", "_", SOFT_DIRECT, { '*',-1 } }, \
	{ "#punc_all", "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~", "_", (SOFT_DIRECT|NO_USER), { -1 } }\
}

#define NUM_SYNTHS 9
#define MAX_STATIC 7
#define MAX_XTEND 10
#define MAX_ALIAS 30

#define DTLK 0
#include "symbols_dtlk.h"

#define ACNTPC 1
#include "symbols_acntpc.h"

#define SPKOUT 2
#include "symbols_spkout.h"

#define TXPRT 3
#include "symbols_txprt.h"

#define BNS 4
#include "symbols_bns.h"

#define AUDPTR 5
#include "symbols_audptr.h"

#define DECTLK 6
#include "symbols_dectlk.h"

#define DECEXT 7
#include "symbols_decext.h"

#define APOLO 8
#include "symbols_apolo.h"

#define NAMES {\
	"DoubleTalk/LiteTalk",\
	"Accent PC/SA",\
	"Speakout",\
	"Transport",\
	"Braille n Speak",\
	"Audapter",\
	  "Dectalk Express",\
	  "Dectalk External",\
	  "Apolo 2/Juno"\
}

/* all of the following should be defined in the respective symbols_*.h files
	included above */

#define ALL_NUM_STATIC {\
	NUM_STATIC_DTLK,\
	NUM_STATIC_ACNTPC,\
	NUM_STATIC_SPKOUT,\
	NUM_STATIC_TXPRT,\
	NUM_STATIC_BNS,\
	NUM_STATIC_AUDPTR,\
	NUM_STATIC_DECTLK,\
	NUM_STATIC_DECEXT,\
	NUM_STATIC_APOLO\
}
#define ALL_STATIC {\
	STATIC_STR_DTLK,\
	STATIC_STR_ACNTPC,\
	STATIC_STR_SPKOUT,\
	STATIC_STR_TXPRT,\
	STATIC_STR_BNS,\
	STATIC_STR_AUDPTR,\
	STATIC_STR_DECTLK,\
	STATIC_STR_DECEXT,\
	STATIC_STR_APOLO\
}

#define ALL_NUM_XTEND {\
	NUM_XTEND_DTLK,\
	NUM_XTEND_ACNTPC,\
	NUM_XTEND_SPKOUT,\
	NUM_XTEND_TXPRT,\
	NUM_XTEND_BNS,\
	NUM_XTEND_AUDPTR,\
	NUM_XTEND_DECTLK,\
	NUM_XTEND_DECEXT,\
	NUM_XTEND_APOLO\
}
#define ALL_XTEND {\
	XTEND_STR_DTLK,\
	XTEND_STR_ACNTPC,\
	XTEND_STR_SPKOUT,\
	XTEND_STR_TXPRT,\
	XTEND_STR_BNS,\
	XTEND_STR_AUDPTR,\
	XTEND_STR_DECTLK,\
	XTEND_STR_DECEXT,\
	XTEND_STR_APOLO\
}

#define ALL_NUM_ALIAS {\
	NUM_ALIAS_DTLK,\
	NUM_ALIAS_ACNTPC,\
	NUM_ALIAS_SPKOUT,\
	NUM_ALIAS_TXPRT,\
	NUM_ALIAS_BNS,\
	NUM_ALIAS_AUDPTR,\
	NUM_ALIAS_DECTLK,\
	NUM_ALIAS_DECEXT,\
	NUM_ALIAS_APOLO\
}
#define ALL_ALIAS {\
	ALIAS_STR_DTLK,\
	ALIAS_STR_ACNTPC,\
	ALIAS_STR_SPKOUT,\
	ALIAS_STR_TXPRT,\
	ALIAS_STR_BNS,\
	ALIAS_STR_AUDPTR,\
	ALIAS_STR_DECTLK,\
	ALIAS_STR_DECEXT,\
	ALIAS_STR_APOLO\
}
#endif
