/*******************************
 Handling of ICQ (sound) events 
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <gdk/gdk.h>

/*** Global functions ***/
void gnomeicu_event(ICQEvType event, UIN_T uin)
{
  GSList *contact_list;
  CONTACT_PTR contact=NULL;

#ifdef TRACE_FUNCTION
  g_print( "gnomeicu_event(%d)\n", event );
#endif

  if (uin) 
    {
      contact_list = Contacts;

      while( contact_list != NULL )
	{
	  if( uin == ((CONTACT_PTR)contact_list->data)->uin )
	    {
	      contact = (CONTACT_PTR)contact_list->data;	     
	      break;
	    }
	  contact_list = g_slist_next(contact_list);
	}
      if( contact ) 
	gnomeicu_fire_external_program(event, contact);
    }

      
#ifdef SOUND
	if( toggles->sound && enable_online_events )
	{
		switch(event)
	{
	case EV_MSGRECV: 
		gnome_triggers_do("", "program", "GnomeICU", "message", NULL); 
		break;
	case EV_USERON: 
		gnome_triggers_do("", "program", "GnomeICU", "online", NULL);
		break;
	case EV_USEROFF:
		gnome_triggers_do("", "program", "GnomeICU", "offline", NULL); 
		break;
	case EV_CHATREQ: 
		gnome_triggers_do("", "program", "GnomeICU", "chat", NULL); 
		break;
	case EV_CHATBEEP:
		gnome_triggers_do("", "program", "GnomeICU", "chatbeep", NULL); 
		break;
	case EV_URLRECV: 
		gnome_triggers_do("", "program", "GnomeICU", "url", NULL); 
		break;
	case EV_AUTHREQ:
		gnome_triggers_do("", "program", "GnomeICU", "authreq", NULL);
		break;
	case EV_AUTH:
		gnome_triggers_do("", "program", "GnomeICU", "auth", NULL); 
		break;
	case EV_FILEREQ:
		gnome_triggers_do("", "program", "GnomeICU", "file", NULL);
		break;
	case EV_LISTADD:
		gnome_triggers_do("", "program", "GnomeICU", "notify", NULL);
		break;
	case EV_CONTLIST:
		gnome_triggers_do("", "program", "GnomeICU", "contlist", NULL);
		break;
	}
    }

  if( toggles->beep && enable_online_events )
    {
      gdk_beep();
    }
#endif

}

void gnomeicu_fire_external_program( ICQEvType event, CONTACT_PTR contact )
{
  char *command=NULL;
  GString* s;
  gchar *p;

#ifdef TRACE_FUNCTION
  g_print( "gnomeicu_fire_external_program(%d,%x)\n", event, (int)contact );
#endif

  g_return_if_fail ( contact );

  if( enable_online_events )
    {
      switch(event)
    {
    case EV_MSGRECV: 
	    if ( toggles->program_on_receive_message  )
		    command = programs->receive_message; 
	    break;
    case EV_CHATREQ: 
	    if ( toggles->program_on_chat_request )
		    command = programs->chat_request;
	    break;
    case EV_URLRECV: 
	    if ( toggles->program_on_receive_url )
		    command = programs->receive_url;
	    break;
    case EV_FILEREQ:
	    if ( toggles->program_on_file_request )
		    command = programs->file_request;
	    break;
    case EV_USERON:
	    if ( toggles->program_on_user_online )
		    command = programs->user_online;
	    break;
    case EV_USEROFF:
	    if ( toggles->program_on_user_offline )
		    command = programs->user_offline;
	    break;
    case EV_AUTH:
	    if ( toggles->program_on_auth )
		    command = programs->auth;
	    break;
    case EV_AUTHREQ:
	    if ( toggles->program_on_auth_request )
		    command = programs->auth_request;
	    break;
    case EV_LISTADD:
	    if ( toggles->program_on_list_add )
		    command = programs->list_add;
	    break;
    case EV_CONTLIST:
	    if ( toggles->program_on_contact_list ) 
		    command = programs->contact_list;
	    break;
    default:
	    break;
    }
  }

  if( command ) {
    s = g_string_new(NULL);
    p = command;
    while (*p) {
      if( *p == '%' ) 
      {
	switch ( *(p+1) ) 
	{
	case 'n': g_string_append( s, contact->nick ); break;
	case 'u': g_string_sprintfa( s, "%d", contact->uin ); break;
	case '%': g_string_append_c( s, '%' ); break;
	default:  g_string_append_c( s, *(p+1) ); break;
	}
	p++;
      } 
      else
      {
	g_string_append_c( s, *p );
      }
      p++;
    }
#ifdef TRACE_FUNCTION
    g_print ("Execute: %s\n", s->str);
#endif
    gnome_execute_shell(NULL, s->str);
    g_string_free(s,0);
  }
}
