/*
 * IceWM
 *
 * Copyright (C) 1997 Marko Macek
 */

#include "icewm.h"

YPixmap::YPixmap(char *fileName) {
    XpmAttributes xpmAttributes;
    int rc;
    Pixmap unusedMask;

    xpmAttributes.colormap  = defaultColormap;
    xpmAttributes.closeness = 40000;
    xpmAttributes.valuemask = XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;

    rc = XpmReadFileToPixmap(app->display(),
                             app->root()->handle(),
                             REDIR_ROOT(fileName),
                             &fPixmap, &unusedMask,
                             &xpmAttributes);

    if (rc == 0) {
       fWidth = xpmAttributes.width;
       fHeight = xpmAttributes.height;
       XFreePixmap(app->display(), unusedMask);
    } else { 
       fWidth = fHeight = 16; 
       fPixmap = None;
    }

    if (rc != 0)
        fprintf(stderr, "warning: load pixmap %s failed with rc=%d\n", fileName, rc);
}

YPixmap::~YPixmap() {
    if (fPixmap != None) XFreePixmap(app->display(), fPixmap);
}

YMaskPixmap::YMaskPixmap(char *fileName) {
    XpmAttributes xpmAttributes;
    int rc;

    xpmAttributes.colormap  = defaultColormap;
    xpmAttributes.closeness = 40000;
    xpmAttributes.valuemask = XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;

    rc = XpmReadFileToPixmap(app->display(),
                             app->root()->handle(),
                             REDIR_ROOT(fileName),
                             &fPixmap, &fMask,
                             &xpmAttributes);

    if (rc == 0) {
       fWidth = xpmAttributes.width;
       fHeight = xpmAttributes.height;
    } else {
       fWidth = fHeight = 16;
       fPixmap = fMask = None;
    }

    if (rc != 0)
        fprintf(stderr, "warning: load pixmap %s failed with rc=%d\n", fileName, rc);
}

YMaskPixmap::~YMaskPixmap() {
    if (fPixmap != None) XFreePixmap(app->display(), fPixmap);
    if (fMask != None) XFreePixmap(app->display(), fMask);
}

YIcon *firstIcon = 0;

YIcon::YIcon(char *fileName) {
    fNext = firstIcon;
    firstIcon = this;
    loadedS = loadedL = 0;
    
    fLarge = fSmall = 0;
    fPath = new char [strlen(fileName) + 1];
    if (fPath)
        strcpy(fPath, fileName);
}

YIcon::~YIcon() {
    delete fLarge;
    delete fSmall;
}

int YIcon::findIcon(char **fullPath, int size) {
    char icons_size[1024];

    sprintf(icons_size, "%s_%dx%d.xpm", REDIR_ROOT(fPath), size, size);
 
    if (!findPath(iconPath, R_OK, icons_size, fullPath)) {
        fprintf(stderr, "icon '%s' for '%s' not found.\n", icons_size, fPath);
        return 0;
    }
    return 1;
}

YMaskPixmap *YIcon::loadIcon(int size) {
    char *fullPath;
    YMaskPixmap *icon = 0;
  
    if (findIcon(&fullPath, size)) {
        icon = new YMaskPixmap(fullPath);
        if (icon == 0)
            fprintf(stderr, "out of memory for pixmap %s", fullPath);
        free(fullPath);
    }
    return icon;
}

YMaskPixmap *YIcon::large() {
    if (fLarge == 0 && !loadedL)
        fLarge = loadIcon(ICON_LARGE);
    loadedL = 1;
    return fLarge;
}

YMaskPixmap *YIcon::small() {
    if (fSmall == 0 && !loadedS)
        fSmall = loadIcon(ICON_SMALL);
    loadedS = 1;
    return fSmall;
}

YIcon *getIcon(char *name) {
    YIcon *icn = firstIcon;

    while (icn) {
        if (strcmp(name, icn->iconName()) == 0)
            return icn;
        icn = icn->next();
    }
    return new YIcon(name);
}
