/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef OUTPUT_H
#define OUTPUT_H


#include <qobject.h>
#include <qwidget.h>
#include <qtableview.h>
#include <qlist.h>
#include <qevent.h>
#include <qscrollbar.h>
#include <qpainter.h>
#include <qtimer.h>


#define MARKDIR_TOPDOWN 1
#define MARKDIR_DOWNTOP 2


// In jeder Zeile koennen mehrere Strings unterschiedlicher Farbe stehen.
// In dieser Struktur wird je eine Zeile abgespeichert.
typedef struct _s_outputline
{
   struct _s_outputline *next;
   char *text;
   QColor color;
} s_outputline;


class OutputLine
{
public:
   OutputLine(QFont f, QColor colback);
   ~OutputLine();

   void addString( char *str, QColor color );
   void drawString( int x, int y, int w, int h, QPainter *painter );
   void markLine( bool mark );
   void getLine( char *l );
   int getLineLength();

private:
   QFont font;
   s_outputline *line;
   bool markline;
   QColor background;
};



class OutputWidget : public QTableView
{
   Q_OBJECT;
public:
   OutputWidget( QWidget* parent=0 );
   ~OutputWidget();

   void newLine();
   void writeText( char *text, QColor color );
   void setFont(QFont & f);
   void setBackgroundColor( QColor & colback );
   void clearAllMarks();

   void resizeEvent(QResizeEvent *e);
   void updateCurrentLine();

private:
   QList<OutputLine> *rows;
   QFont font;
   const QScrollBar *vscroll;
   int lenlastline;
   bool marking, mark_new;
   QTimer *scrolltimer;
   int firstline,lastline;
   int markdirection;
   QColor background;

signals:
   void kontextMenu();

public slots:
   void slotPageUp();
   void slotPageDown();
   void slotTimerUnten();
   void slotTimerOben();

protected:
   void paintCell( QPainter *p, int row, int col );
   void mousePressEvent( QMouseEvent *e );
   void mouseReleaseEvent( QMouseEvent *e );
   void mouseMoveEvent( QMouseEvent *e );
};


#endif /* OUTPUT_H */

