/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef TOOLBOX_H
#define TOOLBOX_H

#include <sys/socket.h>
/*#include <linux/ax25.h>*/
#include <md5.h>


#ifndef TRUE
  #define TRUE 1
#endif

#ifndef FALSE
  #define FALSE 0
#endif



/* Kopiert 'count' Zeichen von 'src' nach 'dest' ab Position 'start'. 
   src und dest mssen 2 VERSCHIEDENE Strings sein! */
void COPY(char *dest, const char *src, int start, int count);


/* Wandelt alle Kleinbuchestaben in Grossbuchstaben um */
void Gross(char *str);


/* Wandelt alle Grossbuchestaben in Kleinbuchstaben um */
void Klein(char *str);


/* Wandelt einen Buchstaben in Grossbuchstaben um */
char upcase(char input);


/* Gibt die erste Position des Zeichens an, oder -1, wenn das Zeichen nicht in
   str ist */
int POS(char zeichen, const char *str);
int nPOS(char zeichen, const char *str, int len);


/* Gibt die letzte Position des Zeichens an, oder -1, wenn das Zeichen nicht in
   str ist */
int lPOS(char zeichen, const char *str);


/* Schreibt das bergebene Zeichen anz mal in den dest-string */
void StringD(char *dest, int anz, char zeichen);


/* Vergleicht die beiden Strings. Rckgabe: 1, wenn gleich, 0 wenn nicht */
int strcompare(char *str1, char *str2);


/* Alle Leerzeichen links vom String lschen */
void KillSpacesLeft(char *str);


/* Alle Leerzeichen rechts lschen */
void KillSpacesRight(char *str);


/* Gre des bergebenen Files zurckgeben. Wenn nicht vorhanden wird -1 zurck gegeben. */
long filesize(char *filename);


/* ALLE Leerzeichen in str lschen, und den sich dann ergebenen String nach tmp schreiben */
void KillAllSpaces(char *tmp, char *str);


/* Wenn mehr als ein Leerzeichen nacheinander kommt, werden die brigen Leerzeichen
   gelscht. */
void OnlyOneSpace(char *tmp, const char *str);


/*
 * Lscht count Zeichen aus dem String str ab Position pos
 */
/*void delete(char *str, int pos, int count);*/


/*
 * Liest Zeichen bis zum nchsten vorkommen von sign aus dem File mit der bergebenen fd ein.
 *
 * Es findet KEINE berlaufprfung statt!
 */
int fdgets(int fd, char *str, char sign);


/* Wandelt den Integer-Wert in Hex-Zahlen um */
void int2hchar(int zahl, char *c1, char *c2);


int file_exist(const char *filename);


/* Kopiert einen Integer-Array in einen anderen */
void intcpy(int *dest, int *src, int count);


char *dec2bin(unsigned int dec);


long get_freemem();


/*
 * Sucht in den ersten count Bytes in str nach search. In search darf kein 0-Byte
 * vorkommen. Zurckgegeben wird die Position von search in str.
 *
 * Ist es garnicht enthalten, wird -1 zurck gegeben.
 */
int memstr(char *str, char *search, int count);


/*
*** get_hex: some compilers have real big trouble when reading hex values from
***          a file with fscanf() that have leading zeros! e.g. 00A will be
***          read as two separate values (0 and A)! grr!!
***          get_hex skips all leading zeros to eliminate the problem.
***
 */
unsigned int get_hex (char *hex);

void delayus (int us);

char *spec_time(int zeit);

unsigned short calc_crcthp_str(const char *str, const int len, unsigned short crc);

unsigned short calc_crctph_wholefile(char *path);

char lo(unsigned short i);

char hi(unsigned short i);

bool calc_MD5_wholefile(char *filename, unsigned char *digest);

bool calc_MD5_partfile( char *filename, unsigned char *digest, int length );



#endif

