/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "routerdlg.h"
#include "routerdlg.moc"
#include <stdio.h>
#include <stdlib.h>

#include <kapp.h>
#include <kmsgbox.h>

#include <qpushbutton.h>
#include <qkeycode.h>

#include "main.h"


extern TopLevel *toplevel;

#define BTNLENGTH 80
#define BTNHEIGHT 25


// Zeigt eine Liste aller eingetragener Routen an.
ListRoutes::ListRoutes(QWidget *parent) : QDialog(parent, klocale->translate("Route Table..."), TRUE)
{
   resize(350, 200);

   liste = new KTabListBox(this);
   liste->setGeometry(0,0,width(), height()-BTNHEIGHT-10);

   // Spalten: Port, Rufzeichen, Pfad
   liste->setNumCols(3);

   liste->setColumn(0, klocale->translate("Port"), 50, KTabListBox::TextColumn);
   liste->setColumn(1, klocale->translate("Call"), 80, KTabListBox::TextColumn);
   liste->setColumn(2, klocale->translate("Path"), 200, KTabListBox::TextColumn);

   // Zeigt die Routen an
   showRoutes();
   liste->setCurrentItem(0);

   QPushButton *b_yes = new QPushButton(klocale->translate("&Ok"), this);
   b_yes->setGeometry((width()-BTNLENGTH)/2, height() - (BTNHEIGHT+5), BTNLENGTH, BTNHEIGHT);
   connect(b_yes, SIGNAL(released()), this, SLOT(accept()));
   b_yes->setDefault(TRUE);

   QAccel *a = new QAccel( this );
   a->connectItem( a->insertItem(Key_Return), this, SLOT(accept()));
}


void ListRoutes::showThisNode(s_routenode *node, char *path)
{
   s_routenode *samenode;
   char lpath[500],tmp[500];

   samenode = node;
   while (samenode != NULL)
   {
      sprintf(tmp,"%s%c%s%c%s", port, sep, samenode->call, sep, path);
      liste->insertItem(tmp);
      if (path[0] == '\0')
         strcpy(lpath, samenode->call);
      else
         sprintf(lpath, "%s %s", path, samenode->call);
      showThisNode(samenode->leaf, lpath);

      samenode = samenode->same;
   }
}


ListRoutes::~ListRoutes()
{
}


void ListRoutes::keyPressEvent( QKeyEvent *e )
{
   int pos;
   char call[20];


   if (e->key() == Key_Delete)
   {
      if (KMsgBox::yesNo(NULL,
                         klocale->translate("Delete Route?"),
                         klocale->translate("Do you really want to delete the selected route?\nRoutes depending on this route are deleted too!"),
                         0,
                         klocale->translate("&Yes"),
                         klocale->translate("&No")) == 1)
      {
         strcpy(call, liste->text(liste->currentItem(), 1));
         toplevel->router->deleteNode( call );
         liste->clear();
         showRoutes();
         liste->setCurrentItem(0);
         return;
      }
      e->accept();
      return;
   }

   if (e->key() == Key_Down)
   {
      pos = liste->currentItem()+1;
      liste->setCurrentItem( pos );
      e->accept();
      return;
   }

   if (e->key() == Key_Up)
   {
      if ((pos = liste->currentItem()-1) >= 0)
      {
         liste->setCurrentItem( pos );
         if (liste->topItem() > pos)
            liste->setTopItem(pos);
      }
      e->accept();
      return;
   }

   QDialog::keyPressEvent(e);
}


void ListRoutes::showRoutes()
{
   s_routenode *node;
   char path[500];


   // Zeigt die Routen an
   node = toplevel->router->getMajorNode();
   path[0] = '\0';
   port[0] = '\0';
   sep = liste->separator();

   while (node != NULL)
   {
      strcpy(port, node->call);
      showThisNode(node->leaf, path);

      node = node->same;
   }
}


