/*
 * ahuf.cpp
 *
 * Pascal2C-Translation of the #HUF#-Compression by DF8MT (Andy).
 * (*not* by p2c)
 *
 * Translated by Jochen Sarrazin, DG6VJ
 *
 * Original Pascal-Code is Copyright by Andy, DF8MT
 * This C-Translation is Copyright by Jochen Sarrazin, DG6VJ (1999)
 */

#include <stdlib.h>
#include "ahuf.h"


struct TableTyp
{
   unsigned short code;
   unsigned char len;
};

// Huffman-Tabelle
static struct TableTyp HTable[] =
{
   {0xab2c,15},{0xaa84,15},{0x9fc4,15},{0xab3c,15},
   {0xab1c,15},{0xaafc,15},{0xaaec,15},{0xaad4,15},
   {0xaab4,15},{0xf340,10},{0xaaa4,15},{0x7d64,15},
   {0xaadc,15},{0xf400, 7},{0xaa94,15},{0x9ff4,15},
   {0x9fd4,15},{0x7d74,15},{0xab44,15},{0xab34,15},
   {0xab24,15},{0xab14,15},{0xab04,15},{0xaaf4,15},
   {0xaae4,15},{0xab60,14},{0xab0c,15},{0xaacc,15},
   {0xaabc,15},{0xaaac,15},{0xaa9c,15},{0xaa8c,15},
   {0xc000, 3},{0x3a80, 9},{0xabc0,10},{0x0060,11},
   {0x7d40,12},{0xab5c,14},{0x0000,12},{0xab58,14},
   {0x7c00, 9},{0x3c80, 9},{0x7d00,11},{0x0010,12},
   {0x1200, 7},{0x7a00, 7},{0xb800, 6},{0x3200, 7},
   {0x2200, 7},{0xf600, 8},{0x3d00, 8},{0x9e00, 9},
   {0xbd80, 9},{0x7c80, 9},{0x0080, 9},{0xaa00, 9},
   {0xbd00, 9},{0x9f00, 9},{0x0300, 8},{0xab78,13},
   {0xab68,13},{0x3c00, 9},{0x3000, 9},{0x0020,11},
   {0x7d50,12},{0x3800, 7},{0x7800, 7},{0x9c00, 7},
   {0xfe00, 7},{0x2400, 6},{0xbc00, 8},{0x0200, 8},
   {0x0100, 8},{0xf100, 8},{0x0040,11},{0x3100, 8},
   {0xf200, 8},{0x3400, 7},{0x1c00, 7},{0x1e00, 7},
   {0xbe00, 7},{0xaba0,11},{0x3e00, 7},{0x1400, 6},
   {0x3600, 7},{0xf380, 9},{0xf080, 9},{0x2000, 8},
   {0xfc00, 8},{0x9f80,10},{0x9e80, 9},{0xab90,12},
   {0x3b80, 9},{0xab80,12},{0xab54,14},{0x3a50,13},
   {0xab50,14},{0xa000, 5},{0x1800, 6},{0x9800, 6},
   {0x7000, 5},{0x4000, 3},{0x0400, 6},{0xac00, 6},
   {0xf800, 6},{0x6000, 4},{0x3a00,10},{0xfd00, 8},
   {0x2800, 5},{0xb000, 6},{0x8000, 4},{0xb400, 6},
   {0x1000, 7},{0x7d20,12},{0xe000, 5},{0x9000, 5},
   {0xe800, 5},{0x0800, 5},{0xf700, 8},{0xa800, 7},
   {0x7d80, 9},{0xf300,10},{0x7e00, 7},{0xab48,14},
   {0x3a48,13},{0xab4c,14},{0x3a60,12},{0x9ffc,15},
   {0x9fec,15},{0x2100, 8},{0x9fdc,15},{0x9fcc,15},
   {0xf000, 9},{0x7d7c,15},{0x7d6c,15},{0x3a40,14},
   {0xab40,15},{0xab38,15},{0xab30,15},{0xab28,15},
   {0xab20,15},{0xab18,15},{0xab70,13},{0xab10,15},
   {0xab08,15},{0xab00,15},{0xaaf8,15},{0xaaf0,15},
   {0x3b00, 9},{0xaae8,15},{0xaae0,15},{0xaad8,15},
   {0xaad0,15},{0xab64,14},{0x7d30,12},{0xaac8,15},
   {0xaac0,15},{0xaab8,15},{0xaab0,15},{0xaaa8,15},
   {0xaaa0,15},{0xaa98,15},{0xaa90,15},{0xaa88,15},
   {0xaa80,15},{0x9ff8,15},{0x9ff0,15},{0x9fe8,15},
   {0x9fe0,15},{0x9fd8,15},{0x9fd0,15},{0x9fc8,15},
   {0x9fc0,15},{0x7d78,15},{0x7d70,15},{0x3a58,13},
   {0x7d68,15},{0x7d60,15},{0xab46,15},{0xab42,15},
   {0xab3e,15},{0xab3a,15},{0xab36,15},{0xab32,15},
   {0xab2e,15},{0xab2a,15},{0xab26,15},{0xab22,15},
   {0xab1e,15},{0xab1a,15},{0xab16,15},{0xab12,15},
   {0xab0e,15},{0xab0a,15},{0xab06,15},{0xab02,15},
   {0xaafe,15},{0xaafa,15},{0xaaf6,15},{0xaaf2,15},
   {0xaaee,15},{0xaaea,15},{0xaae6,15},{0xaae2,15},
   {0xaade,15},{0xaada,15},{0xaad6,15},{0xaad2,15},
   {0xaace,15},{0xaaca,15},{0xaac6,15},{0xaac2,15},
   {0xaabe,15},{0xaaba,15},{0xaab6,15},{0xaab2,15},
   {0xaaae,15},{0xaaaa,15},{0xaaa6,15},{0xaaa2,15},
   {0xaa9e,15},{0x3a70,12},{0xaa9a,15},{0xaa96,15},
   {0xaa92,15},{0x3080, 9},{0xaa8e,15},{0xaa8a,15},
   {0xaa86,15},{0xaa82,15},{0x9ffe,15},{0x9ffa,15},
   {0x9ff6,15},{0x9ff2,15},{0x9fee,15},{0x9fea,15},
   {0x9fe6,15},{0x9fe2,15},{0x9fde,15},{0x9fda,15},
   {0x9fd6,15},{0x9fd2,15},{0x9fce,15},{0x9fca,15},
   {0x9fc6,15},{0x9fc2,15},{0x7d7e,15},{0x7d7a,15},
   {0x7d76,15},{0x7d72,15},{0x7d6e,15},{0x7d6a,15},
   {0x7d66,15},{0x7d62,15},{0x3a46,15},{0x3a44,15},
   {0xAAC4,15},{0x9FE4,15}
};



void AHUF::UpdateCmComp( ushort w,
                         ushort & t,
                         uchar & bl,
                         long & m,
                         uchar & ml,
                         ushort & Count,
                         char *OBuf)
{
   t = HTable[w].code;
   bl = HTable[w].len;
   m = m << bl;
   m = m | (t >> (16-bl));
   ml += bl;

   while (ml >= 8)
   {
      OBuf[Count] = (uchar)(m >> (ml-8));
      Count++;
      ml -= 8;
   }
}


int AHUF::Compress( uchar & ml,
                    long & m,
                    ushort & Count,
                    char *OBuf,
                    bool flag,
                    char *zeile,
                    int len)
{
   uchar i, bl;
   ushort t;
   uchar Mml;
   long Mm;

   for (i=0; i<sizeof(OBuf); i++)
      OBuf[i] = '\0';

   Count = 0;
   Mml = ml;
   Mm = m;

   for (i=0; i<len; i++)
      UpdateCmComp( (uchar)zeile[i], t, bl,m,ml,Count,OBuf );

   if (flag)
   {
      UpdateCmComp( 256, t, bl,m,ml,Count,OBuf );
      if (ml>0)
      {
         OBuf[Count] = (uchar)(m << (8-ml));
         Count++;
      }
      m = 0;
      ml = 0;
   }

   if (Count > strlen(zeile))
   {
      for (i=0; i<sizeof(OBuf); i++)
         OBuf[i] = '\0';
      Count = 0;
      ml = Mml;
      m = Mm;
      UpdateCmComp( 257, t, bl,m,ml,Count,OBuf );

      if (ml>0)
      {
         OBuf[Count] = (uchar)(m << (8-ml));
         Count++;
      }

      m = 0;
      ml = 0;
      OBuf[Count] = len;
      Count++;

      for (i=0;i<len;i++)
      {
         OBuf[Count] = (uchar)zeile[i];
         Count++;
      }
   }

   return Count;
}



int AHUF::DeCompress( uchar & ml,
                      long & m,
                      ushort & Count,
                      char *OBuf,
                      char *zeile,
                      int len)
{
   uchar i,l;
   ushort w,t;


   for (i=0; i<sizeof(OBuf); i++)
      OBuf[i] = '\0';

   Count = 0;
   for (i=0; i<len; i++)
   {
      if (DNotComp==0)
      {
         m = m << 8;
         ml += 8;
         m = m | (uchar)zeile[i];

         w = 0;
         do
         {
            t = HTable[w].code;
            l = HTable[w].len;

            if (ml >= l)
            {
               if (t == (ushort)(m >> (ml-l) << (16-l)))
               {
                  if (w == 256)
                  {
                     ml = 0;
                     m = 0;
                  }
                  else
                     if (w == 257)
                     {
                        ml = 0;
                        m = 0;
                        DNotComp = 255;
                     }
                     else
                     {
                        OBuf[Count] = (uchar)w;
                        Count++;
                        ml -= l;
                     }
                     w = 0;
               }
               else w++;
            }
            else w++;
         }
         while (w <= 257 && ml >= 3);
      }
      else
         if (DNotComp == 255)
         {
            DNotCAnz = (uchar) zeile[i];
            DNotComp = 1;
         }
         else
            if (DNotComp == 1)
            {
               OBuf[Count] = (uchar)zeile[i];
               Count++;
               DNotCAnz--;
               if (DNotCAnz <= 0) DNotComp = 0;
            }
   }

   return Count;
}


int AHUF::Komprimieren( bool flag, char *OBuf, char *zeile, int len)
{
/*   CCount = 0;
   Cml = 0;
   Cm = 0;*/
   return Compress(Cml, Cm, CCount, OBuf, flag, zeile, len);
}


int AHUF::DeKomprimieren( char *OBuf, char *zeile, int len)
{
/*   DCount = 0;
   Dml = 0;
   Dm = 0;*/
   return DeCompress(Dml, Dm, DCount, OBuf, zeile, len);
}


AHUF::AHUF()
{
   DNotCAnz = 0;
   DNotComp = 0;

   CCount = 0;
   Cml = 0;
   Cm = 0;
   DCount = 0;
   Dml = 0;
   Dm = 0;
}



AHUF::~AHUF()
{
}
