/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __TORUS_H__
#define __TORUS_H__

#include "basics.h"

#define MAX_TORUS_DETAIL  100

// torus render modes
#define TORUS_FIRST_PASS 0x1
#define TORUS_ENVMAP     0x2
#define TORUS_BUMPMAP    0x4

void PreCalcTorusVerts(int n1, int n2, float R1, float R2);
void XformAndLightTorusVerts(int n1, int n2, FxBool calc_specular);
int DrawTorus(int n1, int n2, float R1, float R2, float alpha, float depth, FxU8 mode);

#endif // __TORUS_H__