/* 
 * Mostly a duplicate of test4.  I've added carriage returns to the
 * strings.  Notice the different result from XmStringCreateLtoR and
 * XmStringCreateSimple, particularly the little yen symbol instead of a
 * carriage return.  This apparently is correct behavior, as it's the same
 * under motif and lesstif.
 * 
 */
#include <stdio.h>
#include <Xm/XmAll.h>

int
main(int argc, char **argv)
{
  Widget toplevel, rc, w;
  XtAppContext app;
  Arg	al[10];
  int	ac;
  XmString	xms;

  XtSetLanguageProc(NULL, NULL, NULL);
  toplevel = XtVaAppInitialize(&app, "Label", NULL, 0, &argc, argv, NULL, NULL);

  rc = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, toplevel, NULL);

  ac = 0;
  xms = XmStringCreateLtoR("This came out of XmStringCreateLtoR\n    at initialize", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xms); ac++;
  w = XtCreateManagedWidget("label", xmLabelWidgetClass, rc, al, ac);
  XmStringFree(xms);

  ac = 0;
  xms = XmStringCreateSimple("This came out of XmStringCreateSimple\n    at initialize");
  XtSetArg(al[ac], XmNlabelString, xms); ac++;
  w = XtCreateManagedWidget("label", xmLabelWidgetClass, rc, al, ac);
  XmStringFree(xms);

  ac = 0;
  xms = XmStringCreateLocalized("This came out of XmStringCreateLocalized\n    at initialize");
  XtSetArg(al[ac], XmNlabelString, xms); ac++;
  w = XtCreateManagedWidget("label", xmLabelWidgetClass, rc, al, ac);
  XmStringFree(xms);

  ac = 0;
  w = XtCreateManagedWidget("label", xmLabelWidgetClass, rc, al, ac);
  xms = XmStringCreateLtoR("This came out of XmStringCreateLtoR\n    with setvalues", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xms); ac++;
  XtSetValues(w, al, ac);
  XmStringFree(xms);

  ac = 0;
  w = XtCreateManagedWidget("label", xmLabelWidgetClass, rc, al, ac);
  xms = XmStringCreateSimple("This came out of XmStringCreateSimple\n    with setvalues");
  XtSetArg(al[ac], XmNlabelString, xms); ac++;
  XtSetValues(w, al, ac);
  XmStringFree(xms);

  XtRealizeWidget(toplevel);
  

{
static XtWidgetGeometry Expected[] = {
   CWWidth | CWHeight            ,    0,    0,  358,  129, 0,0,0, /* rc */
   CWWidth | CWHeight | CWX | CWY,    3,    3,  352,   30, 0,0,0, /* label */
   CWWidth | CWHeight | CWX | CWY,    3,   36,  352,   17, 0,0,0, /* label */
   CWWidth | CWHeight | CWX | CWY,    3,   56,  352,   17, 0,0,0, /* label */
   CWWidth | CWHeight | CWX | CWY,    3,   76,  352,   30, 0,0,0, /* label */
   CWWidth | CWHeight | CWX | CWY,    3,  109,  352,   17, 0,0,0, /* label */
};
/* toplevel should be replaced with to correct applicationShell */
PrintDetails(toplevel, Expected);
}
LessTifTestMainLoop(toplevel);
 
  /*
  XtAppMainLoop(app);
  */

  exit(0);
}
