/* vi:set ts=8 sts=0 sw=8:
 * $Id: menu.h,v 1.4 1999/01/18 20:02:31 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MENU_H__
#define __MENU_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include <glib.h>
#include "win.h"

typedef struct {
	char *name;
	GtkMenuCallback cb;
} qmenu_t;


extern void menu_main_init(win_t *w);
#ifdef APP_GNP
extern void quickmenu_init(win_t *w);
#endif
extern gboolean quickmenu_show(GtkWidget *wgt, GdkEvent *ev);
extern void menu_recent_doc_add(GtkMenuCallback cbf, gpointer cbd);
extern void menu_recent_doc_remove(gpointer dnnp);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
