/* vi:set ts=8 sts=0 sw=8:
 * $Id: htmltags.h,v 1.2 1999/01/14 19:47:31 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __HTMLTAGS_H__
#define __HTMLTAGS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include "win.h"

typedef enum {
	HtmlBig,
	HtmlBold,
	HtmlCent,
	HtmlCmnt,
	HtmlEmph,
	HtmlH1,
	HtmlH2,
	HtmlH3,
	HtmlH4,
	HtmlH5,
	HtmlH6,
	HtmlImg,
	HtmlItal,
	HtmlLeft,
	HtmlLbrk,
	HtmlLink,
	HtmlLitm,
	HtmlOrdr,
	HtmlPara,
	HtmlRght,
	HtmlSep,
	HtmlSmll,
	HtmlStrk,
	HtmlStrg,
	HtmlSub,
	HtmlSup,
	HtmlTarg,
	HtmlTtl,
	HtmlTty,
	HtmlUlne,
	HtmlUord,
	HtmlNONE
} html_action_t;

extern void html_tb_create(win_t *w, GtkWidget *parent, GtkWidget **tb,
			   GtkWidget **tb_h);

#ifdef GTK_HAVE_FEATURES_1_1_0
extern void html_menu_cb(GtkWidget *wgt, gpointer cbdata, guint cbaction);
#else
extern void html_title_cb(GtkWidget *widget, gpointer cbdata);
extern void html_comment_cb(GtkWidget *widget, gpointer cbdata);
extern void html_link_cb(GtkWidget *widget, gpointer cbdata);
extern void html_target_cb(GtkWidget *widget, gpointer cbdata);
extern void html_image_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h1_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h2_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h3_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h4_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h5_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h6_cb(GtkWidget *widget, gpointer cbdata);
extern void html_center_cb(GtkWidget *widget, gpointer cbdata);
extern void html_right_cb(GtkWidget *widget, gpointer cbdata);
extern void html_paragraph_cb(GtkWidget *widget, gpointer cbdata);
extern void html_linebreak_cb(GtkWidget *widget, gpointer cbdata);
extern void html_separator_cb(GtkWidget *widget, gpointer cbdata);
extern void html_bold_cb(GtkWidget *widget, gpointer cbdata);
extern void html_italic(GtkWidget *widget, gpointer cbdata);
extern void html_underline_cb(GtkWidget *widget, gpointer cbdata);
extern void html_typewriter_cb(GtkWidget *widget, gpointer cbdata);
extern void html_strikeout_cb(GtkWidget *widget, gpointer cbdata);
extern void html_emphasis_cb(GtkWidget *widget, gpointer cbdata);
extern void html_strong_cb(GtkWidget *widget, gpointer cbdata);
extern void html_subscript_cb(GtkWidget *widget, gpointer cbdata);
extern void html_superscript_cb(GtkWidget *widget, gpointer cbdata);
extern void html_big_cb(GtkWidget *widget, gpointer cbdata);
extern void html_small_cb(GtkWidget *widget, gpointer cbdata);
extern void html_ordered_cb(GtkWidget *widget, gpointer cbdata);
extern void html_unordered_cb(GtkWidget *widget, gpointer cbdata);
extern void html_listitem_cb(GtkWidget *widget, gpointer cbdata);
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __HTMLTAGS_H__ */
