/*****************************************************************************/
/*  rfc959.h - Header file for the gnome-ftp library                         */
/*  Copyright (C) 1999 Brian Masney <masneyb@seul.org>                       */
/*                                                                           */
/*  This library is free software; you can redistribute it and/or            */
/*  modify it under the terms of the GNU Library General Public              */
/*  License as published by the Free Software Foundation; either             */
/*  version 2 of the License, or (at your option) any later version.         */
/*                                                                           */
/*  This library is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        */
/*  Library General Public License for more details.                         */
/*                                                                           */
/*  You should have received a copy of the GNU Library General Public        */
/*  License along with this library; if not, write to the Free Software      */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __GNOME_FTP_H
#define __GNOME_FTP_H

#define _REENTRANT
#include <glib.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <time.h>

#if defined(HAVE_GETTEXT)
 #if !defined(_)
  #define _(String) gettext (String)
 #endif
 #include <libintl.h>
#else if !defined(_)
 #define _(String) String
#endif
   
typedef enum gftp_data_type_tag {
   gftp_type_binary,
   gftp_type_ascii
} gftp_data_type;

typedef enum gftp_transfer_type_tag {
   gftp_transfer_passive,
   gftp_transfer_active
} gftp_transfer_type;

typedef enum gftp_logging_type_tag {
   gftp_logging_none,
   gftp_logging_send,
   gftp_logging_recv,
   gftp_logging_error,
   gftp_logging_misc
} gftp_logging_type;

typedef struct gftp_file_tag {
   char *file;
   char *user;
   char *group;
   char *attribs;
   time_t datetime;
   unsigned long size;
} gftp_file;

typedef struct gftp_readline_buffer_tag {
   char *buffer;
   char *pos;
} gftp_readline_buffer;

typedef void (*gftp_logging_func)(gftp_logging_type level, void *ptr, const char *string, ...);

struct _gftp_request {
   char *hostname;
   char *username;
   char *password;
   char *account;
   char *directory;
   unsigned int port;

   char *proxy_config;   
   char *proxy_hostname;
   char *proxy_username;
   char *proxy_password;
   char *proxy_account;
   unsigned int proxy_port;

   gftp_readline_buffer command_buffer;
   gftp_readline_buffer data_buffer;
   char *last_ftp_response;
   char *last_dir_entry;
   int sockfd;
   int datafd;
   gftp_data_type data_type;
   gftp_transfer_type transfer_type;
   int logging : 1;
   
   gftp_logging_func logging_function;
   void *user_data;
};

typedef struct _gftp_request gftp_request;

#define GFTP_CONNECTED(request)		(request->sockfd >= 0)
#define GFTP_GET_HOSTNAME(request)	(request->hostname)
#define GFTP_GET_USERNAME(request)	(request->username)
#define GFTP_GET_PASSWORD(request)	(request->password)
#define GFTP_GET_ACCOUNT(request)	(request->account)
#define GFTP_GET_DIRECTORY(request)	(request->directory)
#define GFTP_GET_PORT(request)		(request->port)
#define GFTP_GET_PROXY_CONFIG(request)	(reuqest->proxy_config)
#define GFTP_GET_PROXY_HOSTNAME(request)(request->proxy_hostname)
#define GFTP_GET_PROXY_USERNAME(request)(request->proxy_username)
#define GFTP_GET_PROXY_PASSWORD(request)(request->proxy_password)
#define GFTP_GET_PROXY_PORT(request)	(request->proxy_port)
#define GFTP_GET_LAST_RESPONSE(request)	(request->last_ftp_response)
#define GFTP_GET_LAST_DIRENT(request)	(request->last_dir_entry)
#define GFTP_GET_CONTROL_FD(request)	(request->sockfd)
#define GFTP_GET_DATA_FD(request)	(request->datafd)
#define GFTP_GET_DATA_TYPE(request)	(request->data_type)
#define GFTP_GET_TRANSFER_TYPE(request)	(request->transfer_type)
#define GFTP_SET_TRANSFER_TYPE(request,val) (request->transfer_type = (val))
#define GFTP_GET_LOGGING(request)	(request->logging)
#define GFTP_SET_LOGGING(request, val)	(request->logging = (val))

gftp_request *gftp_request_new (void);
void gftp_request_destroy (gftp_request *request);
void gftp_file_destroy (gftp_file *file);
void gftp_logging (gftp_request *request, int logging, void (*logging_function)(gftp_logging_type level, void *ptr, const char *string, ...), void *ptr);
int gftp_connect (gftp_request *request);
void gftp_disconnect (gftp_request *request);
int gftp_data_connection_new (gftp_request *request);
int gftp_init_fxp_transfer (gftp_request *pasv_request, gftp_request *port_request);
int gftp_accept_active_connection (gftp_request *request);
int gftp_get_file (gftp_request *request, const char *filename, long startsize);
int gftp_put_file (gftp_request *request, const char *filename, long startsize);
int gftp_list_files (gftp_request *request);
int gftp_parse_url (gftp_request *request, const char *url);
int gftp_parse_ls(const char *lsoutput, gftp_file *fle);
int gftp_get_next_file (gftp_request *request, gftp_file *fle);
int gftp_end_transfer (gftp_request *request);
int gftp_send_command (gftp_request *request, const char *command);
char *gftp_read_line (int sockfd, gftp_readline_buffer *buffer);
int gftp_read_response (gftp_request *request);
int gftp_set_data_type (gftp_request *request, gftp_data_type type);
void gftp_set_hostname (gftp_request *request, const char *hostname);
void gftp_set_username (gftp_request *request, const char *username);
void gftp_set_password (gftp_request *request, const char *password);
void gftp_set_account (gftp_request *request, const char *account);
int gftp_set_directory (gftp_request *request, const char *directory);
void gftp_set_port (gftp_request *request, unsigned int port);
void gftp_set_proxy_hostname (gftp_request *request, const char *hostname);
void gftp_set_proxy_username (gftp_request *request, const char *username);
void gftp_set_proxy_password (gftp_request *request, const char *password);
void gftp_set_proxy_account (gftp_request *request, const char *account);
void gftp_set_proxy_port (gftp_request *request, unsigned int port);
int gftp_remove_directory (gftp_request *request, const char *directory);
int gftp_remove_file (gftp_request *request, const char *file);
int gftp_make_directory (gftp_request *request, const char *directory);
int gftp_rename_file (gftp_request *request, const char *oldname, const char *newname);
int gftp_chmod (gftp_request *request, const char *file, int mode);
char gftp_site_cmd (gftp_request *request, const char *command);
unsigned long gftp_get_file_size (gftp_request *request, const char *filename);
void gftp_set_proxy_config (gftp_request *request, const char *proxy_config);

#endif
