/*****************************************************************************/
/*  delete_dialog.c - the delete dialog                                      */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

static void askdel (void);
static void yesCB (GtkWidget *widget, gpointer data);
static void noCB (GtkWidget *widget, gpointer data);
static void yesallCB (GtkWidget *widget, gpointer data);

static struct ftp_window_data *wdata;
static int doall;
static struct ftp_file_data *curfle;

void delete_dialog (gpointer data) {
   wdata = (struct ftp_window_data *) data;
   if (!check_status (_("Delete"), wdata, 0, 1, 1)) return;

   if ((curfle = get_next_selected_filename (wdata->hdata->files)) == NULL) {
      ftp_log (gftp_logging_misc, NULL, _("Internal gFTP Error: Could not find a selected file. This is probably a bug. Please email masneyb@seul.org about it\n"));
      return;
   }
   if (confirm_delete) {
      doall = 0;
      askdel ();
   }
   else {
      doall = 1;
      yesCB (NULL, NULL);
   }
}
/*****************************************************************************/
static void askdel (void) {
   char *tempstr;

   tempstr = g_strdup_printf (_("Are you sure you want to delete %s?"), curfle->file);
   MakeYesNoDialog (_("Delete Files/Directories"), tempstr, 1, 4,
   	_("Yes"), yesCB, NULL,
   	_("No"), noCB, NULL,
   	_("Yes to All"), yesallCB, NULL,
   	_("No to All"), NULL, NULL);
   g_free (tempstr);
}
/*****************************************************************************/
static void yesCB (GtkWidget *widget, gpointer data) {
   struct ftp_file_data *tempfle;
   int success, num, reload;
   char description[MAXSTR];
   
   reload = 0;
   while (curfle != NULL) {
      if (wdata->local == 1) {
         if (curfle->attribs[0] == 'd') success = rmdir (curfle->file) == 0;
         else success = unlink (curfle->file) == 0;
         if (!success) {
            if (curfle->attribs[0] == 'd') {
               ftp_log (gftp_logging_error, NULL, _("Error: Could not remove directory %s: %s\n"), curfle->file, g_strerror (errno));
            }
            else {
               ftp_log (gftp_logging_error, NULL, _("Error: Could not remove file %s: %s\n"), curfle->file, g_strerror (errno));
            }
         }
         else {
            ftp_log (gftp_logging_misc, NULL, _("Successfully removed %s\n"), curfle->file);
         }
      }
      else {
         if (wdata->local == 2) {
            reload = 1;
            if (!ftp_connect (wdata->hdata, 0)) success = 0;
            else success = 1;
            wdata->hdata->getdir = 1;
         }
         if (curfle->attribs[0] == 'd') success = gftp_remove_directory (wdata->hdata->ftpdata, curfle->file) == 0;
         else success = gftp_remove_file (wdata->hdata->ftpdata, curfle->file) == 0;
      }
      if (success) {
         g_snprintf (description, sizeof (description), "%s://%s:%s@%s:%d%s",
         	wdata->hdata->protocol == ftp ? "ftp" : "http",
         	GFTP_GET_USERNAME (wdata->hdata->ftpdata), GFTP_GET_PASSWORD (wdata->hdata->ftpdata),
         	GFTP_GET_HOSTNAME (wdata->hdata->ftpdata), GFTP_GET_PORT (wdata->hdata->ftpdata),
         	GFTP_GET_DIRECTORY (wdata->hdata->ftpdata));
         remove_double_slashes (description+6);
         delete_cache_entry (description);
         
         num = 0;
         tempfle = wdata->hdata->files;
         if (tempfle == curfle) {
            gtk_clist_remove (GTK_CLIST (wdata->listbox), 0);
            wdata->hdata->files = wdata->hdata->files->next;
            free_fdata (curfle);
            curfle = wdata->hdata->files;
         }
         else {
            if (wdata->hdata->files->flags & FILE_SHOWN) num++;
            while (tempfle->next != curfle) {
               if (tempfle->flags & FILE_SHOWN) num++;
               tempfle = tempfle->next;
            }
            gtk_clist_remove (GTK_CLIST (wdata->listbox), num);
            tempfle->next = curfle->next;
            free_fdata (curfle);
            curfle = tempfle->next;
         }
         wdata->totalitems--;
      }
      else {
         curfle = curfle->next;
      }
      curfle = get_next_selected_filename (curfle);
      if (curfle != NULL && !doall) {
         askdel ();
         return;
      }
   }
   if (reload) refresh (wdata);
}
/*****************************************************************************/
static void noCB(GtkWidget *widget, gpointer data) {
   curfle = get_next_selected_filename (curfle->next);
   if (curfle != NULL) askdel ();
}
/*****************************************************************************/
static void yesallCB (GtkWidget *widget, gpointer data) {
   doall = 1;
   yesCB (widget, data);
}
/*****************************************************************************/
