/*****************************************************************************/
/*  cache.c - contains the cache routines                                    */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

FILE *new_cache_entry (char *description) {
   char cachedir[MAXSTR], tempstr[MAXSTR], cachefile[MAXSTR];
   int found = 0, len;
   char *pos;
   FILE *fd;
 
   expand_path (BASE_CONF_DIR "/cache", cachedir, sizeof (cachedir));
   if (access(cachedir, F_OK) == -1) mkdir (cachedir, 0x1C0);
   else chmod (cachedir, 0x1C0);
   
   g_snprintf (tempstr, sizeof (tempstr), "%s/index.db", cachedir);
   if ((fd = fopen (tempstr, "a+")) == NULL) return (NULL);
   fseek (fd, 0, SEEK_SET);

   while (fgets (tempstr, sizeof (tempstr), fd)) {
      if (!((pos = strchr (tempstr, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      len = (pos - tempstr > strlen (description)) ? pos - tempstr : strlen (description);
      if (strncmp (tempstr, description, len) == 0) {
         pos++;
         strncpy (cachefile, pos, sizeof (cachefile));
         cachefile[strlen (cachefile) - 1] = '\0'; /* Remove \n */
         found = 1;
         break;
      }
   }
   if (!found) {         
      srand (time (NULL));
      do {
         g_snprintf (cachefile, sizeof (cachefile), "cache%ld", 1 + (long) (99999999.0 * rand () / (RAND_MAX + 1.0)));
         g_snprintf (tempstr, sizeof (tempstr), "%s/%s", cachedir, cachefile);
      } while (access (tempstr, F_OK) != -1);

      g_snprintf (tempstr, sizeof (tempstr), "%s\t%s\n", description, cachefile);
      fseek (fd, 0, SEEK_END);
      fwrite (tempstr, 1, strlen (tempstr), fd);
   }
   fclose (fd);
   
   g_snprintf (tempstr, sizeof (tempstr), "%s/%s", cachedir, cachefile);
   if ((fd = fopen(tempstr, "w+")) == NULL) return (NULL);

   return (fd);
}
/*****************************************************************************/
FILE *find_cache_entry (char *description) {
   char cachedir[MAXSTR], tempstr[MAXSTR], cachefile[MAXSTR], *pos;
   FILE *indexfd, *cachefd;
   int len;

   expand_path (BASE_CONF_DIR "/cache", cachedir, sizeof (cachedir));
   if (access (cachedir, F_OK) == -1) mkdir (cachedir, 0x1C0);
   
   g_snprintf (tempstr, sizeof (tempstr), "%s/index.db", cachedir);
   tempstr[sizeof (tempstr) - 1] = '\0';
   if ((indexfd = fopen(tempstr, "r")) == NULL) return (NULL);

   while (fgets (tempstr, sizeof (tempstr), indexfd)) {
      if (!((pos = strchr (tempstr, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      len = (pos - tempstr > strlen(description)) ? pos - tempstr : strlen (description);
      if (strncmp (tempstr, description, len) == 0) {
         pos++;
         strncpy (cachefile, pos, sizeof (cachefile));
         cachefile[strlen (cachefile) - 1] = '\0'; /* Remove \n */
         g_snprintf (tempstr, sizeof (tempstr), "%s/%s", cachedir, cachefile);
         if ((cachefd = fopen(tempstr, "r")) == NULL) return (NULL);
         fclose (indexfd);
         return (cachefd);
      }
   }
   fclose (indexfd);
   return (NULL);
}
/*****************************************************************************/
void clear_cache_files (void) {
   char cachedir[MAXSTR], tempstr[MAXSTR], cachefile[MAXSTR], *pos;
   FILE *indexfd;

   expand_path (BASE_CONF_DIR "/cache", cachedir, sizeof(cachedir));
   if (access (cachedir, F_OK) == -1) mkdir(cachedir, 0x1C0);
   
   g_snprintf (tempstr, sizeof (tempstr), "%s/index.db", cachedir);
   if ((indexfd = fopen (tempstr, "r")) == NULL) return;

   while (fgets (tempstr, sizeof (tempstr), indexfd)) {
      if (!((pos = strchr (tempstr, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      pos++;
      strncpy (cachefile, pos, sizeof (cachefile));
      cachefile[strlen (cachefile) - 1] = '\0'; /* Remove \n */
      g_snprintf (tempstr, sizeof (tempstr), "%s/%s", cachedir, cachefile);
      tempstr[sizeof (tempstr) - 1] = '\0';
      unlink (tempstr);
   }
   fclose (indexfd);
   g_snprintf (tempstr, sizeof (tempstr), "%s/index.db", cachedir);
   tempstr[sizeof (tempstr) - 1] = '\0';
   unlink (tempstr);
}
/*****************************************************************************/
void delete_cache_entry (char *description) {
   char cachedir[MAXSTR], tempstr[MAXSTR], *pos, *oldfile, *newfile;
   FILE *indexfd, *newfd;

   expand_path (BASE_CONF_DIR "/cache", cachedir, sizeof (cachedir));
   if (access (cachedir, F_OK) == -1) return;
   oldfile = g_strconcat (cachedir, "/index.db", NULL);
   if ((indexfd = fopen(oldfile, "r")) == NULL) {
      g_free (oldfile);
      return;
   }
   newfile = g_strconcat (cachedir, "/index.db.new", NULL);
   if ((newfd = fopen (newfile, "w")) == NULL) {
      g_free (oldfile);
      g_free (newfile);
      return;
   }
   while (fgets (tempstr, sizeof (tempstr), indexfd)) {
      if (!((pos = strchr (tempstr, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      *pos = '\0';
      if (strcmp (tempstr, description) == 0) {
         g_snprintf (tempstr, sizeof (tempstr), "%s/%s", cachedir, pos + 1);
         tempstr[sizeof (tempstr) - 1] = '\0';
         unlink (tempstr);
      }
      else {
         *pos = '\t';
         fwrite (tempstr, 1, strlen (tempstr), newfd);
      }
   }
   fclose (indexfd);
   fclose (newfd);
   
   unlink (oldfile);
   rename (newfile, oldfile);
   
   g_free (oldfile);
   g_free (newfile);
}
/*****************************************************************************/
