#include "E.h"

void
IconifyEwin(EWin * ewin)
{
  static int          call_depth = 0;

  if (!ewin)
    EDBUG_RETURN_;
  if (ewin->client.need_input)
    {
      if ((ewin->skiptask) || (ewin->skipwinlist))
	EDBUG_RETURN_;
    }
  call_depth++;
  if (call_depth > 256)
    return;
  if (!ewin->iconified)
    {
      HideEwin(ewin);
      ICCCM_Iconify(ewin);
      MakeIcon(ewin);
    }
  if (ewin->has_transients)
    {
      EWin              **lst;
      int                 i, num;

      lst = ListTransientsFor(ewin->client.win, &num);
      if (lst)
	{
	  for (i = 0; i < num; i++)
	    IconifyEwin(lst[i]);
	  Efree(lst);
	}
    }
  call_depth--;
}

void
DeIconifyEwin(EWin * ewin)
{
  static int          call_depth = 0;

  call_depth++;
  if (call_depth > 256)
    return;
  if (ewin->iconified)
    {
      RemoveMiniIcon(ewin);
      if (!ewin->sticky)
	{
	  ewin->desktop = desks.current;
	  MoveEwinToArea(ewin,
			 desks.desk[desks.current].current_area_x,
			 desks.desk[desks.current].current_area_y);
	  ConformEwinToDesktop(ewin);
	}
      RaiseEwin(ewin);
      ShowEwin(ewin);
      ICCCM_DeIconify(ewin);
      mode.destroy = 1;
    }
  if (ewin->has_transients)
    {
      EWin              **lst;
      int                 i, num;

      lst = ListTransientsFor(ewin->client.win, &num);
      if (lst)
	{
	  for (i = 0; i < num; i++)
	    DeIconifyEwin(lst[i]);
	  Efree(lst);
	}
    }
  call_depth--;
}

void
MakeIcon(EWin * ewin)
{
  ActionClass        *ac;
  ImageClass         *ic;
  Action             *a;
  Button             *bt;
  char                s[25];
  char                can_embed_stuff = 0;

  sprintf(s, "%i", (int)ewin->client.win);
  ic = NULL;
  ac = FindItem("ICON", ewin->client.win, LIST_FINDBY_BOTH, LIST_TYPE_ACLASS);
  if (!ac)
    {
      ac = CreateAclass(s);
      a = CreateAction(1, 1, 0, 1, 0, 1, 0);
      AddItem(ac, "ICON", ewin->client.win, LIST_TYPE_ACLASS);
      AddAction(ac, a);
      AddToAction(a, ACTION_ICONIFY, duplicate(s));
      if (ewin->client.icon_name)
	ac->tooltipstring = duplicate(ewin->client.icon_name);
      else
	ac->tooltipstring = duplicate(ewin->client.title);
    }
  ic = MatchEwinByFunction(ewin, (void *(*)(EWin *, WindowMatch *))(MatchEwinIcon));

  if (!ic)
    {
      ic = FindItem("DEFAULT_ICON_BUTTON", 0, LIST_FINDBY_NAME,
		    LIST_TYPE_ICLASS);
      can_embed_stuff = 1;
    }
  bt = CreateButton(s, ic, ac, 0, 0, 10, 99999, 10, 99999, 0,
		    1023, 0, 0, 0, 1023, 0, 0, 0, 0, 1, 0, 1);

  if (mode.showicons)
    ShowButton(bt);
  FindEmptySpotForButton(bt, "ICON", mode.primaryicondir);
  AddItem(bt, "ICON", ewin->client.win, LIST_TYPE_BUTTON);

  if (can_embed_stuff)
    {
      if (ewin->client.icon_win)
	{
	  EmbedWindowIntoButton(bt, ewin->client.icon_win);
	  XMapWindow(disp, ewin->client.icon_win);
	}
      else if (ewin->client.icon_pmap)
	{
	  Window              PixmapWindow;
	  unsigned int        w, h;
	  int                 d;

	  GetWinWH(ewin->client.icon_pmap, &w, &h);
	  d = GetWinDepth(ewin->client.icon_pmap);
	  PixmapWindow = ECreateWindow(root.win, -100, -100, w, h, 0);

	  if (d == id->x.depth)
	    XSetWindowBackgroundPixmap(disp, PixmapWindow,
				       ewin->client.icon_pmap);
	  else
	    {
	      ImlibImage         *im;
	      Pixmap              pmap;

	      im = Imlib_create_image_from_drawable(id, ewin->client.icon_pmap,
						    0, 0, 0, w, h);
	      Imlib_render(id, im, w, h);
	      pmap = Imlib_move_image(id, im);
	      XSetWindowBackgroundPixmap(disp, PixmapWindow, pmap);
	      Imlib_free_pixmap(id, pmap);
	      Imlib_kill_image(id, im);
	    }
	  XShapeCombineMask(disp, PixmapWindow, ShapeBounding, 0, 0,
			    ewin->client.icon_mask, ShapeSet);
	  EmbedWindowIntoButton(bt, PixmapWindow);
	  XMapWindow(disp, PixmapWindow);
	  bt->destroy_inside_win = 1;
	}
    }
}

void
RemoveMiniIcon(EWin * ewin)
{
  Button             *bt = 0;
  ActionClass        *ac = 0;

  bt = FindItem("ICON", ewin->client.win, LIST_FINDBY_BOTH, LIST_TYPE_BUTTON);
  if (bt)
    {
      if (bt->inside_win)
	{
	  if (!bt->destroy_inside_win)
	    {
	      XReparentWindow(disp, bt->inside_win, root.win, 0, 0);
	      XUnmapWindow(disp, bt->inside_win);
	    }
	  bt->inside_win = 0;
	}
      DestroyButton(RemoveItem("ICON", ewin->client.win,
			       LIST_FINDBY_BOTH, LIST_TYPE_BUTTON));
    }
  ac = FindItem("ICON", ewin->client.win, LIST_FINDBY_ID,
		LIST_TYPE_ACLASS);
  if (ac)
    RemoveActionClass(RemoveItem("ICON", ewin->client.win,
				 LIST_FINDBY_ID, LIST_TYPE_ACLASS));
}

void
HideIcons(void)
{
  Button             *bt = 0;
  EWin              **lst;
  int                 i, num;

  mode.showicons = 0;
  lst = (EWin **) ListItemType(&num, LIST_TYPE_EWIN);
  for (i = 0; i < num; i++)
    {
      bt = FindItem("ICON", lst[i]->client.win, LIST_FINDBY_BOTH, LIST_TYPE_BUTTON);
      if (bt)
	HideButton(bt);
    }
  if (lst)
    Efree(lst);
}

void
ShowIcons(void)
{
  Button             *bt = 0;
  EWin              **lst;
  int                 i, num;

  mode.showicons = 1;
  lst = (EWin **) ListItemType(&num, LIST_TYPE_EWIN);
  for (i = 0; i < num; i++)
    {
      bt = FindItem("ICON", lst[i]->client.win, LIST_FINDBY_BOTH, LIST_TYPE_BUTTON);
      if (bt)
	ShowButton(bt);
    }
  if (lst)
    Efree(lst);
}

void
HandlePager(void)
{
  Window             *w1, *w2;
  int                 size;
  static Atom         pga = 0;

  if (!pga)
    pga = XInternAtom(disp, "_GNOME_PAGER_ACTIVE", False);
  external_pager_window = 0;
  w1 = (Window *) AtomGet(root.win, pga, XA_WINDOW, &size);
  if (w1)
    {
      if (WinExists(*w1))
	{
	  w2 = (Window *) AtomGet(*w1, pga, XA_WINDOW, &size);
	  if (w2)
	    {
	      XSelectInput(disp, *w2, StructureNotifyMask |
			   SubstructureNotifyMask);
	      external_pager_window = *w2;
	      HideIcons();
	      Efree(w2);
	    }
	}
      Efree(w1);
    }
}
