/*
 * common.h : Utility for the Linux Multiple Devices driver
 *            Copyright (C) 1997 Ingo Molnar, Miguel de Icaza, Gadi Oxman
 *
 * Common includes and declarations.
 *
 * This source is covered by the GNU GPL, the same as all Linux kernel
 * sources.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>

#include <linux/md.h>
#include <linux/fs.h>
#include <linux/kdev_t.h>

#define DEBUG				(0)
#define EXIT_USAGE			(EXIT_FAILURE)
#define MAX_LINE_LENGTH			(100)
#define MKRAID_MAJOR_VERSION		(0)
#define MKRAID_MINOR_VERSION		(36)
#define MKRAID_PATCHLEVEL_VERSION	(4)
#define ZERO_BUFFER_SIZE		(64)	/* 64kB */
#define MD_BLK_SIZ			(0x400)

#define MIN(a,b)	((a) < (b) ? (a) : (b))

typedef struct md_cfg_entry {
	md_superblock_t sb, sb_old;
	__u32 sb_block_offset[MD_SB_DISKS];
	char *device_name[MD_SB_DISKS];
	int sb_present[MD_SB_DISKS];
	char *md_name;
	struct md_cfg_entry *next;
} md_cfg_entry_t;
