/* Interface file for mouse driver */
/* Andrew Haylett */
/* [# Edit 6, Date 30-Jul-94, Module mouse.h #] */

#ifndef MOUSE_H
#define MOUSE_H

#define MS_BUTLEFT	0x04
#define MS_BUTMIDDLE	0x02
#define MS_BUTRIGHT	0x01

typedef enum {
    P_MS = 0,
    P_SUN = 1,
    P_MSC = 2,
    P_MM = 3,
    P_LOGI = 4,
    P_BM = 5,
    P_PS2 = 6
} mouse_type;

#define NR_TYPES 7	/* keep in step with mouse_type! */

struct ms_event {
    enum { MS_NONE = 0, MS_BUTUP = 1, MS_BUTDOWN = 2, MS_MOVE = 3, MS_DRAG = 4}
	ev_code;
    unsigned char ev_butstate;
    int ev_x, ev_y;
    int ev_dx, ev_dy;
};

int ms_init(const int accel, const int baud, const int delta,
	    const char *dev, const unsigned int toggle, const int sample,
	    const mouse_type type, const int slack, const int maxx,
	    const int maxy);

int get_ms_event(struct ms_event *ev);

#endif /* MOUSE_H */
