/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.net.URL;
import java.util.Vector;
import netscape.applet.AppletClassLoader;
import netscape.applet.AppletThreadList;
import netscape.applet.MozillaAppletContext;
import netscape.applet.TaskID;
import netscape.applet.TaskOwner;
import netscape.applet.TaskThreadGroup;
import netscape.application.Application;
import netscape.application.CommandEvent;
import netscape.application.Event;
import netscape.application.EventLoop;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;

final class Task
implements Runnable {
    static Hashtable taskByName;
    String _taskName;
    TaskThreadGroup group;
    Thread thread;
    URL _codebaseURL;
    URL _archiveURL;
    AppletClassLoader _classLoader;
    String _appClassName;
    Application _application;
    EventLoop eventLoop;
    TaskOwner _taskOwner;
    Vector initialEventQueue = new Vector();
    boolean registered;
    boolean running;
    boolean dead;
    boolean runLocked;

    public static void destroyAll() {
        Enumeration enumeration = Task.getTasks();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            task.stop();
        }
    }

    public static Task currentTask() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup != null) {
            if (threadGroup instanceof TaskThreadGroup) {
                return ((TaskThreadGroup)threadGroup).task();
            }
            threadGroup = threadGroup.getParent();
        }
        return null;
    }

    public static synchronized Task taskNamed(URL uRL, String string) {
        if (taskByName == null) {
            return null;
        }
        return (Task)taskByName.get(new TaskID(uRL, string));
    }

    static synchronized void registerTask(Task task) {
        if (taskByName == null) {
            taskByName = new Hashtable();
        }
        if (task.registered) {
            return;
        }
        taskByName.put(new TaskID(task.codebaseURL(), task.taskName()), task);
        task.registered = true;
    }

    static synchronized void unregisterTask(Task task) {
        if (taskByName == null || !task.registered) {
            return;
        }
        taskByName.remove(new TaskID(task.codebaseURL(), task.taskName()));
        task.registered = false;
    }

    public static synchronized Enumeration getTasks() {
        if (taskByName == null) {
            taskByName = new Hashtable();
        }
        return ((Hashtable)taskByName.clone()).elements();
    }

    public Task(String string, String string2, URL uRL, URL uRL2, TaskOwner taskOwner) {
        this._taskName = string;
        this._appClassName = string2;
        this._codebaseURL = uRL;
        this._archiveURL = uRL2;
        this._taskOwner = taskOwner;
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        SecurityManager.enablePrivilege("UniversalThreadGroupAccess");
        this.group = new TaskThreadGroup(string, this);
        this.thread = new Thread((ThreadGroup)this.group, this);
        SecurityManager.revertPrivilege();
        Task.registerTask(this);
    }

    public String taskName() {
        return this._taskName;
    }

    public URL codebaseURL() {
        return this._codebaseURL;
    }

    public URL archiveURL() {
        return this._archiveURL;
    }

    public TaskOwner taskOwner() {
        return this._taskOwner;
    }

    public ThreadGroup threadGroup() {
        return this.group;
    }

    public Application application() {
        return this._application;
    }

    public ClassLoader classLoader() {
        if (this._classLoader != null) {
            return this._classLoader;
        }
        if (this._codebaseURL == null) {
            return null;
        }
        URL[] uRLArray = new URL[]{this._archiveURL};
        this._classLoader = new AppletClassLoader(null, this._codebaseURL, uRLArray);
        return this._classLoader;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized boolean isDead() {
        return this.dead;
    }

    public void run() {
        Task task;
        Task task2 = this;
        synchronized (task2) {
            if (this.runLocked) {
                throw new InconsistencyException("Do not run a Task more than once.");
            }
            this.runLocked = true;
        }
        try {
            this.prepareToRun();
            task = this;
            synchronized (task) {
                this.running = true;
                this.moveEvents();
                this.notifyAll();
            }
            this.didStartRunning();
            this._application.run();
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            Task task3 = this;
            synchronized (task3) {
                this.running = false;
                this.dead = true;
                this.notifyAll();
            }
            Task.unregisterTask(this);
            this.didStopRunning();
            throw throwable;
        }
        Object var2_5 = null;
        task = this;
        synchronized (task) {
            this.running = false;
            this.dead = true;
            this.notifyAll();
        }
        Task.unregisterTask(this);
        this.didStopRunning();
        this.stop();
    }

    private void prepareToRun() {
        Object object;
        Class clazz;
        try {
            clazz = this.loadClass(this._appClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.err);
            throw new Error("I'm going under!!!");
        }
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace(System.err);
            throw new Error("I'm going under!!!");
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(System.err);
            throw new Error("I'm going under!!!");
        }
        this._application = (Application)object;
        this.eventLoop = this._application.eventLoop();
        if (this._taskOwner != null) {
            this._taskOwner.appDidConstruct(this._application);
        }
    }

    private void didStartRunning() {
    }

    private void didStopRunning() {
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        AppletThreadList appletThreadList = new AppletThreadList((ThreadGroup)this.group, this);
        MozillaAppletContext.killer.addAppletThread(appletThreadList);
    }

    public void requestShutdown() {
        if (!this.dead && this._taskOwner != null) {
            this._taskOwner.taskWillShutdown(this);
        }
        this._classLoader = null;
    }

    private void moveEvents() {
        if (this.initialEventQueue == null) {
            return;
        }
        int n = 0;
        while (n < this.initialEventQueue.size()) {
            CommandEvent commandEvent = (CommandEvent)this.initialEventQueue.elementAt(n);
            this.eventLoop.addEvent((Event)commandEvent);
            ++n;
        }
        this.initialEventQueue = null;
    }

    public synchronized void addEvent(Event event) {
        if (this.eventLoop != null) {
            if (this.initialEventQueue != null) {
                this.moveEvents();
            }
            this.eventLoop.addEvent(event);
            return;
        }
        this.initialEventQueue.insertElementAt(event, this.initialEventQueue.size());
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        AppletClassLoader appletClassLoader = (AppletClassLoader)this.classLoader();
        if (appletClassLoader == null) {
            return Class.forName(string);
        }
        return appletClassLoader.loadClass(string);
    }

    public synchronized void waitUntilRunningOrDead() {
        while (!this.isRunning() && !this.isDead()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

