/*****************************************************************
 * flpic.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:31:34 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flpic.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 11-Jun-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.95) mlm@cs.cmu.edu
 *	User contributed software.  I can't remember who wrote
 *	it...if you know, send mail to mlm@cs.cmu.edu.
 *****************************************************************/

#include <stdio.h>
#include "fbm.h"

#ifndef lint
static char *fbmid =
"$FBM flpic.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

/*
 * read_pic(image, rfile, mstr, mlen)
 *
 */

read_pic(image, rfile, mstr, mlen)
FBM *image;
FILE *rfile;
char *mstr;
int mlen;
{
unsigned int		Width, Height;
int			i,j;
unsigned char		*Red, *Grn, *Blu;

fscanf(rfile,"%d %d\n",&Width,&Height);

/* Create output image header */
	image->hdr.rows = Height;
	image->hdr.cols = Width;
	/* If this is odd number of bytes, add one */
	if ((image->hdr.cols & 1) != 0) image->hdr.cols++;
	image->hdr.planes = 3;
	image->hdr.bits = 8;
	image->hdr.physbits = 8;
	image->hdr.rowlen = image->hdr.cols;
	image->hdr.plnlen = image->hdr.rows * image->hdr.cols;
	image->hdr.clrlen = 0;
	image->hdr.aspect = 1.0;
	image->hdr.title[0] = '\0';
	image->hdr.credits[0] = '\0';

/* Get the Image */
	alloc_fbm(image);

	Red = image->bm;
	Grn = Red + image->hdr.plnlen;
	Blu = Grn + image->hdr.plnlen;
	for (i=0; i< Height; i++)
	{
		for (j=0; j< Width; j++)
		{
			fread(Red++,1,1,rfile);
			fread(Grn++,1,1,rfile);
			fread(Blu++,1,1,rfile);
		}
		if (Width != image->hdr.cols)
		{
			Red++;Grn++;Blu++;
		}
	}
}
