/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

/*
 * This file contains all functions and is included in all sources
 */

#ifndef	GLOBAL_H
#define	GLOBAL_H

#define	VERSION	"0.5.0Beta"

/*
 * global includes
 */
#ifdef ISC
#define	_POSIX_SOURCE
#endif

#include <stdio.h>
#ifndef Mips
#ifndef BSD43
#include <unistd.h>
#include <stdlib.h>
#endif
#endif

#include <fcntl.h>

#include <signal.h>
#include <sys/wait.h>

#include <sys/types.h>
#include <sys/stat.h>

#ifdef NODIRENT
#include <sys/dir.h>
#else
#include <dirent.h>
#endif

#include <grp.h>
#include <pwd.h>

#include <time.h>

#ifdef	hpux
#include <symlink.h>
#endif

#ifndef SIGCHLD
#ifdef SIGCLD
#define	SIGCHLD SIGCLD
#endif
#endif

#ifndef MYSIGTYPE
#define	MYSIGTYPE	void
#endif

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/extensions/shape.h>

#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>

#include "Clock.h"
#include "Icon.h"
#include "IconB.h"

#ifdef	HAVE_XPM
#include <X11/xpm.h>
#endif

#include "struct.h"
#include "config.h"

#ifdef	HAS_QUOTA
#if defined(hpux) || defined(ultrix)
#include <sys/quota.h>
#endif
#ifdef linux
#endif
#endif


#ifndef S_IRUSR
#define S_IRUSR S_IREAD
#define S_IWUSR S_IWRITE
#define S_IXUSR S_IEXEC
#define S_IRGRP (S_IRUSR >> 3)
#define S_IWGRP (S_IWUSR >> 3)
#define S_IXGRP (S_IXUSR >> 3)
#define S_IROTH (S_IRUSR >> 6)
#define S_IXOTH (S_IXUSR >> 6)
#define S_IWOTH (S_IWUSR >> 6)
#define S_ISDIR(x) ((x) & S_IFDIR)
#define S_ISCHR(x) ((x) & S_IFCHR)
#define S_ISBLK(x) ((x) & S_IFBLK)
#endif

/*
 * Function Prototypes
 */

/* about.c */
extern	void		initAbout	(void);

/* action.c */
extern	void		hide_dialog	(void);
extern	void		hide_idialog	(void);
extern	void		setSize		(void);
extern	void		WARNING		(char *text);
extern	void		init_goto	(void);
extern	void		gotoDir		(void);
extern	void		init_root	(void);
extern	void		init_quit	(void);
extern	Widget		makeDialog	(Dimension text,
					 char *label1,
					 char *label2,
					 char *text1,
					 char *text2,
					 char *title,
					 Boolean cancel,
					 Boolean OVERRIDE,
					 Pixmap icon);
extern	void		quit_all	(void);
extern	void		init_info	(void);
extern	void		apply_cb	(void);
extern	void		reset_cb	(void);
extern	void		getFilter	(Folder_Glyph *folder);
extern	void		apply_filter	(Widget w,
					 XtPointer c,
					 XtPointer s);
#ifndef COHERENT
extern	void		call_link_cb	(void);
#endif

/* action_copy.c */
extern	void		init_copy	(char *from,
					 char *to);
extern	void		exec_copy_cb	(void);
extern	void		exec_copy	(char *from,
					 char *to);

/* action_delete.c */
extern	void		init_delete	(char *file);
extern	void		exec_delete_cb	(void);
extern	void		exec_delete	(char *file);

/* action_exec.c */
extern	void		init_exec	(char *prog,
					 char *file);
extern	void		exec_exec_cb	(void);
extern	void		exec_exec	(char *prog,
					 char *file);
extern	int		SYSTEM		(char *cmd);

/* action_link.c */
extern	void		init_link	(char *from,
					 char *to);
extern	void		exec_link_cb	(void);
extern	void		exec_link	(char *from,
					 char *to);

/* action_move.c */
extern	void		init_move	(char *from,
					 char *to);
extern	void		exec_move_cb	(void);
extern	void		exec_move	(char *from,
					 char *to);

/* action_newdir.c */
extern	void		init_newdir	(char *file);
extern	void		exec_newdir	(void);

/* customize.c */
extern	Boolean		readCustomSettings	(void);
extern	void		loadTypeIcons	(void);

/* devices.c */
extern	Widget		CreateDeviceBox	(Widget bar,
					 Widget ref);
extern	void		ReadDeviceFile	(void);
extern	void		LoadDeviceIcons (Widget toplevel);
extern	XtActionProc	RefreshDevices	(Widget w,
					 XExposeEvent *e,
					 String *s,
					 Cardinal *c);

/* dir.c */
extern	void		fillDir		(Dir_Glyph *dir);
extern	int		compareGlyph	(Dir_Glyph *da,
					 Dir_Glyph *db);
extern	void		showDir		(Widget	window,
					 Dir_Glyph *dir,
					 Dimension x,
					 Dimension y,
					 Dimension *lx,
					 Dimension *ly,
					 Dimension hs,
					 Dimension he);
extern	String		getPath		(Dir_Glyph *dir);
extern	int		getFlags	(struct stat *buf);

/* file.c */
extern	void		fillFolder	(Folder_Glyph *folder);
extern	int		compareFGluph	(File_Glyph *da,
					 File_Glyph *db);
extern	void		showFolder	(Widget window,
					 Folder_Glyph *folder,
					 Dimension x,
					 Dimension y,
					 Dimension *lx,
					 Dimension *ly,
					 Dimension hs,
					 Dimension he);
extern	int		tryCommands	(File_Glyph *file);
extern	Boolean		ifFilter	(Folder_Glyph *folder,
					 char *file);

/* folder.c */
extern	void		newFolder	(Dir_Glyph *dir);
extern	void		makeFolderWindow(Widget parent,
					 Folder_Glyph *folder,
					 Dimension id);
extern	void		hideFolder	(Widget w,
					 XtPointer client,
					 XtPointer call);
extern	void		refreshFolderByPathname	(char *path);
extern	void		updateFolder	(Folder_Glyph *folder);

/* grab.c */
extern	XtActionProc	leaveWindow	(Widget w,
					 XLeaveWindowEvent *e, 
					 String *s,
					 Cardinal *c);
extern	XtActionProc	enterWindow	(Widget w,
					 XEnterWindowEvent *e, 
					 String *s,
					 Cardinal *c);

/* graph.c */
extern	void		makeCursor	(void);
extern	void		drawDir		(Widget window,
					 Dir_Glyph *dir,
					 Boolean selected,
					 Boolean back);
extern	void		drawFile	(Folder_Glyph *folder,
					 int entry,
					 Boolean selected,
					 Boolean back);
extern	void		drawWSE		(WS_Glyph *ws,
					 Dimension entry,
					 Boolean selected,
					 Boolean back);
extern	void		loadIcons	(void);
extern	Pixmap		ReadPixmapFromFile	(char *file,
					 int *w,
					 int *h);

/* iconbar.c */
extern	void		makeIconBar	(Folder_Glyph *fo,
					 Widget parent,
					 Widget left,
					 Boolean HIDE,
					 Boolean buttons);

/* main.c */
extern	void		main		(int agrc,
					 char **argv);
extern	void		createWidgets	(Widget parent);
extern	void		FATAL_ERROR	(char *message);
extern	XtActionProc	 refresh_files	(Widget w,
					 XExposeEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	 refresh_dirs	(Widget w,
					 XExposeEvent *e,
					 String *s,
					 Cardinal *c);
extern	Dir_Glyph	*getGlyph	(Dir_Glyph *d,
					 Dimension x,
					 Dimension y);
MYSIGTYPE		signal_handler	(int sig);
#ifdef HAS_QUOTA
extern	void		showQuota	(Widget w);
#endif
#ifdef	HAS_NO_STRRSTR	/* Linux libc.so.4.4.1 doesn't have this function */
extern	char		*strrstr	(char *vs,
					 char *ve);
#endif

/* menu.c */
extern	void		makeMenu	(Widget parent);
extern	char		*getString	(void);
extern	char		*getMulti	(void);
extern	void		start_move	(void);
extern	void		start_copy	(void);
extern	void		start_delete	(void);
extern	void		start_newdir	(void);
extern	void		start_exec	(void);
extern	void		start_quit	(void);
extern	void		start_about	(void);
extern	void		start_info	(void);
extern	void		start_goto	(void);
extern	void		start_root	(void);
extern	void		start_WSedit	(void);
extern	void		start_WSdelete	(void);
extern	void		start_filter	(Widget w, XtPointer c, XtPointer s);
#ifndef COHERENT
extern	void		start_link	(void);
#endif

/* merger.c */
extern	void		start_merger	(void);

/* multi.c */
extern	XtActionProc	startMulti	(Widget w,
					 XButtonEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	followMulti	(Widget w,
					 XButtonEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	endMulti	(Widget w,
					 XButtonEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	clearMulti	(Widget w,
					 XEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	refreshMulti	(Widget w,
					 XEvent *e,
					 String *s,
					 Cardinal *c);

/* popup.c */
extern	XtActionProc	startPopup	(Widget w,
					 XButtonEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	hidePopup	(Widget w,
					 XEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	startCustom	(Widget w,
					 XEnterWindowEvent *e,
					 String *s,
					 Cardinal *c);
extern	void		readMenu	(void);
extern	void		startExecPopup	(Widget w,
					 XtPointer client,
					 XtPointer call);

/* single.c */
extern	XtActionProc	startSingle	(Widget w,
					 XButtonEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	followSingle	(Widget w,
					 XButtonEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	endSingle	(Widget w,
					 XButtonEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	clearSingle	(Widget w,
					 XEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	followFile	(Widget w,
					 XMotionEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	followDir	(Widget w,
					 XMotionEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	followWS	(Widget w,
					 XMotionEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	refresh_icon	(Widget w,
					 XExposeEvent *e,
					 String *s,
					 Cardinal *c);

/* tar.c */
extern	void		fillTar		(Folder_Glyph *folder);
extern	void		fillCTar	(Folder_Glyph *folder);
extern	void		readTar		(Folder_Glyph *folder,
					 FILE *pipe);
extern	void		start_extract	(void);

/* workspace.c */
extern	void		makeWorkspaceWindow	(Widget parent,
					 WS_Glyph *ws);
extern	XtActionProc	resetWS		(Widget w,
					 XConfigureEvent *e,
					 String *s,
					 Cardinal *c);
extern	XtActionProc	refreshWS	(Widget w,
					 XExposeEvent *e,
					 String *s,
					 Cardinal *c);
extern	void		addWSEtoWS	(WS_Glyph *ws,
					 char *label,
					 char *file,
					 char *icon,
					 Boolean can_arg,
					 Boolean must_arg,
					 Boolean do_ask,
					 int x,
					 int y);
extern	void		readWorkspace	(WS_Glyph *ws,
					 char *file);
extern	void		init_editWSE	(void);
extern	void		init_deleteWSE	(void);
extern	void		saveWorkspace	(WS_Glyph *ws);
extern	void		hide_wsshell	(void);
extern	void		reset_wsshell	(void);
extern	void		save_wsshell	(void);
extern	void		apply_wsshell	(void);
extern	void		wse_delete_cb	(void);
extern	void		PlaceWorkspaceIcons	(void);


/*
 * Globale variablen
 */
#ifndef MAIN
/*
 * All global variables that are shared between several objects are declared in
 * the main section of this file.
 * Any local varaible is declared as static on top of each file.
 */
extern	XtAppContext	app_context;

extern	Widget		toplevel;
extern	Widget		dir_area;
extern	Widget		merge_field;
extern	Widget		dialog;
extern	Widget		info_shell;
extern	Widget		text_1, text_2, text_3, text_4;
extern	Widget		tog[];
#ifdef	HAS_QUOTA
extern	Widget		quota_label;
#endif
extern	Widget		ws_move_shell;
extern	Widget		merge_window;

extern	Cursor		def_cursor;
extern	Cursor		file_cursor;
extern	Cursor		busy_cursor;

extern	Pixmap		Icon_Warning_PM;
extern	Pixmap		Icon_Info_PM;
extern	Pixmap		Icon_Help_PM;
extern	Pixmap		Icon_Filter_PM;
extern	Pixmap		Icon_Copy_PM;
extern	Pixmap		Icon_Delete_PM;
extern	Pixmap		Icon_Exec_PM;
extern	Pixmap		Icon_Link_PM;
extern	Pixmap		Icon_Move_PM;
extern	Pixmap		Icon_Newdir_PM;
extern	Pixmap		Icon_Hide_PM;
extern	Pixmap		Icon_WSE_PM;
extern	Pixmap		Icon_WSD_PM;
extern	Pixmap		Icon_Goto_PM;
extern	Pixmap		Icon_Root_PM;
extern	Pixmap		Icon_Pack_PM;
extern	Pixmap		Icon_Unpack_PM;

extern	Pixmap		Dir_Opened_PM;
extern	Pixmap		Dir_Closed_PM;
extern	Pixmap		Dir_Locked_PM;

extern	Pixmap		File_Root_PM;
extern	Pixmap		File_Tar_PM;
extern	Pixmap		File_CTar_PM;
extern	Pixmap		File_Plain_PM;
extern	Pixmap		File_Link_PM;
extern	Pixmap		File_DLink_PM;
extern	Pixmap		File_Lock_PM;
extern	Pixmap		File_Ghost_PM;
extern	Pixmap		File_Exec_PM;
extern	Pixmap		Shape_Exec_PM;

extern	Pixmap		smap;
extern	GC		line_gc;
extern	GC		back_gc;
extern	GC		selc_gc;
extern	GC		white_gc;

extern	Boolean		FILE_CHANGED;
extern	Boolean		DIR_CHANGED;

extern	WS_Glyph	workspace;
extern	Dir_Glyph	root;
extern	Folder_Glyph	*folders[];
extern	Dimension	folder_count;
extern	Folder_Glyph	*folder;		/* The folder the mouse is within or NULL */

extern	Folder_Glyph	*last_fo;
extern	Dimension	last_v;
extern	Dimension	last_y;
extern	Dir_Glyph	*last_g;
extern	WS_Glyph	*last_ws;
extern	Dimension	last_w;

extern	WS_Glyph	*selc_ws;
extern	Dimension	selc_w;
extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Dir_Glyph	*selc_g;
extern	Folder_Glyph	*multi_fo;
extern	Dimension	multi_vs, multi_ve;

extern	Boolean		MULTI;			/* Wenn Multi-Selection dann TRUE */
extern	Boolean		GRAB;
extern	Boolean		WORKSPACE_CHANGED;
extern	Boolean		REFRESH;
extern	Boolean		NO_MULTI;

extern	char		link_target[];		/* Fuer action.c */
extern	char		*oldfile;

extern	xfm_struct	defaults;
extern	Suffix_Glyph	*filetypes;
extern	Dimension	max_filetypes;

extern	Pixmap		pmaps[];		/* fuer customize.c */
extern	int		pcount;
extern	Dimension	typelength;

extern	Widget		ws_bar;
extern	Widget		icon_bar;
extern	Widget		icon_left;

#else
/*
 * This part is only included by main.c
 */
	XtAppContext	app_context;		/* the application context */

	Widget		toplevel;		/* The toplevel widget */
	Widget		dir_area;		/* the simple for the directory tree */
	Widget		merge_field;		/* Das Text-Feld fuer das Merge */
static	Widget		dir_vp;			/* viewport for the dir_are-widget */
	Widget		dialog = NULL;		/* Dialog-shell for all small dialogs */
	Widget		info_shell = NULL;	/* Dialog-shell for the file-info-window */
	Widget		text_1, text_2, text_3, text_4;	/* The text-field of info_shell */
	Widget		tog[9];			/* File-rights toggles */
#ifdef	HAS_QUOTA
	Widget		quota_label;		/* label to show to quotas */
#endif
	Widget		merge_window = NULL;
	Widget		ws_move_shell = NULL;	/* The window for the icon moving */

	Cursor		def_cursor;		/* Normal cursor */
	Cursor		file_cursor;		/* Cursor for darg&drop actions */
	Cursor		busy_cursor;		/* the sleep cursor */

	Pixmap		Icon_Warning_PM;
	Pixmap		Icon_Info_PM;
	Pixmap		Icon_Help_PM;
	Pixmap		Icon_Filter_PM;
	Pixmap		Icon_Copy_PM;
	Pixmap		Icon_Delete_PM;
	Pixmap		Icon_Exec_PM;
	Pixmap		Icon_Link_PM;
	Pixmap		Icon_Move_PM;
	Pixmap		Icon_Newdir_PM;
	Pixmap		Icon_Hide_PM;
	Pixmap		Icon_WSE_PM;
	Pixmap		Icon_WSD_PM;
	Pixmap		Icon_Goto_PM;
	Pixmap		Icon_Root_PM;
	Pixmap		Icon_Pack_PM;
	Pixmap		Icon_Unpack_PM;

	Pixmap		Dir_Opened_PM;
	Pixmap		Dir_Closed_PM;
	Pixmap		Dir_Locked_PM;

	Pixmap		File_Root_PM;
	Pixmap		File_Tar_PM;
	Pixmap		File_CTar_PM;
	Pixmap		File_Plain_PM;
	Pixmap		File_Link_PM;
	Pixmap		File_DLink_PM;
	Pixmap		File_Lock_PM;
	Pixmap		File_Ghost_PM;
	Pixmap		File_Exec_PM;
	Pixmap		Shape_Exec_PM;

	Pixmap		smap;			/* When loading icons, this pixmap contains the shape of the icon */

	GC		line_gc;		/* Font and Color to display filenames when unselected */
	GC		back_gc;		/* the backgroundcolor */
	GC		selc_gc;		/* the background for selected files */
	GC		white_gc;		/* the foregroundcolor for selected files */

	Boolean		FILE_CHANGED = FALSE;	/* If the file-folder has changed -> refresh_files */
	Boolean		DIR_CHANGED = FALSE;	/* same as above but for directories */

	WS_Glyph	workspace;		/* The workspace */
	Dir_Glyph	root;			/* The root-dir of the directory tree */
	Folder_Glyph	*folders[MAX_FOLDERS];	/* All folder-windows */
	Dimension	folder_count = 0;	/* Number of folders */
	Folder_Glyph	*folder = NULL;		/* The folder the mouse is within or NULL */

	Folder_Glyph	*last_fo = NULL;	/* Needed to follow the mouse */
	Dimension	last_v = 16000;
	Dimension	last_y = 16000;
	Dir_Glyph	*last_g = NULL;
	WS_Glyph	*last_ws = NULL;
	Dimension	last_w = 16000;

	WS_Glyph	*selc_ws = NULL;	/* Needed for single-selections */
	Dimension	selc_w = 16000;
	Folder_Glyph	*selc_fo = NULL;
	Dimension	selc_f = 16000;
	Dir_Glyph	*selc_g = NULL;

	Folder_Glyph	*multi_fo = NULL;	/* For multi-selections */
	Dimension	multi_vs = 16000;	/* Start */
	Dimension	multi_ve = 16000;	/* End */

	Boolean		MULTI = FALSE;		/* True when using multiselections */
	Boolean		GRAB = FALSE;		/* True when doing drag&drop */
	Boolean		WORKSPACE_CHANGED = FALSE;	/* If the workspace has been modified */
	Boolean		REFRESH = FALSE;	/* Don't know for what it's been used */
	Boolean		NO_MULTI = FALSE;	/* Keine Multi-Operation */

	char		link_target[255];	/* action.c */
	char		*oldfile = NULL;

	xfm_struct	defaults;		/* The resource-container */
	Suffix_Glyph	*filetypes = NULL;	/* The file-type definitions */
	Dimension	max_filetypes = 0;	/* Number of filetypes */

	Pixmap		pmaps[100];		/* fuer customize.c */
	int		pcount = 0;
	Dimension	typelength = 10;

	Widget		ws_bar = NULL;
	Widget		icon_bar = NULL;
	Widget		icon_left = NULL;

static	Atom		wm_delete_window;	/* Atom zum Abfangen des Closebuttons */
static	int		label_height; 		/* Hoehe des Folder.labels */
static	int		vp_width;		/* Breite des Dir-Viewports */

/*
 * Den Actionsrec erzeugen
 */
static XtActionsRec actions[] =
{
	{"start-custom",
		(XtActionProc) startCustom
	},
	{"start-popup",
		(XtActionProc) startPopup
	},
	{"hide-popup",
		(XtActionProc) hidePopup
	},
	{"refresh-dirs",
		(XtActionProc) refresh_dirs
	},
	{"refresh-devices",
		(XtActionProc) RefreshDevices
	},
	{"refresh-files",
		(XtActionProc) refresh_files
	},
	{"refresh-ws",
		(XtActionProc) refreshWS
	},
	{"reset-ws",
		(XtActionProc) resetWS
	},
	{"refresh-icon",
		(XtActionProc) refresh_icon
	},
	{"clear-single",
		(XtActionProc) clearSingle
	},
	{"start-single",
		(XtActionProc) startSingle
	},
	{"follow-single",
		(XtActionProc) followSingle
	},
	{"end-single",
		(XtActionProc) endSingle
	},
	{"clear-multi",
		(XtActionProc) clearMulti
	},
	{"start-multi",
		(XtActionProc) startMulti
	},
	{"follow-multi",
		(XtActionProc) followMulti
	},
	{"end-multi",
		(XtActionProc) endMulti
	},
	{"refresh-multi",
		(XtActionProc) refreshMulti
	},
	{"leave-window",
		(XtActionProc) leaveWindow
	},
	{"enter-window",
		(XtActionProc) enterWindow
	},
	{"start-copy",
		(XtActionProc) start_copy
	},
	{"start-move",
		(XtActionProc) start_move
	},
	{"start-delete",
		(XtActionProc) start_delete
	},
	{"start-exec",
		(XtActionProc) start_exec
	},
	{"start-info",
		(XtActionProc) start_info
	},
};

#endif

/*
 * Fuer das Debuggen
 */
#ifdef DEBUG
/*
 * Function prototypes
 */
extern	void	debug (const char *format, __va_list list);
#endif

#endif

