
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>

#include "access.h"

static void hup()
{
    kill(getppid(), SIGTERM);
    exit(0);
}

void main(int argc, char** argv)
{
    if (argc >= 2)
    {
	extern int ttynr;
	int time = atoi(argv[1]);
	ttynr = get_ttydef(NULL);
	if (time > 0)
	  watch_access(ttynr, time, hup);
		
	while (1)
	  sigpause(0);
    }
    exit(0);
}

