/*
 * $Id: ztype.h,v 1.4 1995/03/11 06:17:29 coleman Exp coleman $
 *
 * ztype.h - character classification macros
 *
 * This file is part of zsh, the Z shell.
 *
 * Copyright (c) 1992-1995 Paul Falstad
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * In no event shall Paul Falstad or the Zsh Development Group be liable
 * to any party for direct, indirect, special, incidental, or consequential
 * damages arising out of the use of this software and its documentation,
 * even if Paul Falstad and the Zsh Development Group have been advised of
 * the possibility of such damage.
 *
 * Paul Falstad and the Zsh Development Group specifically disclaim any
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose.  The software
 * provided hereunder is on an "as is" basis, and Paul Falstad and the
 * Zsh Development Group have no obligation to provide maintenance,
 * support, updates, enhancements, or modifications.
 *
 */

#define IDIGIT  1
#define IALNUM  2
#define IBLANK  4
#define INBLANK 8
#define ITOK    16
#define ISEP    32
#define IALPHA  64
#define IIDENT  128
#define IUSER   256
#define ICNTRL  512
#define IWORD	 1024
#define ISPECIAL 2048
#define _icom(X,Y) (typtab[(int) (unsigned char) (X)] & Y)
#define idigit(X) _icom(X,IDIGIT)
#define ialnum(X) _icom(X,IALNUM)
#define iblank(X) _icom(X,IBLANK)	/* blank, not including \n */
#define inblank(X) _icom(X,INBLANK)	/* blank or \n */
#define itok(X) _icom(X,ITOK)
#define isep(X) _icom(X,ISEP)
#define ialpha(X) _icom(X,IALPHA)
#define iident(X) _icom(X,IIDENT)
#define iuser(X) _icom(X,IUSER)	/* username char */
#define icntrl(X) _icom(X,ICNTRL)
#define iword(X) _icom(X,IWORD)
#define ispecial(X) _icom(X,ISPECIAL)
