% This is something that I through together to create makefiles for DOS.
variable Makefile_Modules;
variable Makefile_Buffer;
variable Makefile_Path_Sep = "/";
variable Makefile_Object_Rule_Template = "object rule not spec";
variable Makefile_Exe_Rule_Template = "exe rule not spec";
 
define makefile_get_modules (modfile, sys)
{
   push_mark ();
   () = insert_file (modfile);
   narrow_to_region ();
   
   sys = strncat ("#", sys, "#", 3);
   
   bob ();
   while (fsearch (sys))
     {
	bol ();
	() = ffind ("#");
	del_eol ();
     }
   
   % Delete all other comments and systems
   bob ();
   while (fsearch ("#")) delete_line ();
   
   bob (); push_mark (); eob ();
   
   widen_region ();
   Makefile_Modules = bufsubstr_delete ();
   Makefile_Modules = strcompress (Makefile_Modules, " \n");
   while (str_replace (Makefile_Modules, "\n", " "))
     Makefile_Modules = ();
}

define makefile_module_eqs (obj, pre, ext)
{
   variable rep, len;
   
   len = strlen (obj) + 3;
   insert (obj);
   insert (" = ");
   push_mark ();
   insert (Makefile_Modules);
   narrow_to_region ();
   bob ();
   rep = strcat (ext, " \\\n");
   loop (len) rep = strcat (rep, " ");
   replace (" ", rep);
   eob ();
   insert (ext);
   bob ();
#iftrue
   do
     {
	skip_white ();
	insert (pre);
     }
   while (down (1));
#endif
   eob ();
   widen_region ();
   newline ();
}

define makefile_add_module (module)
{
   module = strtrim (module);
   Makefile_Modules = strncat (Makefile_Modules, " ", module, 3);
}

define makefile_add_macro_comment (name, value, comment)
{
   vinsert ("%s = %s# %s\n", name, value, comment, 3);
}

define makefile_add_macro (name, value)
{
   vinsert ("%s = %s\n", name, value, 2);
}

   
define makefile_init (name, sys, comment, modfile, cc, cflags)
{
   () = find_file (name);
   Makefile_Buffer = whatbuf ();
   erase_buffer ();
   
   vinsert ("# -*- sh -*-\n#This %s makefile was automatically generated from makefile.sl\n",
	   sys, 1);
   vinsert ("# %s\n", comment, 1);
   makefile_add_macro_comment ("MODFILE", modfile, "Contains list of modules");
   makefile_add_macro ("CC", cc);
   makefile_add_macro ("CFLAGS", cflags);
   
   makefile_get_modules (modfile, sys);
}

define makefile_add (str)
{
   setbuf (Makefile_Buffer);
   eob ();
   insert (str);
   newline ();
}

define makefile_add_line ()
{
   insert ("#");
   loop (75) insert ("-");
   newline ();
}


define makefile_add_section (name)
{
   makefile_add_line ();
   insert ("# ");
   insert (name);
   newline ();
   makefile_add_line ();
}


define makefile_make_response_file (rsp_file, dep, fmt, cont)
{
   variable obj;
   variable n;
   variable str, redir, redir_next;

   makefile_add (Sprintf ("%s : %s", rsp_file, dep, 2));
   
   redir = strcat ("> ", rsp_file);
   redir_next = strcat (">", redir);
   
   vinsert ("\t@echo Creating response file %s\n", rsp_file, 1);
   n = strchop (Makefile_Modules, ' ', 0);
   while (n)
     {
	n--;
	obj = ();
	
	str = Sprintf (fmt, obj, 1);
	if (n) str = strcat (str, cont);
	vinsert ("\t@echo %s %s\n",
		 str,
		 redir,
		 2);
	redir = redir_next;
     }
}

define makefile_create_objects (ext)
{
   makefile_module_eqs ("OBJS", strcat ("$(OBJDIR)", Makefile_Path_Sep), ext);
}

define makefile_add_object_rule (module)
{
   push_mark ();
   insert (Makefile_Object_Rule_Template);
   narrow_to_region ();
   bob ();
   replace ("#SRCDIR#", "$(SRCDIR)");
   replace ("#OBJDIR#", "$(OBJDIR)");
   replace ("#C#", module);
   replace ("#O#", module);
   replace ("#I#", "$(INCDIR)");
   widen_region ();
   eob ();
   newline ();
}

define makefile_add_exec_rule (exe)
{
   push_mark ();
   insert (Makefile_Exe_Rule_Template);
   narrow_to_region ();
   bob ();
   replace ("#OBJDIR#", "$(OBJDIR)");
   replace ("#EXE#", exe);
   widen_region ();
   eob ();
   newline ();
}

define makefile_set_object_rule (template)
{
   Makefile_Object_Rule_Template = template;
}

define makefile_set_exec_rule (template)
{
   Makefile_Exe_Rule_Template = template;
}

define makefile_module_rules ()
{
   loop (strchop (Makefile_Modules, ' ', 0))
     {
	makefile_add_object_rule (());
     }
}

define makefile_set_dirs (src, obj)
{
   makefile_add_macro_comment ("SRCDIR", src, "Location of sources");
   makefile_add_macro_comment ("OBJDIR", obj, "Location of objects");
}


define pc_makefile (makefile_name, sys, comment, 
		    cc, cflags,
		    misc,
		    lib_cmd, lib_name,
		    objdir,
		    o_ext,
		    path_sep,
		    c_to_o_rule,
		    rsp_file, rsp_fmt, rsp_cont )
{
   variable target, rule;
   
   target = Sprintf ("$(OBJDIR)%s%s", path_sep, lib_name, 2);

   Makefile_Path_Sep = path_sep;
   
   makefile_init (makefile_name, sys, comment, "../modules.lis", cc, cflags);

   makefile_set_dirs (".", objdir);
   if (strlen (misc)) makefile_add (misc);

   % This is what we are building
   makefile_add_macro ("INCDIR", "$(OBJDIR)");
   makefile_add_macro ("TARGET", target);
   makefile_add_macro ("RSPFILE", rsp_file);
   % makefile_add_macro ("MAKEFILE", makefile_name);
   makefile_add_macro ("CONFIG_H", 
		       Sprintf ("$(OBJDIR)%sconfig.h", path_sep, 1));
   makefile_create_objects (o_ext);
   
   makefile_add ("$(TARGET): $(OBJDIR) $(CONFIG_H) $(RSPFILE) $(OBJS)");
   makefile_add (strcat ("\t", lib_cmd));
   
   % Rule for the objdir
   makefile_add ("$(OBJDIR) :\n\t-mkdir $(OBJDIR)");
   makefile_add ("$(CONFIG_H): slconfig.h\n\tcopy slconfig.h $(OBJDIR)\\config.h");
   
   if (strlen (rsp_file))
     makefile_make_response_file ("$(RSPFILE)", "", rsp_fmt, rsp_cont);
   
   rule = Sprintf ("$(OBJDIR)%s#O#%s : $(SRCDIR)%s#C#.c $(CONFIG_H)\n\t%s\n",
		   path_sep, o_ext, path_sep,
		   c_to_o_rule,
		   4);
   
   % Generic rule for .c --> .obj
   makefile_set_object_rule (rule);
   makefile_module_rules ();
}

define bcc_makefile ()
{
   
   pc_makefile ("makefile.bcc",
		"MSDOS",
		"This makefile is for BCC",
		"bcc", "-G- -H -N -O1 -w -ml -Dmsdos",
		"",		       %  misc not used
		"tlib $(TARGET) /C @$(RSPFILE)", "slang.lib",
		"dosobjs", ".obj", "\\",
		"$(CC) -c $(CFLAGS) -I#I# -o#OBJDIR#\\#O#.obj #SRCDIR#\\#C#.c",		
		"dos.rsp", "+-$(OBJDIR)\\\\%s.obj", " &"
		);
}

define msw_makefile ()
{
   
   pc_makefile ("makefile.msw",
		"MSDOS",
		"This makefile is for windows using BCC",
		"bcc", "-G- -H -N -w -ml -Dmsdos -DMSWINDOWS -W# -DFLOAT_TYPE",
		"",		       %  misc not used
		"tlib $(TARGET) /C @$(RSPFILE)", "wslang.lib",
		"mswobjs", ".obj", "\\",
		"$(CC) -c $(CFLAGS) -I#I# -o#OBJDIR#\\#O#.obj #SRCDIR#\\#C#.c",		
		"msw.rsp", "+-$(OBJDIR)\\\\%s.obj", " &"
		);
}

define wcc_makefile ()
{
   
   pc_makefile ("makefile.wcc",
		"MSDOS",
		"This makefile is for WATCOM C (untested).",
		"wcl386", "-w4 -Dmsdos -DDOS386 -DFLOAT_TYPE",
		"",		       %  misc not used
		"wlib -b $(TARGET) @$(RSPFILE)", "slang.lib",
		"dosobjs", ".obj", "\\",
		"$(CC) -c $(CFLAGS) -I#I# -o#OBJDIR#\\#O#.obj #SRCDIR#\\#C#.c",		
		"wcc.rsp", "+-$(OBJDIR)\\\\%s.obj", " &"
		);
}


define djgpp_makefile ()
{
   
   pc_makefile ("makefile.djg",
		"MSDOS",
		"This makefile is for DJGPP",
		"gcc", "-O -Wall #-DFLOAT_TYPE",
		"GO32 = G:/djgpp/bin/go32.exe",		       
		"-rm $(TARGET)\n\tar -cr $(TARGET) @$(RSPFILE)\n\tranlib $(TARGET)", 
		"libslang.a",
		"djgobjs", ".o", "/",
		"$(CC) -c $(CFLAGS) -I#I# -o #OBJDIR#/#O#.o #SRCDIR#/#C#.c",		
		"djgpp.rsp", "$(OBJDIR)/%s.o", ""
		);
}

define emx_makefile ()
{
   
   pc_makefile ("makefile.emx",
		"OS2",
		"This makefile is for EMX (untested)",
		"gcc", "-O -Wall -DFLOAT_TYPE",
		"",		       %  misc
		"-rm $(TARGET)\n\t-ar -cr $(TARGET) @$(RSPFILE)\n\tranlib $(TARGET)", 
		"slang.a",
		"emxobjs", ".o", "/",
		"$(CC) -c $(CFLAGS) -I#I# -o #OBJDIR#/#O#.o #SRCDIR#/#C#.c",		
		"emx.rsp", "$(OBJDIR)/%s.o", ""
		);
}

define msc_makefile ()
{
   
   pc_makefile ("makefile.msc",
		"OS2",
		"This makefile is for Microsoft C under OS/2 (untested)",
		"cl -nologo -MT", "-D__os2_16__ #-DFLOAT_TYPE",
		"",		       %  misc
		"-rm $(TARGET)\n\t-lib $(TARGET) @$(RSPFILE)", 
		"slang.lib",
		"mscobjs", ".obj", "\\",
		"$(CC) -c $(CFLAGS) -I#I# -o #OBJDIR#/#O#.o #SRCDIR#/#C#.c",		
		"msc.rsp", "-+$(OBJDIR)/%s.obj", " &"
		);
}

bcc_makefile (); save_buffer (); delbuf (whatbuf ());
msw_makefile (); save_buffer (); delbuf (whatbuf ());
djgpp_makefile (); save_buffer (); delbuf (whatbuf ());

quit_jed ();
