#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>

/***************************************************************************
 *
 * Function:    vsnprintf
 *
 * Description:
 *     Formatted print data to the string using variable arguments.
 *
 * Input:
 *     stream   - pointer to the output string
 *     len	- length of output string.
 *     format   - pointer to the format string
 *     ap       - variable arg list pointer
 *
 * Result:
 *     The number of characters written to the output.
 */

int vsnprintf (char *pszString, int len, const char *pszFormat, va_list ap)
    {
    FILE    fdString;
    int     nAnswer;
    FUNC_ENTRY ("vsprintf");
/*
 *  Construct the output string file
 */
    fdString._flag = _IOWRT;
    fdString._ptr  =
    fdString._base = pszString;
    fdString._cnt  = len;
    fdString._file = STRING_FILE;
/*
 *  Output the stream
 */
    nAnswer = _doprnt (pszFormat, ap, &fdString);
    putc ('\0', &fdString);
/*
 *  Return the answer to the caller.
 */
    FUNC_EXIT ("vsprintf");
    return(nAnswer);
    }
