------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             E X P _ C H 1 3                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.23 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Atree;    use Atree;
with Einfo;    use Einfo;
with Exp_Ch3;  use Exp_Ch3;
with Exp_Ch6;  use Exp_Ch6;
with Nlists;   use Nlists;
with Nmake;    use Nmake;
with Rtsfind;  use Rtsfind;
with Sem;      use Sem;
with Sem_Ch7;  use Sem_Ch7;
with Sem_Ch8;  use Sem_Ch8;
with Sem_Eval; use Sem_Eval;
with Sem_Util; use Sem_Util;
with Sinfo;    use Sinfo;
with Snames;   use Snames;
with Tbuild;   use Tbuild;
with Uintp;    use Uintp;

package body Exp_Ch13 is

   ------------------------------------------
   -- Expand_N_Attribute_Definition_Clause --
   ------------------------------------------

   --  Expansion action depends on attribute involved

   procedure Expand_N_Attribute_Definition_Clause (N : Node_Id) is
      Loc : constant Source_Ptr := Sloc (N);
      Ent : constant Entity_Id  := Entity (Name (N));
      Exp : constant Entity_Id  := Expression (N);
      V   : Node_Id;

   begin
      case Get_Attribute_Id (Chars (N)) is

      --  Alignment

      when Attribute_Alignment =>

         --  As required by Gigi, we guarantee that the operand is an
         --  integer literal (this simplifies things in Gigi).

         if Nkind (Exp) /= N_Integer_Literal then
            Rewrite_Substitute_Tree
              (Exp, Make_Integer_Literal (Loc, Expr_Value (Exp)));
         end if;

      --  Storage_Size

      when Attribute_Storage_Size =>

         --  If the type is a task type, then assign the value of the
         --  storage size to the Size variable associated with the task.
         --    task___Size := expression

         if Ekind (Ent) = E_Task_Type then
            Rewrite_Substitute_Tree (N,
              Make_Assignment_Statement (Loc,
                Name => Make_Identifier (Loc,
                  Chars =>
                    New_External_Name (Chars (Etype (Name (N))), 'Z')),
                Expression =>
                  Make_Type_Conversion (Loc,
                    Subtype_Mark =>
                      New_Reference_To (RTE (RE_Size_Type), Loc),
                    Expression => Expression (N))));

               Analyze (N);

         --  For Storage_Size for an access type, create a variable to hold
         --  the value of the specified size with name typeV and expand an
         --  assignment statement to initialze this value.

         elsif Ekind (Ent) = E_Access_Type then

            V := Make_Defining_Identifier (Loc,
                   New_External_Name (Chars (Ent), 'V'));

            Rewrite_Substitute_Tree (N,
              Make_Object_Declaration (Loc,
                Defining_Identifier => V,
                Object_Definition  =>
                  New_Reference_To (RTE (RE_Storage_Offset), Loc),
                Expression =>
                  Make_Type_Conversion (Loc,
                    Subtype_Mark =>
                      New_Reference_To (RTE (RE_Storage_Offset), Loc),
                    Expression => Expression (N))));

            Analyze (N);
            Set_Storage_Size_Variable (Ent, Entity_Id (V));
         end if;

         --  Other attributes require no expansion

         when others => null;

      end case;

   end Expand_N_Attribute_Definition_Clause;

   ----------------------------
   -- Expand_N_Freeze_Entity --
   ----------------------------

   procedure Expand_N_Freeze_Entity (N : Node_Id) is
      E           : constant Entity_Id := Entity (N);
      Inner_Scope : Boolean := False;

   begin
      if not Is_Type (E) and then not Is_Subprogram (E) then
         return;
      end if;

      --  If the entity being frozen is defined in an inner package or task,
      --  we must establish the proper visibility before freezing the
      --  entity, and related subprograms.

      if Scope (Scope (E)) = Current_Scope then
         New_Scope (Scope (E));
         Install_Visible_Declarations (Scope (E));
         Install_Private_Declarations (Scope (E));
         Inner_Scope := True;
      end if;

      --  If type, freeze the type

      if Is_Type (E) then
         Freeze_Type (N);

      --  If subprogram, freeze the subprogram

      elsif Is_Subprogram (E) then
         Freeze_Subprogram (N);

      --  No other entities require any front end freeze actions

      else
         null;
      end if;

      --  Analyze actions generated by freezing.

      if Present (Actions (N)) then
         Analyze_List (Actions (N));
      end if;

      if Inner_Scope then
         if Ekind (Current_Scope) = E_Package then
            End_Package_Scope (Scope (E));
         else
            End_Scope;
         end if;
      end if;
   end Expand_N_Freeze_Entity;

   -------------------------------------------
   -- Expand_N_Record_Representation_Clause --
   -------------------------------------------

   --  The only expansion required is for the case of a mod clause present,
   --  which is removed, and translated into an alignment representation
   --  clause inserted immediately after the record rep clause.

   procedure Expand_N_Record_Representation_Clause (N : Node_Id) is
      Loc     : constant Source_Ptr := Sloc (N);
      Rectype : constant Entity_Id  := Entity (Identifier (N));
      Mod_Val : Uint;

   begin
      if Present (Mod_Clause (N)) then
         Mod_Val := Expr_Value (Expression (Mod_Clause (N)));
         Set_Mod_Clause (N, Empty);

         Insert_After (N,
           Make_Attribute_Definition_Clause (Loc,
             Name       => New_Reference_To (Rectype, Loc),
             Chars      => Name_Alignment,
             Expression => Make_Integer_Literal (Loc, Mod_Val)));
      end if;
   end Expand_N_Record_Representation_Clause;

end Exp_Ch13;
