/* This file is part of the Project Athena Zephyr Notification System.
 * Created by: Mark W. Eichin <eichin@athena.mit.edu>
 * $Source: /mit/zephyr/src/zwgc/RCS/eval_stat.h,v $
 * $Author: eichin $
 *
 *	Copyright (c) 1988 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 *
 * $Header: eval_stat.h,v 1.2 88/07/10 22:29:42 eichin Exp $
 */

/* NE_ERR isn't really dealt with, but it should never happen anyway. */
#define NE_ERR -1
#define NE_OK 0
#define NE_SHOW 01
#define NE_SUMM 02
#define NE_EXIT 04
#define NE_IS_(t,s) ((s&t)==t)
#define NE_IS_SHOW(s) NE_IS_(NE_SHOW, s)
#define NE_IS_SUMM(s) NE_IS_(NE_SUMM, s)
#define NE_IS_EXIT(s) NE_IS_(NE_EXIT, s)
#define NE_IS_DONE(s) (NE_IS_EXIT(s)&&(NE_IS_SHOW(s)?NE_IS_SUMM(s):TRUE))
#define NE_CAN_MAP(s) (NE_IS_SHOW(s)&&NE_IS_SUMM(s))
#define NE_CAN_SHOW(s) (!NE_IS_SHOW(s)&&!NE_IS_EXIT(s))
