/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#include <mbase.h>
#include "internal.h"


/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

 static void  _close_proc  XARGS( (relation *) );


/*
 * VARIABLES ------------------------------------------------------------------
 *
 */

mb_err
mb_rmv   (rel)
relation *rel;
{
   int  i;

   if ((i = _identify (rel)) == -1)  Error (MB_BAD_REL);

   _close_proc (rel);
   aRel[i] = RNULL;

   SetError (MB_OKAY);

lblERROR:
   return mb_errno;
}

void
mb_exit (x)
int      x;
{
   mb_die ();
   exit   (x);
}

void
mb_die ()
{
   int  i;

   if (fStarted)
      {
      for (i = 0; i < MAX_REL; i++)
         {
         if (aRel[i] != RNULL)
            {
            _close_proc (aRel[i]);
            aRel[i] = RNULL;
            }
         }
      }

   SetError (MB_OKAY);
}

char *
GetTmpDir (buf)
char      *buf;
{
   charptr  pch;

   *buf = 0;
   if ((pch = getenv ("TMP")) != NULL || (pch = getenv ("TEMP")) != NULL)
      {
      strcpy (buf, pch);  /* If they define a directory, use it. */
      }
   else                   /* Otherwise, try to guess a default directory. */
      {
#ifdef UNIX
      strcpy (buf, "/tmp");
#endif
      }
   if (*buf && *(pch = &buf[strlen(buf)-1]) != DIRSEP)
      {
      *(1+pch) = DIRSEP;
      *(2+pch) = 0;
      }

   return buf;
}

char *
GetTmpName (buf)
char       *buf;
{
   char  *pch;

   if (! *( GetTmpDir(buf) ))
      {
      return buf;
      }

   if ((pch = (char *)tempnam (buf, "MB_")) == NULL)
      {
      *buf = 0;
      return buf;
      }

   strcpy (buf, pch);
   return buf;
}

/*
 * SERVICE ROUTINES -----------------------------------------------------------
 *
 */

static void
_close_proc (rel)
relation    *rel;
{
   if (rel->ver > verLOWEST)
      {
      (void)mb_unl (rel);
      }

   if (rel->fhRel  > 0)  close (rel->fhRel);
   if (rel->fhLock > 0)  close (rel->fhLock);
   if (rel->fhDat  > 0)  close (rel->fhDat);

   free  (rel);
}


void
_Assert (err, name, line)
char    *err,*name;
long                line;
{
   fprintf (stderr, "\n\nAn assertion has failed during this operation!\n");
   fprintf (stderr, "    expression (%s) failed\n", err);
   fprintf (stderr, "    in file %s, on line %ld\n", name, line);
   fprintf (stderr, "Please write this down and contact me about this, so\n");
   fprintf (stderr, "that I can find and correct the problem.\n");
   (void)getchar();
}


void
_Corrupt (rel, fData)
relation *rel;
bool           fData;
{
   char  tchar;

   lseek (rel->fhRel, POS_WORKFLAG, 0);
   readx (rel->fhRel, &tchar, 1);

   if (fData)
      tchar |= 8;
   else
      tchar |= 4;

   lseek (rel->fhRel, POS_WORKFLAG, 0);
   writx (rel->fhRel, &tchar, 1);
}

