/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers;

import java.sql.SQLException;
import org.openrdf.sail.rdbms.managers.base.ValueManagerBase;
import org.openrdf.sail.rdbms.model.RdbmsURI;
import org.openrdf.sail.rdbms.schema.URITable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriManager
extends ValueManagerBase<RdbmsURI> {
    public static UriManager instance;
    private URITable table;

    public UriManager() {
        instance = this;
    }

    public void setUriTable(URITable shorter) {
        this.table = shorter;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.table.close();
    }

    @Override
    protected boolean expunge(String condition) throws SQLException {
        return this.table.expunge(condition);
    }

    @Override
    protected int getBatchSize() {
        return this.table.getBatchSize();
    }

    protected String key(RdbmsURI value) {
        return value.stringValue();
    }

    @Override
    protected void insert(Number id, RdbmsURI resource) throws SQLException, InterruptedException {
        String uri = resource.stringValue();
        if (this.getIdSequence().isLong(id)) {
            this.table.insertLong(id, uri);
        } else {
            this.table.insertShort(id, uri);
        }
    }

    @Override
    protected void optimize() throws SQLException {
        super.optimize();
        this.table.optimize();
    }
}

