/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import info.aduna.concurrent.locks.ExclusiveLockManager;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.ReadPrefReadWriteLockManager;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import java.io.File;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.memory.FileIO;
import org.openrdf.sail.memory.MemNamespaceStore;
import org.openrdf.sail.memory.MemoryStoreConnection;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementIterator;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.openrdf.sail.memory.model.ReadMode;
import org.openrdf.sail.memory.model.TxnStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStore
extends SailBase {
    protected static final String DATA_FILE_NAME = "memorystore.data";
    private MemValueFactory valueFactory;
    private MemStatementList statements;
    private IdentityHashMap<MemStatement, MemStatement> txnStatements;
    private int currentSnapshot;
    private MemNamespaceStore namespaceStore;
    private ReadWriteLockManager statementListLockManager;
    private ExclusiveLockManager txnLockManager;
    private boolean initialized = false;
    private boolean persist = false;
    private File dataFile;
    private boolean contentsChanged;
    private long syncDelay = 0L;
    private final Object syncSemaphore = new Object();
    private Timer syncTimer;
    private TimerTask syncTimerTask;
    private final Object syncTimerSemaphore = new Object();
    private Thread snapshotCleanupThread;
    private final Object snapshotCleanupThreadSemaphore = new Object();
    private boolean trackLocks = false;

    public MemoryStore() {
    }

    public MemoryStore(File dataDir) {
        this.setDataDir(dataDir);
        this.setPersist(true);
    }

    @Override
    public void setDataDir(File dataDir) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        super.setDataDir(dataDir);
    }

    public void setPersist(boolean persist) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.persist = persist;
    }

    public boolean getPersist() {
        return this.persist;
    }

    public void setSyncDelay(long syncDelay) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.syncDelay = syncDelay;
    }

    public long getSyncDelay() {
        return this.syncDelay;
    }

    @Override
    public void initialize() throws SailException {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been intialized");
        }
        this.logger.debug("Initializing MemoryStore...");
        this.statementListLockManager = new ReadPrefReadWriteLockManager(this.trackLocks);
        this.txnLockManager = new ExclusiveLockManager(this.trackLocks);
        this.namespaceStore = new MemNamespaceStore();
        this.valueFactory = new MemValueFactory();
        this.statements = new MemStatementList(256);
        this.currentSnapshot = 1;
        if (this.persist) {
            this.dataFile = new File(this.getDataDir(), DATA_FILE_NAME);
            if (this.dataFile.exists()) {
                this.logger.debug("Reading data from {}...", (Object)this.dataFile);
                if (!this.dataFile.canRead()) {
                    this.logger.error("Data file is not readable: {}", (Object)this.dataFile);
                    throw new SailException("Can't read data file: " + this.dataFile);
                }
                if (this.dataFile.length() == 0L) {
                    this.logger.warn("Ignoring empty data file: {}", (Object)this.dataFile);
                } else {
                    try {
                        FileIO.read(this, this.dataFile);
                        this.logger.debug("Data file read successfully");
                    }
                    catch (IOException e) {
                        this.logger.error("Failed to read data file", (Throwable)e);
                        throw new SailException(e);
                    }
                }
            } else {
                try {
                    File dir = this.dataFile.getParentFile();
                    if (dir != null && !dir.exists()) {
                        this.logger.debug("Creating directory for data file...");
                        if (!dir.mkdirs()) {
                            this.logger.debug("Failed to create directory for data file: {}", (Object)dir);
                            throw new SailException("Failed to create directory for data file: " + dir);
                        }
                    }
                    this.logger.debug("Initializing data file...");
                    FileIO.write(this, this.dataFile);
                    this.logger.debug("Data file initialized");
                }
                catch (IOException e) {
                    this.logger.debug("Failed to initialize data file", (Throwable)e);
                    throw new SailException("Failed to initialize data file " + this.dataFile, e);
                }
                catch (SailException e) {
                    this.logger.debug("Failed to initialize data file", (Throwable)e);
                    throw new SailException("Failed to initialize data file " + this.dataFile, e);
                }
            }
        }
        this.contentsChanged = false;
        this.initialized = true;
        this.logger.debug("MemoryStore initialized");
    }

    protected final boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutDownInternal() throws SailException {
        if (this.isInitialized()) {
            Lock stLock = this.getStatementsReadLock();
            try {
                this.cancelSyncTimer();
                this.sync();
                this.valueFactory = null;
                this.statements = null;
                this.dataFile = null;
                this.initialized = false;
            }
            finally {
                stLock.release();
            }
        }
    }

    @Override
    public boolean isWritable() {
        return this.dataFile == null || this.dataFile.canWrite();
    }

    @Override
    protected SailConnection getConnectionInternal() throws SailException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sail not initialized.");
        }
        return new MemoryStoreConnection(this);
    }

    @Override
    public MemValueFactory getValueFactory() {
        if (this.valueFactory == null) {
            throw new IllegalStateException("sail not initialized.");
        }
        return this.valueFactory;
    }

    protected MemNamespaceStore getNamespaceStore() {
        return this.namespaceStore;
    }

    protected MemStatementList getStatements() {
        return this.statements;
    }

    protected int getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    protected Lock getStatementsReadLock() throws SailException {
        try {
            return this.statementListLockManager.getReadLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected Lock getTransactionLock() throws SailException {
        try {
            return this.txnLockManager.getExclusiveLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected int size() {
        return this.statements.size();
    }

    protected <X extends Exception> CloseableIteration<MemStatement, X> createStatementIterator(Class<X> excClass, Resource subj, URI pred, Value obj, boolean explicitOnly, int snapshot, ReadMode readMode, Resource ... contexts) {
        MemStatementList l;
        MemStatementList smallestList;
        MemResource[] memContexts;
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return new EmptyIteration();
        }
        MemURI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return new EmptyIteration();
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return new EmptyIteration();
        }
        if (contexts.length == 0) {
            memContexts = new MemResource[]{};
            smallestList = this.statements;
        } else if (contexts.length == 1 && contexts[0] != null) {
            MemResource memContext = this.valueFactory.getMemResource(contexts[0]);
            if (memContext == null) {
                return new EmptyIteration();
            }
            memContexts = new MemResource[]{memContext};
            smallestList = memContext.getContextStatementList();
        } else {
            LinkedHashSet<MemResource> contextSet = new LinkedHashSet<MemResource>(2 * contexts.length);
            for (Resource context : contexts) {
                MemResource memContext = this.valueFactory.getMemResource(context);
                if (context != null && memContext == null) continue;
                contextSet.add(memContext);
            }
            if (contextSet.isEmpty()) {
                return new EmptyIteration();
            }
            memContexts = contextSet.toArray(new MemResource[contextSet.size()]);
            smallestList = this.statements;
        }
        if (memSubj != null && (l = memSubj.getSubjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memPred != null && (l = memPred.getPredicateStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memObj != null && (l = memObj.getObjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        return new MemStatementIterator(smallestList, memSubj, memPred, memObj, explicitOnly, snapshot, readMode, memContexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement addStatement(Resource subj, URI pred, Value obj, Resource context, boolean explicit) throws SailException {
        MemValue memObj;
        MemURI memPred;
        boolean newValueCreated = false;
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (memSubj == null) {
            memSubj = this.valueFactory.createMemResource(subj);
            newValueCreated = true;
        }
        if ((memPred = this.valueFactory.getMemURI(pred)) == null) {
            memPred = this.valueFactory.createMemURI(pred);
            newValueCreated = true;
        }
        if ((memObj = this.valueFactory.getMemValue(obj)) == null) {
            memObj = this.valueFactory.createMemValue(obj);
            newValueCreated = true;
        }
        MemResource memContext = this.valueFactory.getMemResource(context);
        if (context != null && memContext == null) {
            memContext = this.valueFactory.createMemResource(context);
            newValueCreated = true;
        }
        if (!newValueCreated) {
            CloseableIteration<MemStatement, SailException> stIter = this.createStatementIterator(SailException.class, memSubj, memPred, memObj, false, this.currentSnapshot + 1, ReadMode.RAW, memContext);
            try {
                if (stIter.hasNext()) {
                    MemStatement st = (MemStatement)stIter.next();
                    this.txnStatements.put(st, st);
                    TxnStatus txnStatus = st.getTxnStatus();
                    if (txnStatus == TxnStatus.NEUTRAL && !st.isExplicit() && explicit) {
                        st.setTxnStatus(TxnStatus.EXPLICIT);
                    } else if (txnStatus == TxnStatus.NEW && !st.isExplicit() && explicit) {
                        st.setExplicit(true);
                    } else {
                        if (txnStatus == TxnStatus.DEPRECATED) {
                            if (st.isExplicit() == explicit) {
                                st.setTxnStatus(TxnStatus.NEUTRAL);
                            } else if (explicit) {
                                st.setTxnStatus(TxnStatus.EXPLICIT);
                            } else {
                                st.setTxnStatus(TxnStatus.INFERRED);
                            }
                            MemStatement memStatement = st;
                            return memStatement;
                        }
                        if (txnStatus == TxnStatus.INFERRED && st.isExplicit() && explicit) {
                            st.setTxnStatus(TxnStatus.NEUTRAL);
                        } else if (txnStatus == TxnStatus.ZOMBIE) {
                            st.setTxnStatus(TxnStatus.NEW);
                            st.setExplicit(explicit);
                            MemStatement memStatement = st;
                            return memStatement;
                        }
                    }
                    Statement statement = null;
                    return statement;
                }
            }
            finally {
                stIter.close();
            }
        }
        MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, explicit, this.currentSnapshot + 1, TxnStatus.NEW);
        this.statements.add(st);
        st.addToComponentLists();
        this.txnStatements.put(st, st);
        return st;
    }

    protected boolean removeStatement(MemStatement st, boolean explicit) throws SailException {
        boolean statementsRemoved = false;
        TxnStatus txnStatus = st.getTxnStatus();
        if (txnStatus == TxnStatus.NEUTRAL && st.isExplicit() == explicit) {
            st.setTxnStatus(TxnStatus.DEPRECATED);
            statementsRemoved = true;
        } else if (txnStatus == TxnStatus.NEW && st.isExplicit() == explicit) {
            st.setTxnStatus(TxnStatus.ZOMBIE);
            statementsRemoved = true;
        } else if (txnStatus == TxnStatus.INFERRED && st.isExplicit() && !explicit) {
            st.setTxnStatus(TxnStatus.DEPRECATED);
            statementsRemoved = true;
        } else if (txnStatus == TxnStatus.EXPLICIT && !st.isExplicit() && explicit) {
            st.setTxnStatus(TxnStatus.NEUTRAL);
        }
        this.txnStatements.put(st, st);
        return statementsRemoved;
    }

    protected void startTransaction() throws SailException {
        this.cancelSyncTask();
        this.txnStatements = new IdentityHashMap();
    }

    protected void commit() throws SailException {
        boolean statementsAdded = false;
        boolean statementsRemoved = false;
        boolean statementsDeprecated = false;
        int txnSnapshot = this.currentSnapshot + 1;
        for (MemStatement st : this.txnStatements.keySet()) {
            TxnStatus txnStatus = st.getTxnStatus();
            if (txnStatus == TxnStatus.NEUTRAL) continue;
            if (txnStatus == TxnStatus.NEW) {
                statementsAdded = true;
            } else if (txnStatus == TxnStatus.DEPRECATED) {
                st.setTillSnapshot(txnSnapshot);
                statementsRemoved = true;
            } else if (txnStatus == TxnStatus.ZOMBIE) {
                st.setTillSnapshot(txnSnapshot);
                statementsDeprecated = true;
            } else if (txnStatus == TxnStatus.EXPLICIT || txnStatus == TxnStatus.INFERRED) {
                st.setTillSnapshot(txnSnapshot);
                statementsDeprecated = true;
                MemStatement explSt = new MemStatement(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext(), txnStatus == TxnStatus.EXPLICIT, txnSnapshot);
                this.statements.add(explSt);
                explSt.addToComponentLists();
            }
            st.setTxnStatus(TxnStatus.NEUTRAL);
        }
        this.txnStatements = null;
        if (statementsAdded || statementsRemoved || statementsDeprecated) {
            this.currentSnapshot = txnSnapshot;
        }
        if (statementsAdded || statementsRemoved) {
            this.contentsChanged = true;
            this.scheduleSyncTask();
            DefaultSailChangedEvent event = new DefaultSailChangedEvent(this);
            event.setStatementsAdded(statementsAdded);
            event.setStatementsRemoved(statementsRemoved);
            this.notifySailChanged(event);
        }
        if (statementsDeprecated) {
            this.scheduleSnapshotCleanup();
        }
    }

    protected void rollback() throws SailException {
        this.logger.debug("rolling back transaction");
        for (MemStatement st : this.txnStatements.keySet()) {
            TxnStatus txnStatus = st.getTxnStatus();
            if (txnStatus == TxnStatus.NEW || txnStatus == TxnStatus.ZOMBIE) {
                st.setTillSnapshot(this.currentSnapshot);
                continue;
            }
            if (txnStatus == TxnStatus.NEUTRAL) continue;
            st.setTxnStatus(TxnStatus.NEUTRAL);
        }
        this.txnStatements = null;
        this.scheduleSnapshotCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSyncTask() throws SailException {
        if (!this.persist) {
            return;
        }
        if (this.syncDelay == 0L) {
            this.sync();
        } else if (this.syncDelay > 0L) {
            Object object = this.syncTimerSemaphore;
            synchronized (object) {
                if (this.syncTimer == null) {
                    this.syncTimer = new Timer("MemoryStore synchronization", true);
                }
                if (this.syncTimerTask != null) {
                    this.logger.error("syncTimerTask is not null");
                }
                this.syncTimerTask = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Lock stLock = MemoryStore.this.getStatementsReadLock();
                            try {
                                MemoryStore.this.sync();
                            }
                            finally {
                                stLock.release();
                            }
                        }
                        catch (SailException e) {
                            MemoryStore.this.logger.warn("Unable to sync on timer", (Throwable)e);
                        }
                    }
                };
                this.syncTimer.schedule(this.syncTimerTask, this.syncDelay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSyncTask() {
        Object object = this.syncTimerSemaphore;
        synchronized (object) {
            if (this.syncTimerTask != null) {
                this.syncTimerTask.cancel();
                this.syncTimerTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSyncTimer() {
        Object object = this.syncTimerSemaphore;
        synchronized (object) {
            if (this.syncTimer != null) {
                this.syncTimer.cancel();
                this.syncTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws SailException {
        Object object = this.syncSemaphore;
        synchronized (object) {
            if (this.persist && this.contentsChanged) {
                this.logger.debug("syncing data to file...");
                try {
                    FileIO.write(this, this.dataFile);
                    this.contentsChanged = false;
                    this.logger.debug("Data synced to file");
                }
                catch (IOException e) {
                    this.logger.error("Failed to sync to file", (Throwable)e);
                    throw new SailException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSnapshots() throws InterruptedException {
        MemStatementList statements = this.statements;
        if (statements == null) {
            return;
        }
        Lock stLock = this.statementListLockManager.getWriteLock();
        try {
            for (int i = statements.size() - 1; i >= 0; --i) {
                MemStatement st = statements.get(i);
                if (st.getTillSnapshot() <= this.currentSnapshot) {
                    st.removeFromComponentLists();
                    statements.remove(i);
                    continue;
                }
                st.setSinceSnapshot(1);
            }
            this.currentSnapshot = 1;
        }
        finally {
            stLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSnapshotCleanup() {
        Object object = this.snapshotCleanupThreadSemaphore;
        synchronized (object) {
            if (this.snapshotCleanupThread == null || !this.snapshotCleanupThread.isAlive()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            MemoryStore.this.cleanSnapshots();
                        }
                        catch (InterruptedException e) {
                            MemoryStore.this.logger.warn("snapshot cleanup interrupted");
                        }
                    }
                };
                this.snapshotCleanupThread = new Thread(runnable, "MemoryStore snapshot cleanup");
                this.snapshotCleanupThread.setDaemon(true);
                this.snapshotCleanupThread.start();
            }
        }
    }
}

