/*
 *  preferencesdlg.h - part of KImageShop^WKrita
 *
 *  Copyright (c) 1999 Michael Koch <koch@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __preferencesdlg_h__
#define __preferencesdlg_h__

#include <qwidget.h>

#include <kdialogbase.h>

#include "kis_global.h"

class QLineEdit;
class QCheckBox;
class KURLRequester;
class WdgColorSettings;
class KisCmbIDList;
class KisID;

/**
 *  "General"-tab for preferences dialog
 */
class GeneralTab : public QWidget
{
	Q_OBJECT

public:

	GeneralTab( QWidget *parent = 0, const char *name = 0 );

	bool saveOnExit();
	enumCursorStyle cursorStyle();
	void setDefault();
private:

	QCheckBox *m_saveOnExit;
	QComboBox *m_cmbCursorShape;
};


//=======================

/**
 *  "Directories"-tab for preferences dialog
 */
class DirectoriesTab : public QWidget
{
	Q_OBJECT

public:

	DirectoriesTab( QWidget *parent = 0, const char *name = 0 );
	void setDefault();

private slots:

        void slotRequesterClicked( KURLRequester * );

private:

	KURLRequester *m_pLineEdit, *m_pGimpGradients;
};

//=======================

class UndoRedoTab : public QWidget
{
	Q_OBJECT

public:
	void setDefault();

	UndoRedoTab( QWidget *parent = 0, const char *name = 0 );
};

//=======================

class ColorSettingsTab : public QWidget
{
	Q_OBJECT

public:
	
	ColorSettingsTab( QWidget *parent = 0, const char * name = 0 );

private slots:

	void refillMonitorProfiles(const KisID & s);
	void refillPrintProfiles(const KisID & s);
	void refillImportProfiles(const KisID & s);

public:
	void setDefault();

	WdgColorSettings * m_page;
};


//=======================

/**
 *  Preferences dialog of KImageShop^WKrayon^WKrita
 */
class PreferencesDialog : public KDialogBase
{
	Q_OBJECT

public:

	static void editPreferences();


protected:

	PreferencesDialog( QWidget *parent = 0, const char *name = 0 );
	~PreferencesDialog();

protected:

	GeneralTab* m_general;
	DirectoriesTab* m_directories;
	UndoRedoTab* m_undoRedo; 
	ColorSettingsTab* m_colorSettings;
protected slots:
    void slotDefault();
};

#endif
